/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.StartupTime;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.session.PerfSession;
import com.google.firebase.perf.session.SessionManager;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.util.FirstDrawDoneListener;
import com.google.firebase.perf.util.PreDrawListener;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.v1.ApplicationProcessState;
import com.google.firebase.perf.v1.TraceMetric;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AppStartTrace
implements Application.ActivityLifecycleCallbacks,
LifecycleObserver {
    @NonNull
    private static final Timer PERF_CLASS_LOAD_TIME = new Clock().getTime();
    private static final long MAX_LATENCY_BEFORE_UI_INIT = TimeUnit.MINUTES.toMicros(1L);
    private static final int CORE_POOL_SIZE = 0;
    private static final int MAX_POOL_SIZE = 1;
    private static volatile AppStartTrace instance;
    private static ExecutorService executorService;
    private boolean isRegisteredForLifecycleCallbacks = false;
    private final TransportManager transportManager;
    private final Clock clock;
    private final ConfigResolver configResolver;
    private final TraceMetric.Builder experimentTtid;
    private Context appContext;
    private WeakReference<Activity> launchActivity;
    private WeakReference<Activity> appStartActivity;
    private boolean isTooLateToInitUI = false;
    @Nullable
    private final Timer processStartTime;
    @Nullable
    private final Timer firebaseClassLoadTime;
    private Timer onCreateTime = null;
    private Timer onStartTime = null;
    private Timer onResumeTime = null;
    private Timer firstForegroundTime = null;
    @Nullable
    private Timer firstBackgroundTime = null;
    private Timer preDrawPostTime = null;
    private Timer preDrawPostAtFrontOfQueueTime = null;
    private Timer onDrawPostAtFrontOfQueueTime = null;
    private PerfSession startSession;
    private boolean isStartedFromBackground = false;
    private int onDrawCount = 0;
    private final DrawCounter onDrawCounterListener = new DrawCounter();
    private boolean systemForegroundCheck = false;

    @Keep
    public static void setLauncherActivityOnCreateTime(String activity) {
    }

    @Keep
    public static void setLauncherActivityOnStartTime(String activity) {
    }

    @Keep
    public static void setLauncherActivityOnResumeTime(String activity) {
    }

    public static AppStartTrace getInstance() {
        return instance != null ? instance : AppStartTrace.getInstance(TransportManager.getInstance(), new Clock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"ThreadPoolCreation"})
    static AppStartTrace getInstance(TransportManager transportManager, Clock clock) {
        if (instance != null) return instance;
        Class<AppStartTrace> clazz = AppStartTrace.class;
        synchronized (AppStartTrace.class) {
            if (instance != null) return instance;
            instance = new AppStartTrace(transportManager, clock, ConfigResolver.getInstance(), new ThreadPoolExecutor(0, 1, MAX_LATENCY_BEFORE_UI_INIT + 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    AppStartTrace(@NonNull TransportManager transportManager, @NonNull Clock clock, @NonNull ConfigResolver configResolver, @NonNull ExecutorService executorService) {
        this.transportManager = transportManager;
        this.clock = clock;
        this.configResolver = configResolver;
        AppStartTrace.executorService = executorService;
        this.experimentTtid = TraceMetric.newBuilder().setName("_experiment_app_start_ttid");
        this.processStartTime = Build.VERSION.SDK_INT >= 24 ? Timer.ofElapsedRealtime(Process.getStartElapsedRealtime()) : null;
        StartupTime firebaseStart = (StartupTime)FirebaseApp.getInstance().get(StartupTime.class);
        this.firebaseClassLoadTime = firebaseStart != null ? Timer.ofElapsedRealtime(firebaseStart.getElapsedRealtime()) : null;
    }

    public synchronized void registerActivityLifecycleCallbacks(@NonNull Context context) {
        if (this.isRegisteredForLifecycleCallbacks) {
            return;
        }
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
        Context appContext = context.getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.systemForegroundCheck = this.systemForegroundCheck || AppStartTrace.isAnyAppProcessInForeground(appContext);
            this.isRegisteredForLifecycleCallbacks = true;
            this.appContext = appContext;
        }
    }

    public synchronized void unregisterActivityLifecycleCallbacks() {
        if (!this.isRegisteredForLifecycleCallbacks) {
            return;
        }
        ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)this);
        ((Application)this.appContext).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.isRegisteredForLifecycleCallbacks = false;
    }

    @NonNull
    private Timer getStartTimerCompat() {
        if (this.processStartTime != null) {
            return this.processStartTime;
        }
        return this.getClassLoadTimeCompat();
    }

    @NonNull
    private Timer getClassLoadTimeCompat() {
        if (this.firebaseClassLoadTime != null) {
            return this.firebaseClassLoadTime;
        }
        return PERF_CLASS_LOAD_TIME;
    }

    private void recordPreDraw() {
        if (this.preDrawPostTime != null) {
            return;
        }
        this.preDrawPostTime = this.clock.getTime();
        this.experimentTtid.setClientStartTimeUs(this.getStartTimerCompat().getMicros()).setDurationUs(this.getStartTimerCompat().getDurationMicros(this.preDrawPostTime));
        this.logExperimentTrace(this.experimentTtid);
    }

    private void recordPreDrawFrontOfQueue() {
        if (this.preDrawPostAtFrontOfQueueTime != null) {
            return;
        }
        this.preDrawPostAtFrontOfQueueTime = this.clock.getTime();
        this.experimentTtid.addSubtraces((TraceMetric)TraceMetric.newBuilder().setName("_experiment_preDrawFoQ").setClientStartTimeUs(this.getStartTimerCompat().getMicros()).setDurationUs(this.getStartTimerCompat().getDurationMicros(this.preDrawPostAtFrontOfQueueTime)).build());
        this.logExperimentTrace(this.experimentTtid);
    }

    private void recordOnDrawFrontOfQueue() {
        if (this.onDrawPostAtFrontOfQueueTime != null) {
            return;
        }
        this.onDrawPostAtFrontOfQueueTime = this.clock.getTime();
        this.experimentTtid.addSubtraces((TraceMetric)TraceMetric.newBuilder().setName("_experiment_onDrawFoQ").setClientStartTimeUs(this.getStartTimerCompat().getMicros()).setDurationUs(this.getStartTimerCompat().getDurationMicros(this.onDrawPostAtFrontOfQueueTime)).build());
        if (this.processStartTime != null) {
            this.experimentTtid.addSubtraces((TraceMetric)TraceMetric.newBuilder().setName("_experiment_procStart_to_classLoad").setClientStartTimeUs(this.getStartTimerCompat().getMicros()).setDurationUs(this.getStartTimerCompat().getDurationMicros(this.getClassLoadTimeCompat())).build());
        }
        this.experimentTtid.putCustomAttributes("systemDeterminedForeground", this.systemForegroundCheck ? "true" : "false");
        this.experimentTtid.putCounters("onDrawCount", this.onDrawCount);
        this.experimentTtid.addPerfSessions(this.startSession.build());
        this.logExperimentTrace(this.experimentTtid);
    }

    public synchronized void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.isStartedFromBackground || this.onCreateTime != null) {
            return;
        }
        this.systemForegroundCheck = this.systemForegroundCheck || AppStartTrace.isAnyAppProcessInForeground(this.appContext);
        this.launchActivity = new WeakReference<Activity>(activity);
        this.onCreateTime = this.clock.getTime();
        if (this.getStartTimerCompat().getDurationMicros(this.onCreateTime) > MAX_LATENCY_BEFORE_UI_INIT) {
            this.isTooLateToInitUI = true;
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.isStartedFromBackground || this.onStartTime != null || this.isTooLateToInitUI) {
            return;
        }
        this.onStartTime = this.clock.getTime();
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.isStartedFromBackground || this.isTooLateToInitUI) {
            return;
        }
        boolean isExperimentTTIDEnabled = this.configResolver.getIsExperimentTTIDEnabled();
        if (isExperimentTTIDEnabled) {
            View rootView = activity.findViewById(0x1020002);
            rootView.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)this.onDrawCounterListener);
            FirstDrawDoneListener.registerForNextDraw(rootView, this::recordOnDrawFrontOfQueue);
            PreDrawListener.registerForNextDraw(rootView, this::recordPreDraw, this::recordPreDrawFrontOfQueue);
        }
        if (this.onResumeTime != null) {
            return;
        }
        this.appStartActivity = new WeakReference<Activity>(activity);
        this.onResumeTime = this.clock.getTime();
        this.startSession = SessionManager.getInstance().perfSession();
        AndroidLogger.getInstance().debug("onResume(): " + activity.getClass().getName() + ": " + this.getClassLoadTimeCompat().getDurationMicros(this.onResumeTime) + " microseconds");
        executorService.execute(this::logAppStartTrace);
        if (!isExperimentTTIDEnabled) {
            this.unregisterActivityLifecycleCallbacks();
        }
    }

    private void logExperimentTrace(TraceMetric.Builder metric) {
        if (this.preDrawPostTime == null || this.preDrawPostAtFrontOfQueueTime == null || this.onDrawPostAtFrontOfQueueTime == null) {
            return;
        }
        executorService.execute(() -> this.transportManager.log((TraceMetric)metric.build(), ApplicationProcessState.FOREGROUND_BACKGROUND));
        this.unregisterActivityLifecycleCallbacks();
    }

    private void logAppStartTrace() {
        TraceMetric.Builder metric = TraceMetric.newBuilder().setName(Constants.TraceNames.APP_START_TRACE_NAME.toString()).setClientStartTimeUs(this.getClassLoadTimeCompat().getMicros()).setDurationUs(this.getClassLoadTimeCompat().getDurationMicros(this.onResumeTime));
        ArrayList<TraceMetric> subtraces = new ArrayList<TraceMetric>(3);
        TraceMetric.Builder traceMetricBuilder = TraceMetric.newBuilder().setName(Constants.TraceNames.ON_CREATE_TRACE_NAME.toString()).setClientStartTimeUs(this.getClassLoadTimeCompat().getMicros()).setDurationUs(this.getClassLoadTimeCompat().getDurationMicros(this.onCreateTime));
        subtraces.add((TraceMetric)traceMetricBuilder.build());
        traceMetricBuilder = TraceMetric.newBuilder();
        traceMetricBuilder.setName(Constants.TraceNames.ON_START_TRACE_NAME.toString()).setClientStartTimeUs(this.onCreateTime.getMicros()).setDurationUs(this.onCreateTime.getDurationMicros(this.onStartTime));
        subtraces.add((TraceMetric)traceMetricBuilder.build());
        traceMetricBuilder = TraceMetric.newBuilder();
        traceMetricBuilder.setName(Constants.TraceNames.ON_RESUME_TRACE_NAME.toString()).setClientStartTimeUs(this.onStartTime.getMicros()).setDurationUs(this.onStartTime.getDurationMicros(this.onResumeTime));
        subtraces.add((TraceMetric)traceMetricBuilder.build());
        metric.addAllSubtraces(subtraces).addPerfSessions(this.startSession.build());
        this.transportManager.log((TraceMetric)metric.build(), ApplicationProcessState.FOREGROUND_BACKGROUND);
    }

    public void onActivityPaused(Activity activity) {
        if (this.isStartedFromBackground || this.isTooLateToInitUI || !this.configResolver.getIsExperimentTTIDEnabled()) {
            return;
        }
        View rootView = activity.findViewById(0x1020002);
        rootView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.onDrawCounterListener);
    }

    public void onActivityStopped(Activity activity) {
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    @Keep
    public void onAppEnteredForeground() {
        if (this.isStartedFromBackground || this.isTooLateToInitUI || this.firstForegroundTime != null) {
            return;
        }
        this.firstForegroundTime = this.clock.getTime();
        this.experimentTtid.addSubtraces((TraceMetric)TraceMetric.newBuilder().setName("_experiment_firstForegrounding").setClientStartTimeUs(this.getStartTimerCompat().getMicros()).setDurationUs(this.getStartTimerCompat().getDurationMicros(this.firstForegroundTime)).build());
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    @Keep
    public void onAppEnteredBackground() {
        if (this.isStartedFromBackground || this.isTooLateToInitUI || this.firstBackgroundTime != null) {
            return;
        }
        this.firstBackgroundTime = this.clock.getTime();
        this.experimentTtid.addSubtraces((TraceMetric)TraceMetric.newBuilder().setName("_experiment_firstBackgrounding").setClientStartTimeUs(this.getStartTimerCompat().getMicros()).setDurationUs(this.getStartTimerCompat().getDurationMicros(this.firstBackgroundTime)).build());
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public static boolean isAnyAppProcessInForeground(Context appContext) {
        ActivityManager activityManager = (ActivityManager)appContext.getSystemService("activity");
        if (activityManager == null) {
            return true;
        }
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses != null) {
            String appProcessName = appContext.getPackageName();
            String allowedAppProcessNamePrefix = appProcessName + ":";
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (appProcess.importance != 100 || !appProcess.processName.equals(appProcessName) && !appProcess.processName.startsWith(allowedAppProcessNamePrefix)) continue;
                boolean isAppInForeground = true;
                if (Build.VERSION.SDK_INT < 23) {
                    isAppInForeground = AppStartTrace.isScreenOn(appContext);
                }
                if (!isAppInForeground) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isScreenOn(Context appContext) {
        PowerManager powerManager = (PowerManager)appContext.getSystemService("power");
        if (powerManager == null) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 20 ? powerManager.isInteractive() : powerManager.isScreenOn();
    }

    @VisibleForTesting
    @Nullable
    Activity getLaunchActivity() {
        return (Activity)this.launchActivity.get();
    }

    @VisibleForTesting
    @Nullable
    Activity getAppStartActivity() {
        return (Activity)this.appStartActivity.get();
    }

    @VisibleForTesting
    Timer getOnCreateTime() {
        return this.onCreateTime;
    }

    @VisibleForTesting
    Timer getOnStartTime() {
        return this.onStartTime;
    }

    @VisibleForTesting
    Timer getOnResumeTime() {
        return this.onResumeTime;
    }

    @VisibleForTesting
    void setIsStartFromBackground() {
        this.isStartedFromBackground = true;
    }

    private final class DrawCounter
    implements ViewTreeObserver.OnDrawListener {
        private DrawCounter() {
        }

        public void onDraw() {
            AppStartTrace.this.onDrawCount++;
        }
    }

    public static class StartFromBackgroundRunnable
    implements Runnable {
        private final AppStartTrace trace;

        public StartFromBackgroundRunnable(AppStartTrace trace) {
            this.trace = trace;
        }

        @Override
        public void run() {
            if (this.trace.onCreateTime == null) {
                this.trace.isStartedFromBackground = true;
            }
        }
    }
}

