/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import androidx.annotation.NonNull;
import com.google.firebase.perf.metrics.Counter;
import com.google.firebase.perf.metrics.Trace;
import com.google.firebase.perf.v1.PerfSession;
import com.google.firebase.perf.v1.TraceMetric;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class TraceMetricBuilder {
    private final Trace trace;

    TraceMetricBuilder(@NonNull Trace trace) {
        this.trace = trace;
    }

    TraceMetric build() {
        TraceMetric.Builder traceMetric = TraceMetric.newBuilder().setName(this.trace.getName()).setClientStartTimeUs(this.trace.getStartTime().getMicros()).setDurationUs(this.trace.getStartTime().getDurationMicros(this.trace.getEndTime()));
        Map<String, Counter> traceCounters = this.trace.getCounters();
        for (Counter counter : traceCounters.values()) {
            traceMetric.putCounters(counter.getName(), counter.getCount());
        }
        List<Trace> subTraces = this.trace.getSubtraces();
        if (!subTraces.isEmpty()) {
            for (Trace subtrace : subTraces) {
                traceMetric.addSubtraces(new TraceMetricBuilder(subtrace).build());
            }
        }
        traceMetric.putAllCustomAttributes(this.trace.getAttributes());
        PerfSession[] perfSessionArray = com.google.firebase.perf.session.PerfSession.buildAndSort(this.trace.getSessions());
        if (perfSessionArray != null) {
            traceMetric.addAllPerfSessions(Arrays.asList(perfSessionArray));
        }
        return (TraceMetric)traceMetric.build();
    }
}

