/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.logging;

import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.logging.LogWrapper;
import java.util.Locale;

public class AndroidLogger {
    private static volatile AndroidLogger instance;
    private final LogWrapper logWrapper;
    private boolean isLogcatEnabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AndroidLogger getInstance() {
        if (instance != null) return instance;
        Class<AndroidLogger> clazz = AndroidLogger.class;
        synchronized (AndroidLogger.class) {
            if (instance != null) return instance;
            instance = new AndroidLogger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    public AndroidLogger(LogWrapper logWrapper) {
        this.logWrapper = logWrapper == null ? LogWrapper.getInstance() : logWrapper;
    }

    private AndroidLogger() {
        this(null);
    }

    public void setLogcatEnabled(boolean logcatEnabled) {
        this.isLogcatEnabled = logcatEnabled;
    }

    public boolean isLogcatEnabled() {
        return this.isLogcatEnabled;
    }

    public void debug(String msg) {
        if (this.isLogcatEnabled) {
            this.logWrapper.d(msg);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isLogcatEnabled) {
            this.logWrapper.d(String.format(Locale.ENGLISH, format, args));
        }
    }

    public void verbose(String msg) {
        if (this.isLogcatEnabled) {
            this.logWrapper.v(msg);
        }
    }

    public void verbose(String format, Object ... args) {
        if (this.isLogcatEnabled) {
            this.logWrapper.v(String.format(Locale.ENGLISH, format, args));
        }
    }

    public void info(String msg) {
        if (this.isLogcatEnabled) {
            this.logWrapper.i(msg);
        }
    }

    public void info(String format, Object ... args) {
        if (this.isLogcatEnabled) {
            this.logWrapper.i(String.format(Locale.ENGLISH, format, args));
        }
    }

    public void warn(String msg) {
        if (this.isLogcatEnabled) {
            this.logWrapper.w(msg);
        }
    }

    public void warn(String format, Object ... args) {
        if (this.isLogcatEnabled) {
            this.logWrapper.w(String.format(Locale.ENGLISH, format, args));
        }
    }

    public void error(String msg) {
        if (this.isLogcatEnabled) {
            this.logWrapper.e(msg);
        }
    }

    public void error(String format, Object ... args) {
        if (this.isLogcatEnabled) {
            this.logWrapper.e(String.format(Locale.ENGLISH, format, args));
        }
    }
}

