/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics.validator;

import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.validator.PerfMetricValidator;
import com.google.firebase.perf.v1.ApplicationInfo;

public class FirebasePerfApplicationInfoValidator
extends PerfMetricValidator {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final ApplicationInfo applicationInfo;

    FirebasePerfApplicationInfoValidator(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    @Override
    public boolean isValidPerfMetric() {
        if (!this.isValidApplicationInfo()) {
            logger.warn("ApplicationInfo is invalid");
            return false;
        }
        return true;
    }

    private boolean isValidApplicationInfo() {
        if (this.applicationInfo == null) {
            logger.warn("ApplicationInfo is null");
            return false;
        }
        if (!this.applicationInfo.hasGoogleAppId()) {
            logger.warn("GoogleAppId is null");
            return false;
        }
        if (!this.applicationInfo.hasAppInstanceId()) {
            logger.warn("AppInstanceId is null");
            return false;
        }
        if (!this.applicationInfo.hasApplicationProcessState()) {
            logger.warn("ApplicationProcessState is null");
            return false;
        }
        if (this.applicationInfo.hasAndroidAppInfo()) {
            if (!this.applicationInfo.getAndroidAppInfo().hasPackageName()) {
                logger.warn("AndroidAppInfo.packageName is null");
                return false;
            }
            if (!this.applicationInfo.getAndroidAppInfo().hasSdkVersion()) {
                logger.warn("AndroidAppInfo.sdkVersion is null");
                return false;
            }
        }
        return true;
    }
}

