/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.session.gauges;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Process;
import android.system.Os;
import android.system.OsConstants;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.v1.CpuMetricReading;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CpuGaugeCollector {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    public static final long INVALID_CPU_COLLECTION_FREQUENCY = -1L;
    private static final int INVALID_SC_PER_CPU_CLOCK_TICK = -1;
    private static final int UNSET_CPU_METRIC_COLLECTION_RATE = -1;
    private static final int UTIME_POSITION_IN_PROC_PID_STAT = 13;
    private static final int STIME_POSITION_IN_PROC_PID_STAT = 14;
    private static final int CUTIME_POSITION_IN_PROC_PID_STAT = 15;
    private static final int CSTIME_POSITION_IN_PROC_PID_STAT = 16;
    private static final long MICROSECONDS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
    public final ConcurrentLinkedQueue<CpuMetricReading> cpuMetricReadings = new ConcurrentLinkedQueue();
    private final ScheduledExecutorService cpuMetricCollectorExecutor;
    private final String procFileName;
    private final long clockTicksPerSecond;
    @Nullable
    private ScheduledFuture cpuMetricCollectorJob = null;
    private long cpuMetricCollectionRateMs = -1L;

    @SuppressLint(value={"ThreadPoolCreation"})
    CpuGaugeCollector() {
        this.cpuMetricCollectorExecutor = Executors.newSingleThreadScheduledExecutor();
        int pid = Process.myPid();
        this.procFileName = "/proc/" + Integer.toString(pid) + "/stat";
        this.clockTicksPerSecond = this.getClockTicksPerSecond();
    }

    @VisibleForTesting
    CpuGaugeCollector(ScheduledExecutorService cpuMetricCollectorExecutor, String fakeProcFileName, long clockTicksPerSecond) {
        this.cpuMetricCollectorExecutor = cpuMetricCollectorExecutor;
        this.procFileName = fakeProcFileName;
        this.clockTicksPerSecond = clockTicksPerSecond;
    }

    public void startCollecting(long cpuMetricCollectionRateMs, Timer referenceTime) {
        if (this.clockTicksPerSecond == -1L || this.clockTicksPerSecond == 0L) {
            return;
        }
        if (CpuGaugeCollector.isInvalidCollectionFrequency(cpuMetricCollectionRateMs)) {
            return;
        }
        if (this.cpuMetricCollectorJob != null) {
            if (this.cpuMetricCollectionRateMs != cpuMetricCollectionRateMs) {
                this.stopCollecting();
                this.scheduleCpuMetricCollectionWithRate(cpuMetricCollectionRateMs, referenceTime);
            }
            return;
        }
        this.scheduleCpuMetricCollectionWithRate(cpuMetricCollectionRateMs, referenceTime);
    }

    public void stopCollecting() {
        if (this.cpuMetricCollectorJob == null) {
            return;
        }
        this.cpuMetricCollectorJob.cancel(false);
        this.cpuMetricCollectorJob = null;
        this.cpuMetricCollectionRateMs = -1L;
    }

    public void collectOnce(Timer referenceTime) {
        this.scheduleCpuMetricCollectionOnce(referenceTime);
    }

    private synchronized void scheduleCpuMetricCollectionWithRate(long cpuMetricCollectionRate, Timer referenceTime) {
        this.cpuMetricCollectionRateMs = cpuMetricCollectionRate;
        try {
            this.cpuMetricCollectorJob = this.cpuMetricCollectorExecutor.scheduleAtFixedRate(() -> {
                CpuMetricReading currCpuReading = this.syncCollectCpuMetric(referenceTime);
                if (currCpuReading != null) {
                    this.cpuMetricReadings.add(currCpuReading);
                }
            }, 0L, cpuMetricCollectionRate, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            logger.warn("Unable to start collecting Cpu Metrics: " + e.getMessage());
        }
    }

    private synchronized void scheduleCpuMetricCollectionOnce(Timer referenceTime) {
        try {
            ScheduledFuture<?> scheduledFuture = this.cpuMetricCollectorExecutor.schedule(() -> {
                CpuMetricReading currCpuReading = this.syncCollectCpuMetric(referenceTime);
                if (currCpuReading != null) {
                    this.cpuMetricReadings.add(currCpuReading);
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            logger.warn("Unable to collect Cpu Metric: " + e.getMessage());
        }
    }

    @Nullable
    private CpuMetricReading syncCollectCpuMetric(Timer referenceTime) {
        block9: {
            CpuMetricReading cpuMetricReading;
            if (referenceTime == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.procFileName));
            try {
                long cpuMetricTimestampUs = referenceTime.getCurrentTimestampMicros();
                String procPidStatFileContents = bufferedReader.readLine();
                String[] procFileTokens = procPidStatFileContents.split(" ");
                long utime = Long.parseLong(procFileTokens[13]);
                long cutime = Long.parseLong(procFileTokens[15]);
                long stime = Long.parseLong(procFileTokens[14]);
                long cstime = Long.parseLong(procFileTokens[16]);
                cpuMetricReading = (CpuMetricReading)CpuMetricReading.newBuilder().setClientTimeUs(cpuMetricTimestampUs).setSystemTimeUs(this.convertClockTicksToMicroseconds(stime + cstime)).setUserTimeUs(this.convertClockTicksToMicroseconds(utime + cutime)).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn("Unable to read 'proc/[pid]/stat' file: " + e.getMessage());
                    break block9;
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
                    logger.warn("Unexpected '/proc/[pid]/stat' file format encountered: " + e.getMessage());
                }
            }
            bufferedReader.close();
            return cpuMetricReading;
        }
        return null;
    }

    private long getClockTicksPerSecond() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Os.sysconf((int)OsConstants._SC_CLK_TCK);
        }
        return -1L;
    }

    private long convertClockTicksToMicroseconds(long clockTicks) {
        return Math.round((double)clockTicks / (double)this.clockTicksPerSecond * (double)MICROSECONDS_PER_SECOND);
    }

    public static boolean isInvalidCollectionFrequency(long collectionFrequency) {
        return collectionFrequency <= 0L;
    }
}

