/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import com.google.firebase.sessions.AndroidApplicationInfo;
import com.google.firebase.sessions.ApplicationInfo;
import com.google.firebase.sessions.DataCollectionStatus;
import com.google.firebase.sessions.SessionEvent;
import com.google.firebase.sessions.SessionInfo;
import java.io.IOException;

public final class AutoSessionEventEncoder
implements Configurator {
    public static final int CODEGEN_VERSION = 2;
    public static final Configurator CONFIG = new AutoSessionEventEncoder();

    private AutoSessionEventEncoder() {
    }

    public void configure(EncoderConfig<?> cfg) {
        cfg.registerEncoder(SessionEvent.class, (ObjectEncoder)SessionEventEncoder.INSTANCE);
        cfg.registerEncoder(SessionInfo.class, (ObjectEncoder)SessionInfoEncoder.INSTANCE);
        cfg.registerEncoder(DataCollectionStatus.class, (ObjectEncoder)DataCollectionStatusEncoder.INSTANCE);
        cfg.registerEncoder(ApplicationInfo.class, (ObjectEncoder)ApplicationInfoEncoder.INSTANCE);
        cfg.registerEncoder(AndroidApplicationInfo.class, (ObjectEncoder)AndroidApplicationInfoEncoder.INSTANCE);
    }

    private static final class AndroidApplicationInfoEncoder
    implements ObjectEncoder<AndroidApplicationInfo> {
        static final AndroidApplicationInfoEncoder INSTANCE = new AndroidApplicationInfoEncoder();
        private static final FieldDescriptor PACKAGENAME_DESCRIPTOR = FieldDescriptor.of((String)"packageName");
        private static final FieldDescriptor VERSIONNAME_DESCRIPTOR = FieldDescriptor.of((String)"versionName");
        private static final FieldDescriptor APPBUILDVERSION_DESCRIPTOR = FieldDescriptor.of((String)"appBuildVersion");
        private static final FieldDescriptor DEVICEMANUFACTURER_DESCRIPTOR = FieldDescriptor.of((String)"deviceManufacturer");

        private AndroidApplicationInfoEncoder() {
        }

        public void encode(AndroidApplicationInfo value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(PACKAGENAME_DESCRIPTOR, (Object)value.getPackageName());
            ctx.add(VERSIONNAME_DESCRIPTOR, (Object)value.getVersionName());
            ctx.add(APPBUILDVERSION_DESCRIPTOR, (Object)value.getAppBuildVersion());
            ctx.add(DEVICEMANUFACTURER_DESCRIPTOR, (Object)value.getDeviceManufacturer());
        }
    }

    private static final class ApplicationInfoEncoder
    implements ObjectEncoder<ApplicationInfo> {
        static final ApplicationInfoEncoder INSTANCE = new ApplicationInfoEncoder();
        private static final FieldDescriptor APPID_DESCRIPTOR = FieldDescriptor.of((String)"appId");
        private static final FieldDescriptor DEVICEMODEL_DESCRIPTOR = FieldDescriptor.of((String)"deviceModel");
        private static final FieldDescriptor SESSIONSDKVERSION_DESCRIPTOR = FieldDescriptor.of((String)"sessionSdkVersion");
        private static final FieldDescriptor OSVERSION_DESCRIPTOR = FieldDescriptor.of((String)"osVersion");
        private static final FieldDescriptor LOGENVIRONMENT_DESCRIPTOR = FieldDescriptor.of((String)"logEnvironment");
        private static final FieldDescriptor ANDROIDAPPINFO_DESCRIPTOR = FieldDescriptor.of((String)"androidAppInfo");

        private ApplicationInfoEncoder() {
        }

        public void encode(ApplicationInfo value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(APPID_DESCRIPTOR, (Object)value.getAppId());
            ctx.add(DEVICEMODEL_DESCRIPTOR, (Object)value.getDeviceModel());
            ctx.add(SESSIONSDKVERSION_DESCRIPTOR, (Object)value.getSessionSdkVersion());
            ctx.add(OSVERSION_DESCRIPTOR, (Object)value.getOsVersion());
            ctx.add(LOGENVIRONMENT_DESCRIPTOR, (Object)value.getLogEnvironment());
            ctx.add(ANDROIDAPPINFO_DESCRIPTOR, (Object)value.getAndroidAppInfo());
        }
    }

    private static final class DataCollectionStatusEncoder
    implements ObjectEncoder<DataCollectionStatus> {
        static final DataCollectionStatusEncoder INSTANCE = new DataCollectionStatusEncoder();
        private static final FieldDescriptor PERFORMANCE_DESCRIPTOR = FieldDescriptor.of((String)"performance");
        private static final FieldDescriptor CRASHLYTICS_DESCRIPTOR = FieldDescriptor.of((String)"crashlytics");
        private static final FieldDescriptor SESSIONSAMPLINGRATE_DESCRIPTOR = FieldDescriptor.of((String)"sessionSamplingRate");

        private DataCollectionStatusEncoder() {
        }

        public void encode(DataCollectionStatus value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(PERFORMANCE_DESCRIPTOR, (Object)value.getPerformance());
            ctx.add(CRASHLYTICS_DESCRIPTOR, (Object)value.getCrashlytics());
            ctx.add(SESSIONSAMPLINGRATE_DESCRIPTOR, value.getSessionSamplingRate());
        }
    }

    private static final class SessionInfoEncoder
    implements ObjectEncoder<SessionInfo> {
        static final SessionInfoEncoder INSTANCE = new SessionInfoEncoder();
        private static final FieldDescriptor SESSIONID_DESCRIPTOR = FieldDescriptor.of((String)"sessionId");
        private static final FieldDescriptor FIRSTSESSIONID_DESCRIPTOR = FieldDescriptor.of((String)"firstSessionId");
        private static final FieldDescriptor SESSIONINDEX_DESCRIPTOR = FieldDescriptor.of((String)"sessionIndex");
        private static final FieldDescriptor EVENTTIMESTAMPUS_DESCRIPTOR = FieldDescriptor.of((String)"eventTimestampUs");
        private static final FieldDescriptor DATACOLLECTIONSTATUS_DESCRIPTOR = FieldDescriptor.of((String)"dataCollectionStatus");
        private static final FieldDescriptor FIREBASEINSTALLATIONID_DESCRIPTOR = FieldDescriptor.of((String)"firebaseInstallationId");

        private SessionInfoEncoder() {
        }

        public void encode(SessionInfo value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(SESSIONID_DESCRIPTOR, (Object)value.getSessionId());
            ctx.add(FIRSTSESSIONID_DESCRIPTOR, (Object)value.getFirstSessionId());
            ctx.add(SESSIONINDEX_DESCRIPTOR, value.getSessionIndex());
            ctx.add(EVENTTIMESTAMPUS_DESCRIPTOR, value.getEventTimestampUs());
            ctx.add(DATACOLLECTIONSTATUS_DESCRIPTOR, (Object)value.getDataCollectionStatus());
            ctx.add(FIREBASEINSTALLATIONID_DESCRIPTOR, (Object)value.getFirebaseInstallationId());
        }
    }

    private static final class SessionEventEncoder
    implements ObjectEncoder<SessionEvent> {
        static final SessionEventEncoder INSTANCE = new SessionEventEncoder();
        private static final FieldDescriptor EVENTTYPE_DESCRIPTOR = FieldDescriptor.of((String)"eventType");
        private static final FieldDescriptor SESSIONDATA_DESCRIPTOR = FieldDescriptor.of((String)"sessionData");
        private static final FieldDescriptor APPLICATIONINFO_DESCRIPTOR = FieldDescriptor.of((String)"applicationInfo");

        private SessionEventEncoder() {
        }

        public void encode(SessionEvent value, ObjectEncoderContext ctx) throws IOException {
            ctx.add(EVENTTYPE_DESCRIPTOR, (Object)value.getEventType());
            ctx.add(SESSIONDATA_DESCRIPTOR, (Object)value.getSessionData());
            ctx.add(APPLICATIONINFO_DESCRIPTOR, (Object)value.getApplicationInfo());
        }
    }
}

