/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import androidx.annotation.Keep;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import com.google.firebase.sessions.EventGDTLogger;
import com.google.firebase.sessions.EventGDTLoggerInterface;
import com.google.firebase.sessions.FirebaseSessions;
import com.google.firebase.sessions.SessionDatastore;
import com.google.firebase.sessions.SessionDatastoreImpl;
import com.google.firebase.sessions.SessionFirelogPublisher;
import com.google.firebase.sessions.SessionFirelogPublisherImpl;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.SessionLifecycleServiceBinder;
import com.google.firebase.sessions.SessionLifecycleServiceBinderImpl;
import com.google.firebase.sessions.WallClock;
import com.google.firebase.sessions.settings.SessionsSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a0\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0014\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00050\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsRegistrar;", "Lcom/google/firebase/components/ComponentRegistrar;", "()V", "getComponents", "", "Lcom/google/firebase/components/Component;", "", "kotlin.jvm.PlatformType", "Companion", "com.google.firebase-firebase-sessions"})
@Keep
public final class FirebaseSessionsRegistrar
implements ComponentRegistrar {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final String LIBRARY_NAME = "fire-sessions";
    @Deprecated
    private static final Qualified<FirebaseApp> firebaseApp = Qualified.unqualified(FirebaseApp.class);
    @Deprecated
    private static final Qualified<FirebaseInstallationsApi> firebaseInstallationsApi = Qualified.unqualified(FirebaseInstallationsApi.class);
    @Deprecated
    private static final Qualified<CoroutineDispatcher> backgroundDispatcher = Qualified.qualified(Background.class, CoroutineDispatcher.class);
    @Deprecated
    private static final Qualified<CoroutineDispatcher> blockingDispatcher = Qualified.qualified(Blocking.class, CoroutineDispatcher.class);
    @Deprecated
    private static final Qualified<TransportFactory> transportFactory = Qualified.unqualified(TransportFactory.class);
    @Deprecated
    private static final Qualified<SessionFirelogPublisher> sessionFirelogPublisher = Qualified.unqualified(SessionFirelogPublisher.class);
    @Deprecated
    private static final Qualified<SessionGenerator> sessionGenerator = Qualified.unqualified(SessionGenerator.class);
    @Deprecated
    private static final Qualified<SessionsSettings> sessionsSettings = Qualified.unqualified(SessionsSettings.class);

    @NotNull
    public List<Component<? extends Object>> getComponents() {
        Object[] objectArray = new Component[]{Component.builder(FirebaseSessions.class).name(LIBRARY_NAME).add(Dependency.required(firebaseApp)).add(Dependency.required(sessionsSettings)).add(Dependency.required(backgroundDispatcher)).factory(FirebaseSessionsRegistrar::getComponents$lambda-0).eagerInDefaultApp().build(), Component.builder(SessionGenerator.class).name("session-generator").factory(FirebaseSessionsRegistrar::getComponents$lambda-1).build(), Component.builder(SessionFirelogPublisher.class).name("session-publisher").add(Dependency.required(firebaseApp)).add(Dependency.required(firebaseInstallationsApi)).add(Dependency.required(sessionsSettings)).add(Dependency.requiredProvider(transportFactory)).add(Dependency.required(backgroundDispatcher)).factory(FirebaseSessionsRegistrar::getComponents$lambda-2).build(), Component.builder(SessionsSettings.class).name("sessions-settings").add(Dependency.required(firebaseApp)).add(Dependency.required(blockingDispatcher)).add(Dependency.required(backgroundDispatcher)).add(Dependency.required(firebaseInstallationsApi)).factory(FirebaseSessionsRegistrar::getComponents$lambda-3).build(), Component.builder(SessionDatastore.class).name("sessions-datastore").add(Dependency.required(firebaseApp)).add(Dependency.required(backgroundDispatcher)).factory(FirebaseSessionsRegistrar::getComponents$lambda-4).build(), Component.builder(SessionLifecycleServiceBinder.class).name("sessions-service-binder").add(Dependency.required(firebaseApp)).factory(FirebaseSessionsRegistrar::getComponents$lambda-5).build(), LibraryVersionComponent.create((String)LIBRARY_NAME, (String)"1.2.0")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final FirebaseSessions getComponents$lambda-0(ComponentContainer container) {
        Object object = container.get(firebaseApp);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container[firebaseApp]");
        FirebaseApp firebaseApp = (FirebaseApp)object;
        Object object2 = container.get(sessionsSettings);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"container[sessionsSettings]");
        SessionsSettings sessionsSettings = (SessionsSettings)object2;
        Object object3 = container.get(backgroundDispatcher);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"container[backgroundDispatcher]");
        return new FirebaseSessions(firebaseApp, sessionsSettings, (CoroutineContext)object3);
    }

    private static final SessionGenerator getComponents$lambda-1(ComponentContainer it) {
        return new SessionGenerator(WallClock.INSTANCE, null, 2, null);
    }

    private static final SessionFirelogPublisher getComponents$lambda-2(ComponentContainer container) {
        Object object = container.get(firebaseApp);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container[firebaseApp]");
        FirebaseApp firebaseApp = (FirebaseApp)object;
        Object object2 = container.get(firebaseInstallationsApi);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"container[firebaseInstallationsApi]");
        FirebaseInstallationsApi firebaseInstallationsApi = (FirebaseInstallationsApi)object2;
        Object object3 = container.get(sessionsSettings);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"container[sessionsSettings]");
        SessionsSettings sessionsSettings = (SessionsSettings)object3;
        Provider provider = container.getProvider(transportFactory);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"container.getProvider(transportFactory)");
        EventGDTLoggerInterface eventGDTLoggerInterface = new EventGDTLogger((Provider<TransportFactory>)provider);
        Object object4 = container.get(backgroundDispatcher);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"container[backgroundDispatcher]");
        return new SessionFirelogPublisherImpl(firebaseApp, firebaseInstallationsApi, sessionsSettings, eventGDTLoggerInterface, (CoroutineContext)object4);
    }

    private static final SessionsSettings getComponents$lambda-3(ComponentContainer container) {
        Object object = container.get(firebaseApp);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container[firebaseApp]");
        FirebaseApp firebaseApp = (FirebaseApp)object;
        Object object2 = container.get(blockingDispatcher);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"container[blockingDispatcher]");
        CoroutineContext coroutineContext = (CoroutineContext)object2;
        Object object3 = container.get(backgroundDispatcher);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"container[backgroundDispatcher]");
        CoroutineContext coroutineContext2 = (CoroutineContext)object3;
        Object object4 = container.get(firebaseInstallationsApi);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"container[firebaseInstallationsApi]");
        return new SessionsSettings(firebaseApp, coroutineContext, coroutineContext2, (FirebaseInstallationsApi)object4);
    }

    private static final SessionDatastore getComponents$lambda-4(ComponentContainer container) {
        Context context = ((FirebaseApp)container.get(firebaseApp)).getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"container[firebaseApp].applicationContext");
        Object object = container.get(backgroundDispatcher);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container[backgroundDispatcher]");
        return new SessionDatastoreImpl(context, (CoroutineContext)object);
    }

    private static final SessionLifecycleServiceBinder getComponents$lambda-5(ComponentContainer container) {
        Object object = container.get(firebaseApp);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container[firebaseApp]");
        return new SessionLifecycleServiceBinderImpl((FirebaseApp)object);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0010\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00110\u0011 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00130\u0013 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0014\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00150\u0015 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsRegistrar$Companion;", "", "()V", "LIBRARY_NAME", "", "backgroundDispatcher", "Lcom/google/firebase/components/Qualified;", "Lkotlinx/coroutines/CoroutineDispatcher;", "kotlin.jvm.PlatformType", "blockingDispatcher", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "firebaseInstallationsApi", "Lcom/google/firebase/installations/FirebaseInstallationsApi;", "sessionFirelogPublisher", "Lcom/google/firebase/sessions/SessionFirelogPublisher;", "sessionGenerator", "Lcom/google/firebase/sessions/SessionGenerator;", "sessionsSettings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "transportFactory", "Lcom/google/android/datatransport/TransportFactory;", "com.google.firebase-firebase-sessions"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

