// Generated by Dagger (https://dagger.dev).
package com.google.firebase.sessions;

import android.content.Context;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.settings.SessionsSettings;
import com.google.firebase.sessions.settings.SessionsSettings_Factory;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import kotlin.coroutines.CoroutineContext;

@DaggerGenerated
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerFirebaseSessionsComponent {
  private DaggerFirebaseSessionsComponent() {
  }

  public static FirebaseSessionsComponent.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements FirebaseSessionsComponent.Builder {
    private Context appContext;

    private CoroutineContext backgroundDispatcher;

    private CoroutineContext blockingDispatcher;

    private FirebaseApp firebaseApp;

    private FirebaseInstallationsApi firebaseInstallationsApi;

    private Provider<TransportFactory> transportFactoryProvider;

    @Override
    public Builder appContext(Context appContext) {
      this.appContext = Preconditions.checkNotNull(appContext);
      return this;
    }

    @Override
    public Builder backgroundDispatcher(CoroutineContext backgroundDispatcher) {
      this.backgroundDispatcher = Preconditions.checkNotNull(backgroundDispatcher);
      return this;
    }

    @Override
    public Builder blockingDispatcher(CoroutineContext blockingDispatcher) {
      this.blockingDispatcher = Preconditions.checkNotNull(blockingDispatcher);
      return this;
    }

    @Override
    public Builder firebaseApp(FirebaseApp firebaseApp) {
      this.firebaseApp = Preconditions.checkNotNull(firebaseApp);
      return this;
    }

    @Override
    public Builder firebaseInstallationsApi(FirebaseInstallationsApi firebaseInstallationsApi) {
      this.firebaseInstallationsApi = Preconditions.checkNotNull(firebaseInstallationsApi);
      return this;
    }

    @Override
    public Builder transportFactoryProvider(Provider<TransportFactory> transportFactoryProvider) {
      this.transportFactoryProvider = Preconditions.checkNotNull(transportFactoryProvider);
      return this;
    }

    @Override
    public FirebaseSessionsComponent build() {
      Preconditions.checkBuilderRequirement(appContext, Context.class);
      Preconditions.checkBuilderRequirement(backgroundDispatcher, CoroutineContext.class);
      Preconditions.checkBuilderRequirement(blockingDispatcher, CoroutineContext.class);
      Preconditions.checkBuilderRequirement(firebaseApp, FirebaseApp.class);
      Preconditions.checkBuilderRequirement(firebaseInstallationsApi, FirebaseInstallationsApi.class);
      Preconditions.checkBuilderRequirement(transportFactoryProvider, Provider.class);
      return new FirebaseSessionsComponentImpl(appContext, backgroundDispatcher, blockingDispatcher, firebaseApp, firebaseInstallationsApi, transportFactoryProvider);
    }
  }

  private static final class FirebaseSessionsComponentImpl implements FirebaseSessionsComponent {
    private final FirebaseSessionsComponentImpl firebaseSessionsComponentImpl = this;

    private javax.inject.Provider<FirebaseApp> firebaseAppProvider;

    private javax.inject.Provider<CoroutineContext> blockingDispatcherProvider;

    private javax.inject.Provider<CoroutineContext> backgroundDispatcherProvider;

    private javax.inject.Provider<FirebaseInstallationsApi> firebaseInstallationsApiProvider;

    private javax.inject.Provider<SessionsSettings> sessionsSettingsProvider;

    private javax.inject.Provider<Context> appContextProvider;

    private javax.inject.Provider<SessionLifecycleServiceBinderImpl> sessionLifecycleServiceBinderImplProvider;

    private javax.inject.Provider<FirebaseSessions> firebaseSessionsProvider;

    private javax.inject.Provider<SessionDatastoreImpl> sessionDatastoreImplProvider;

    private javax.inject.Provider<Provider<TransportFactory>> transportFactoryProvider;

    private javax.inject.Provider<EventGDTLogger> eventGDTLoggerProvider;

    private javax.inject.Provider<SessionFirelogPublisherImpl> sessionFirelogPublisherImplProvider;

    private javax.inject.Provider<SessionGenerator> sessionGeneratorProvider;

    private FirebaseSessionsComponentImpl(Context appContextParam,
        CoroutineContext backgroundDispatcherParam, CoroutineContext blockingDispatcherParam,
        FirebaseApp firebaseAppParam, FirebaseInstallationsApi firebaseInstallationsApiParam,
        Provider<TransportFactory> transportFactoryProviderParam) {

      initialize(appContextParam, backgroundDispatcherParam, blockingDispatcherParam, firebaseAppParam, firebaseInstallationsApiParam, transportFactoryProviderParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final Context appContextParam,
        final CoroutineContext backgroundDispatcherParam,
        final CoroutineContext blockingDispatcherParam, final FirebaseApp firebaseAppParam,
        final FirebaseInstallationsApi firebaseInstallationsApiParam,
        final Provider<TransportFactory> transportFactoryProviderParam) {
      this.firebaseAppProvider = InstanceFactory.create(firebaseAppParam);
      this.blockingDispatcherProvider = InstanceFactory.create(blockingDispatcherParam);
      this.backgroundDispatcherProvider = InstanceFactory.create(backgroundDispatcherParam);
      this.firebaseInstallationsApiProvider = InstanceFactory.create(firebaseInstallationsApiParam);
      this.sessionsSettingsProvider = DoubleCheck.provider(SessionsSettings_Factory.create(firebaseAppProvider, blockingDispatcherProvider, backgroundDispatcherProvider, firebaseInstallationsApiProvider));
      this.appContextProvider = InstanceFactory.create(appContextParam);
      this.sessionLifecycleServiceBinderImplProvider = DoubleCheck.provider(SessionLifecycleServiceBinderImpl_Factory.create(appContextProvider));
      this.firebaseSessionsProvider = DoubleCheck.provider(FirebaseSessions_Factory.create(firebaseAppProvider, sessionsSettingsProvider, backgroundDispatcherProvider, ((javax.inject.Provider) sessionLifecycleServiceBinderImplProvider)));
      this.sessionDatastoreImplProvider = DoubleCheck.provider(SessionDatastoreImpl_Factory.create(appContextProvider, backgroundDispatcherProvider));
      this.transportFactoryProvider = InstanceFactory.create(transportFactoryProviderParam);
      this.eventGDTLoggerProvider = DoubleCheck.provider(EventGDTLogger_Factory.create(transportFactoryProvider));
      this.sessionFirelogPublisherImplProvider = DoubleCheck.provider(SessionFirelogPublisherImpl_Factory.create(firebaseAppProvider, firebaseInstallationsApiProvider, sessionsSettingsProvider, ((javax.inject.Provider) eventGDTLoggerProvider), backgroundDispatcherProvider));
      this.sessionGeneratorProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_SessionGeneratorFactory.create());
    }

    @Override
    public FirebaseSessions getFirebaseSessions() {
      return firebaseSessionsProvider.get();
    }

    @Override
    public SessionDatastore getSessionDatastore() {
      return sessionDatastoreImplProvider.get();
    }

    @Override
    public SessionFirelogPublisher getSessionFirelogPublisher() {
      return sessionFirelogPublisherImplProvider.get();
    }

    @Override
    public SessionGenerator getSessionGenerator() {
      return sessionGeneratorProvider.get();
    }

    @Override
    public SessionsSettings getSessionsSettings() {
      return sessionsSettingsProvider.get();
    }
  }
}
