/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.util.Log;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.inject.Provider;
import com.google.firebase.sessions.EventGDTLoggerInterface;
import com.google.firebase.sessions.SessionEvent;
import com.google.firebase.sessions.SessionEvents;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/firebase/sessions/EventGDTLogger;", "Lcom/google/firebase/sessions/EventGDTLoggerInterface;", "transportFactoryProvider", "Lcom/google/firebase/inject/Provider;", "Lcom/google/android/datatransport/TransportFactory;", "<init>", "(Lcom/google/firebase/inject/Provider;)V", "log", "", "sessionEvent", "Lcom/google/firebase/sessions/SessionEvent;", "encode", "", "value", "Companion", "com.google.firebase-firebase-sessions"})
public final class EventGDTLogger
implements EventGDTLoggerInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Provider<TransportFactory> transportFactoryProvider;
    @NotNull
    private static final String AQS_LOG_SOURCE = "FIREBASE_APPQUALITY_SESSION";

    @Inject
    public EventGDTLogger(@NotNull Provider<TransportFactory> transportFactoryProvider) {
        Intrinsics.checkNotNullParameter(transportFactoryProvider, (String)"transportFactoryProvider");
        this.transportFactoryProvider = transportFactoryProvider;
    }

    @Override
    public void log(@NotNull SessionEvent sessionEvent) {
        Intrinsics.checkNotNullParameter((Object)sessionEvent, (String)"sessionEvent");
        ((TransportFactory)this.transportFactoryProvider.get()).getTransport(AQS_LOG_SOURCE, SessionEvent.class, Encoding.of((String)"json"), this::encode).send(Event.ofData((Object)sessionEvent));
    }

    private final byte[] encode(SessionEvent value) {
        String string = SessionEvents.INSTANCE.getSESSION_EVENT_ENCODER$com_google_firebase_firebase_sessions().encode((Object)value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        String jsonEvent = string;
        Log.d((String)"FirebaseSessions", (String)("Session Event Type: " + value.getEventType().name()));
        String string2 = jsonEvent;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/sessions/EventGDTLogger$Companion;", "", "<init>", "()V", "AQS_LOG_SOURCE", "", "com.google.firebase-firebase-sessions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

