/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.util.Log;
import androidx.datastore.core.DataStore;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.sessions.ProcessData;
import com.google.firebase.sessions.ProcessDataManager;
import com.google.firebase.sessions.SessionData;
import com.google.firebase.sessions.SessionDetails;
import com.google.firebase.sessions.SessionFirelogPublisher;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.SharedSessionRepository;
import com.google.firebase.sessions.SharedSessionRepositoryImpl;
import com.google.firebase.sessions.Time;
import com.google.firebase.sessions.TimeProvider;
import com.google.firebase.sessions.api.FirebaseSessionsDependencies;
import com.google.firebase.sessions.api.SessionSubscriber;
import com.google.firebase.sessions.settings.SessionsSettings;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001:\u0001/BI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0001\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u001e\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\fH\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\fH\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/google/firebase/sessions/SharedSessionRepositoryImpl;", "Lcom/google/firebase/sessions/SharedSessionRepository;", "sessionsSettings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "sessionGenerator", "Lcom/google/firebase/sessions/SessionGenerator;", "sessionFirelogPublisher", "Lcom/google/firebase/sessions/SessionFirelogPublisher;", "timeProvider", "Lcom/google/firebase/sessions/TimeProvider;", "sessionDataStore", "Landroidx/datastore/core/DataStore;", "Lcom/google/firebase/sessions/SessionData;", "processDataManager", "Lcom/google/firebase/sessions/ProcessDataManager;", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/google/firebase/sessions/settings/SessionsSettings;Lcom/google/firebase/sessions/SessionGenerator;Lcom/google/firebase/sessions/SessionFirelogPublisher;Lcom/google/firebase/sessions/TimeProvider;Landroidx/datastore/core/DataStore;Lcom/google/firebase/sessions/ProcessDataManager;Lkotlin/coroutines/CoroutineContext;)V", "localSessionData", "getLocalSessionData$com_google_firebase_firebase_sessions", "()Lcom/google/firebase/sessions/SessionData;", "setLocalSessionData$com_google_firebase_firebase_sessions", "(Lcom/google/firebase/sessions/SessionData;)V", "value", "", "isInForeground", "()Z", "previousNotificationType", "Lcom/google/firebase/sessions/SharedSessionRepositoryImpl$NotificationType;", "getPreviousNotificationType$com_google_firebase_firebase_sessions", "()Lcom/google/firebase/sessions/SharedSessionRepositoryImpl$NotificationType;", "setPreviousNotificationType$com_google_firebase_firebase_sessions", "(Lcom/google/firebase/sessions/SharedSessionRepositoryImpl$NotificationType;)V", "previousSessionId", "", "appBackground", "", "appForeground", "notifySubscribers", "sessionId", "type", "(Ljava/lang/String;Lcom/google/firebase/sessions/SharedSessionRepositoryImpl$NotificationType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isSessionExpired", "sessionData", "isColdStart", "isMyProcessStale", "NotificationType", "com.google.firebase-firebase-sessions"})
@SourceDebugExtension(value={"SMAP\nSharedSessionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedSessionRepository.kt\ncom/google/firebase/sessions/SharedSessionRepositoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1863#2,2:258\n*S KotlinDebug\n*F\n+ 1 SharedSessionRepository.kt\ncom/google/firebase/sessions/SharedSessionRepositoryImpl\n*L\n199#1:258,2\n*E\n"})
public final class SharedSessionRepositoryImpl
implements SharedSessionRepository {
    @NotNull
    private final SessionsSettings sessionsSettings;
    @NotNull
    private final SessionGenerator sessionGenerator;
    @NotNull
    private final SessionFirelogPublisher sessionFirelogPublisher;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final DataStore<SessionData> sessionDataStore;
    @NotNull
    private final ProcessDataManager processDataManager;
    @NotNull
    private final CoroutineContext backgroundDispatcher;
    public SessionData localSessionData;
    private boolean isInForeground;
    @NotNull
    private NotificationType previousNotificationType;
    @NotNull
    private String previousSessionId;

    @Inject
    public SharedSessionRepositoryImpl(@NotNull SessionsSettings sessionsSettings, @NotNull SessionGenerator sessionGenerator, @NotNull SessionFirelogPublisher sessionFirelogPublisher, @NotNull TimeProvider timeProvider, @NotNull DataStore<SessionData> sessionDataStore, @NotNull ProcessDataManager processDataManager, @Background @NotNull CoroutineContext backgroundDispatcher) {
        Intrinsics.checkNotNullParameter((Object)sessionsSettings, (String)"sessionsSettings");
        Intrinsics.checkNotNullParameter((Object)sessionGenerator, (String)"sessionGenerator");
        Intrinsics.checkNotNullParameter((Object)sessionFirelogPublisher, (String)"sessionFirelogPublisher");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter(sessionDataStore, (String)"sessionDataStore");
        Intrinsics.checkNotNullParameter((Object)processDataManager, (String)"processDataManager");
        Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
        this.sessionsSettings = sessionsSettings;
        this.sessionGenerator = sessionGenerator;
        this.sessionFirelogPublisher = sessionFirelogPublisher;
        this.timeProvider = timeProvider;
        this.sessionDataStore = sessionDataStore;
        this.processDataManager = processDataManager;
        this.backgroundDispatcher = backgroundDispatcher;
        this.previousNotificationType = NotificationType.GENERAL;
        this.previousSessionId = "";
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.backgroundDispatcher), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SharedSessionRepositoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.catch((Flow)this.this$0.sessionDataStore.getData(), (Function3)((Function3)new Function3<FlowCollector<? super SessionData>, Throwable, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            /* synthetic */ Object L$1;
                            final /* synthetic */ SharedSessionRepositoryImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(3, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        FlowCollector $this$catch = (FlowCollector)this.L$0;
                                        Throwable it = (Throwable)this.L$1;
                                        SessionData newSession = new SessionData(this.this$0.sessionGenerator.generateNewSession(null), null, null, 4, null);
                                        Log.d((String)"FirebaseSessions", (String)("Init session datastore failed with exception message: " + it.getMessage() + ". Emit fallback session " + newSession.getSessionDetails().getSessionId()));
                                        this.L$0 = null;
                                        this.label = 1;
                                        Object object3 = $this$catch.emit((Object)newSession, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(FlowCollector<? super SessionData> p1, Throwable p2, Continuation<? super Unit> p3) {
                                Function3<FlowCollector<? super SessionData>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                                function3.L$0 = p1;
                                function3.L$1 = p2;
                                return function3.invokeSuspend((Object)Unit.INSTANCE);
                            }
                        })).collect(new FlowCollector(){

                            public final Object emit(SessionData sessionData, Continuation<? super Unit> $completion) {
                                this$0.setLocalSessionData$com_google_firebase_firebase_sessions(sessionData);
                                String sessionId = sessionData.getSessionDetails().getSessionId();
                                Object object = this$0.notifySubscribers(sessionId, NotificationType.GENERAL, (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final SessionData getLocalSessionData$com_google_firebase_firebase_sessions() {
        SessionData sessionData = this.localSessionData;
        if (sessionData != null) {
            return sessionData;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"localSessionData");
        return null;
    }

    public final void setLocalSessionData$com_google_firebase_firebase_sessions(@NotNull SessionData sessionData) {
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)"<set-?>");
        this.localSessionData = sessionData;
    }

    @Override
    public boolean isInForeground() {
        return this.isInForeground;
    }

    @NotNull
    public final NotificationType getPreviousNotificationType$com_google_firebase_firebase_sessions() {
        return this.previousNotificationType;
    }

    public final void setPreviousNotificationType$com_google_firebase_firebase_sessions(@NotNull NotificationType notificationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"<set-?>");
        this.previousNotificationType = notificationType;
    }

    @Override
    public void appBackground() {
        this.isInForeground = false;
        if (this.localSessionData == null) {
            Log.d((String)"FirebaseSessions", (String)"App backgrounded, but local SessionData not initialized");
            return;
        }
        Log.d((String)"FirebaseSessions", (String)("App backgrounded on " + this.processDataManager.getMyProcessName()));
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.backgroundDispatcher), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SharedSessionRepositoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SharedSessionRepositoryImpl.access$getSessionDataStore$p(this.this$0).updateData((Function2)new Function2<SessionData, Continuation<? super SessionData>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SharedSessionRepositoryImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        SessionData sessionData = (SessionData)this.L$0;
                                        return SessionData.copy$default(sessionData, null, SharedSessionRepositoryImpl.access$getTimeProvider$p(this.this$0).currentTime(), null, 5, null);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                Function2<SessionData, Continuation<? super SessionData>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value;
                                return (Continuation)function2;
                            }

                            public final Object invoke(SessionData p1, Continuation<? super SessionData> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            Log.d((String)"FirebaseSessions", (String)("App backgrounded, failed to update data. Message: " + ex.getMessage()));
                            this.this$0.setLocalSessionData$com_google_firebase_firebase_sessions(SessionData.copy$default(this.this$0.getLocalSessionData$com_google_firebase_firebase_sessions(), null, SharedSessionRepositoryImpl.access$getTimeProvider$p(this.this$0).currentTime(), null, 5, null));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void appForeground() {
        this.isInForeground = true;
        if (this.localSessionData == null) {
            Log.d((String)"FirebaseSessions", (String)"App foregrounded, but local SessionData not initialized");
            return;
        }
        SessionData sessionData = this.getLocalSessionData$com_google_firebase_firebase_sessions();
        Log.d((String)"FirebaseSessions", (String)("App foregrounded on " + this.processDataManager.getMyProcessName()));
        if (this.isSessionExpired(sessionData) || this.isMyProcessStale(sessionData)) {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.backgroundDispatcher), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sessionData, null){
                int label;
                final /* synthetic */ SharedSessionRepositoryImpl this$0;
                final /* synthetic */ SessionData $sessionData;
                {
                    this.this$0 = $receiver;
                    this.$sessionData = $sessionData;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = SharedSessionRepositoryImpl.access$getSessionDataStore$p(this.this$0).updateData((Function2)new Function2<SessionData, Continuation<? super SessionData>, Object>(this.this$0, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ SharedSessionRepositoryImpl this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            Object object2;
                                            SessionDetails currentSession;
                                            ResultKt.throwOnFailure((Object)object);
                                            SessionData currentSessionData = (SessionData)this.L$0;
                                            boolean isSessionExpired = SharedSessionRepositoryImpl.access$isSessionExpired(this.this$0, currentSessionData);
                                            boolean isColdStart = SharedSessionRepositoryImpl.access$isColdStart(this.this$0, currentSessionData);
                                            boolean isMyProcessStale = SharedSessionRepositoryImpl.access$isMyProcessStale(this.this$0, currentSessionData);
                                            Map<String, ProcessData> newProcessDataMap = isColdStart ? SharedSessionRepositoryImpl.access$getProcessDataManager$p(this.this$0).generateProcessDataMap() : (isMyProcessStale ? SharedSessionRepositoryImpl.access$getProcessDataManager$p(this.this$0).updateProcessDataMap(currentSessionData.getProcessDataMap()) : currentSessionData.getProcessDataMap());
                                            SessionDetails sessionDetails = currentSession = isColdStart ? null : currentSessionData.getSessionDetails();
                                            if (isSessionExpired || isColdStart) {
                                                SessionDetails newSessionDetails = SharedSessionRepositoryImpl.access$getSessionGenerator$p(this.this$0).generateNewSession(currentSession);
                                                SharedSessionRepositoryImpl.access$getSessionFirelogPublisher$p(this.this$0).mayLogSession(newSessionDetails);
                                                SharedSessionRepositoryImpl.access$getProcessDataManager$p(this.this$0).onSessionGenerated();
                                                object2 = currentSessionData.copy(newSessionDetails, null, newProcessDataMap);
                                            } else {
                                                void var2_2;
                                                object2 = isMyProcessStale ? SessionData.copy$default(currentSessionData, null, null, SharedSessionRepositoryImpl.access$getProcessDataManager$p(this.this$0).updateProcessDataMap(newProcessDataMap), 3, null) : var2_2;
                                            }
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    Function2<SessionData, Continuation<? super SessionData>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    function2.L$0 = value;
                                    return (Continuation)function2;
                                }

                                public final Object invoke(SessionData p1, Continuation<? super SessionData> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object4;
                            void $result;
                            Object object3;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception ex) {
                                Log.d((String)"FirebaseSessions", (String)("App foregrounded, failed to update data. Message: " + ex.getMessage()));
                                if (!SharedSessionRepositoryImpl.access$isSessionExpired(this.this$0, this.$sessionData)) return Unit.INSTANCE;
                                SessionDetails newSessionDetails = SharedSessionRepositoryImpl.access$getSessionGenerator$p(this.this$0).generateNewSession(this.$sessionData.getSessionDetails());
                                this.this$0.setLocalSessionData$com_google_firebase_firebase_sessions(SessionData.copy$default(this.$sessionData, newSessionDetails, null, null, 4, null));
                                SharedSessionRepositoryImpl.access$getSessionFirelogPublisher$p(this.this$0).mayLogSession(newSessionDetails);
                                this.label = 2;
                                object4 = SharedSessionRepositoryImpl.access$notifySubscribers(this.this$0, newSessionDetails.getSessionId(), NotificationType.FALLBACK, (Continuation)this);
                                if (object4 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                        }
                        case 2: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object notifySubscribers(String var1_1, NotificationType var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof notifySubscribers.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SharedSessionRepositoryImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SharedSessionRepositoryImpl.access$notifySubscribers(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.previousNotificationType = type;
                if (Intrinsics.areEqual((Object)this.previousSessionId, (Object)sessionId)) {
                    return Unit.INSTANCE;
                }
                this.previousSessionId = sessionId;
                $continuation.L$0 = sessionId;
                $continuation.L$1 = type;
                $continuation.label = 1;
                v0 = FirebaseSessionsDependencies.INSTANCE.getRegisteredSubscribers$com_google_firebase_firebase_sessions((Continuation<? super Map<SessionSubscriber.Name, ? extends SessionSubscriber>>)$continuation);
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                type = (NotificationType)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                $this$forEach$iv = ((Map)v0).values();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    subscriber = (SessionSubscriber)element$iv;
                    $i$a$-forEach-SharedSessionRepositoryImpl$notifySubscribers$2 = false;
                    subscriber.onSessionChanged(new SessionSubscriber.SessionDetails(sessionId));
                    switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            v1 = "Notified " + (Object)subscriber.getSessionSubscriberName() + " of new session " + sessionId;
                            break;
                        }
                        case 2: {
                            v1 = "Notified " + (Object)subscriber.getSessionSubscriberName() + " of new fallback session " + sessionId;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Log.d((String)"FirebaseSessions", (String)v1);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isSessionExpired(SessionData sessionData) {
        Time time = sessionData.getBackgroundTime();
        if (time != null) {
            boolean sessionExpired;
            Time backgroundTime = time;
            boolean bl = false;
            long interval = this.timeProvider.currentTime().minus-5sfh64U(backgroundTime);
            boolean bl2 = sessionExpired = Duration.compareTo-LRDsOJo((long)interval, (long)this.sessionsSettings.getSessionRestartTimeout-UwyO8pc()) > 0;
            if (sessionExpired) {
                Log.d((String)"FirebaseSessions", (String)("Session " + sessionData.getSessionDetails().getSessionId() + " is expired"));
            }
            return sessionExpired;
        }
        Log.d((String)"FirebaseSessions", (String)("Session " + sessionData.getSessionDetails().getSessionId() + " has not backgrounded yet"));
        return false;
    }

    private final boolean isColdStart(SessionData sessionData) {
        Map<String, ProcessData> map = sessionData.getProcessDataMap();
        if (map != null) {
            Map<String, ProcessData> processDataMap = map;
            boolean bl = false;
            boolean coldStart = this.processDataManager.isColdStart(processDataMap);
            if (coldStart) {
                Log.d((String)"FirebaseSessions", (String)"Cold app start detected");
            }
            return coldStart;
        }
        Log.d((String)"FirebaseSessions", (String)"No process data map");
        return true;
    }

    private final boolean isMyProcessStale(SessionData sessionData) {
        Map<String, ProcessData> map = sessionData.getProcessDataMap();
        if (map != null) {
            Map<String, ProcessData> processDataMap = map;
            boolean bl = false;
            boolean myProcessStale = this.processDataManager.isMyProcessStale(processDataMap);
            if (myProcessStale) {
                Log.d((String)"FirebaseSessions", (String)("Process " + this.processDataManager.getMyProcessName() + " is stale"));
            }
            return myProcessStale;
        }
        Log.d((String)"FirebaseSessions", (String)("No process data for " + this.processDataManager.getMyProcessName()));
        return true;
    }

    public static final /* synthetic */ TimeProvider access$getTimeProvider$p(SharedSessionRepositoryImpl $this) {
        return $this.timeProvider;
    }

    public static final /* synthetic */ boolean access$isSessionExpired(SharedSessionRepositoryImpl $this, SessionData sessionData) {
        return $this.isSessionExpired(sessionData);
    }

    public static final /* synthetic */ boolean access$isColdStart(SharedSessionRepositoryImpl $this, SessionData sessionData) {
        return $this.isColdStart(sessionData);
    }

    public static final /* synthetic */ boolean access$isMyProcessStale(SharedSessionRepositoryImpl $this, SessionData sessionData) {
        return $this.isMyProcessStale(sessionData);
    }

    public static final /* synthetic */ ProcessDataManager access$getProcessDataManager$p(SharedSessionRepositoryImpl $this) {
        return $this.processDataManager;
    }

    public static final /* synthetic */ SessionFirelogPublisher access$getSessionFirelogPublisher$p(SharedSessionRepositoryImpl $this) {
        return $this.sessionFirelogPublisher;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/sessions/SharedSessionRepositoryImpl$NotificationType;", "", "<init>", "(Ljava/lang/String;I)V", "GENERAL", "FALLBACK", "com.google.firebase-firebase-sessions"})
    public static final class NotificationType
    extends Enum<NotificationType> {
        public static final /* enum */ NotificationType GENERAL = new NotificationType();
        public static final /* enum */ NotificationType FALLBACK = new NotificationType();
        private static final /* synthetic */ NotificationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NotificationType[] values() {
            return (NotificationType[])$VALUES.clone();
        }

        public static NotificationType valueOf(String value) {
            return Enum.valueOf(NotificationType.class, value);
        }

        @NotNull
        public static EnumEntries<NotificationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = notificationTypeArray = new NotificationType[]{NotificationType.GENERAL, NotificationType.FALLBACK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            try {
                nArray[NotificationType.GENERAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.FALLBACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

