/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions.settings;

import android.os.Build;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.ApplicationInfo;
import com.google.firebase.sessions.InstallationId;
import com.google.firebase.sessions.TimeProvider;
import com.google.firebase.sessions.settings.CrashlyticsSettingsFetcher;
import com.google.firebase.sessions.settings.RemoteSettings;
import com.google.firebase.sessions.settings.SessionConfigs;
import com.google.firebase.sessions.settings.SessionConfigsSerializer;
import com.google.firebase.sessions.settings.SettingsCache;
import com.google.firebase.sessions.settings.SettingsProvider;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Singleton
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u0000 %2\u00020\u0001:\u0001%B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001c\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\u001dH\u0081@\u00a2\u0006\u0004\b!\u0010\u001eJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/google/firebase/sessions/settings/RemoteSettings;", "Lcom/google/firebase/sessions/settings/SettingsProvider;", "timeProvider", "Lcom/google/firebase/sessions/TimeProvider;", "firebaseInstallationsApi", "Lcom/google/firebase/installations/FirebaseInstallationsApi;", "appInfo", "Lcom/google/firebase/sessions/ApplicationInfo;", "configsFetcher", "Lcom/google/firebase/sessions/settings/CrashlyticsSettingsFetcher;", "settingsCache", "Lcom/google/firebase/sessions/settings/SettingsCache;", "<init>", "(Lcom/google/firebase/sessions/TimeProvider;Lcom/google/firebase/installations/FirebaseInstallationsApi;Lcom/google/firebase/sessions/ApplicationInfo;Lcom/google/firebase/sessions/settings/CrashlyticsSettingsFetcher;Lcom/google/firebase/sessions/settings/SettingsCache;)V", "fetchInProgress", "Lkotlinx/coroutines/sync/Mutex;", "sessionEnabled", "", "getSessionEnabled", "()Ljava/lang/Boolean;", "sessionRestartTimeout", "Lkotlin/time/Duration;", "getSessionRestartTimeout-FghU774", "()Lkotlin/time/Duration;", "samplingRate", "", "getSamplingRate", "()Ljava/lang/Double;", "updateSettings", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isSettingsStale", "clearCachedSettings", "clearCachedSettings$com_google_firebase_firebase_sessions", "sanitize", "", "s", "Companion", "com.google.firebase-firebase-sessions"})
@SourceDebugExtension(value={"SMAP\nRemoteSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteSettings.kt\ncom/google/firebase/sessions/settings/RemoteSettings\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,159:1\n116#2,11:160\n*S KotlinDebug\n*F\n+ 1 RemoteSettings.kt\ncom/google/firebase/sessions/settings/RemoteSettings\n*L\n70#1:160,11\n*E\n"})
public final class RemoteSettings
implements SettingsProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final FirebaseInstallationsApi firebaseInstallationsApi;
    @NotNull
    private final ApplicationInfo appInfo;
    @NotNull
    private final CrashlyticsSettingsFetcher configsFetcher;
    @NotNull
    private final SettingsCache settingsCache;
    @NotNull
    private final Mutex fetchInProgress;
    private static final int defaultCacheDuration = (int)Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((int)24, (DurationUnit)DurationUnit.HOURS));
    @NotNull
    private static final Regex sanitizeRegex = new Regex("/");

    @Inject
    public RemoteSettings(@NotNull TimeProvider timeProvider, @NotNull FirebaseInstallationsApi firebaseInstallationsApi, @NotNull ApplicationInfo appInfo, @NotNull CrashlyticsSettingsFetcher configsFetcher, @NotNull SettingsCache settingsCache) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)firebaseInstallationsApi, (String)"firebaseInstallationsApi");
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        Intrinsics.checkNotNullParameter((Object)configsFetcher, (String)"configsFetcher");
        Intrinsics.checkNotNullParameter((Object)settingsCache, (String)"settingsCache");
        this.timeProvider = timeProvider;
        this.firebaseInstallationsApi = firebaseInstallationsApi;
        this.appInfo = appInfo;
        this.configsFetcher = configsFetcher;
        this.settingsCache = settingsCache;
        this.fetchInProgress = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @Override
    @Nullable
    public Boolean getSessionEnabled() {
        return this.settingsCache.sessionsEnabled();
    }

    @Override
    @Nullable
    public Duration getSessionRestartTimeout-FghU774() {
        Integer n = this.settingsCache.sessionRestartTimeout();
        return n != null ? Duration.box-impl((long)DurationKt.toDuration((int)n, (DurationUnit)DurationUnit.SECONDS)) : null;
    }

    @Override
    @Nullable
    public Double getSamplingRate() {
        return this.settingsCache.sessionSamplingRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object updateSettings(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateSettings.1)) ** GOTO lbl-1000
        var13_2 = $completion;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteSettings this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateSettings((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.fetchInProgress.isLocked() && !this.settingsCache.hasCacheExpired()) {
                    return Unit.INSTANCE;
                }
                $this$withLock_u24default$iv = this.fetchInProgress;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (RemoteSettings)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 3 sources

                $i$a$-withLock$default-RemoteSettings$updateSettings$2 = false;
                if (this.settingsCache.hasCacheExpired()) ** GOTO lbl41
                Log.d((String)"FirebaseSessions", (String)"Remote settings cache not expired. Using cached values.");
                var11_13 = Unit.INSTANCE;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var11_13;
lbl41:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 2;
                v1 = InstallationId.Companion.create(this.firebaseInstallationsApi, (Continuation<? super InstallationId>)$continuation);
                ** if (v1 != var14_4) goto lbl47
lbl46:
                // 1 sources

                return var14_4;
lbl47:
                // 1 sources

                ** GOTO lbl58
            }
            case 2: {
                $i$a$-withLock$default-RemoteSettings$updateSettings$2 = false;
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (RemoteSettings)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl58:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(installationId = ((InstallationId)v1).getFid()), (Object)"")) ** GOTO lbl65
                Log.w((String)"FirebaseSessions", (String)"Error getting Firebase Installation ID. Skipping this Session Event.");
                var10_15 = Unit.INSTANCE;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var10_15;
lbl65:
                // 2 sources

                var7_16 = new Pair[5];
                var7_16[0] = TuplesKt.to((Object)"X-Crashlytics-Installation-ID", (Object)installationId);
                var7_16[1] = TuplesKt.to((Object)"X-Crashlytics-Device-Model", (Object)this.sanitize(Build.MANUFACTURER + Build.MODEL));
                v2 = Build.VERSION.INCREMENTAL;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"INCREMENTAL");
                var7_16[2] = TuplesKt.to((Object)"X-Crashlytics-OS-Build-Version", (Object)this.sanitize(v2));
                v3 = Build.VERSION.RELEASE;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"RELEASE");
                var7_16[3] = TuplesKt.to((Object)"X-Crashlytics-OS-Display-Version", (Object)this.sanitize(v3));
                var7_16[4] = TuplesKt.to((Object)"X-Crashlytics-API-Client-Version", (Object)this.appInfo.getSessionSdkVersion());
                options = MapsKt.mapOf((Pair[])var7_16);
                Log.d((String)"FirebaseSessions", (String)"Fetching settings from server.");
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v4 = this.configsFetcher.doConfigFetch(options, (Function2<? super JSONObject, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<JSONObject, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ RemoteSettings this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object3;
                                ResultKt.throwOnFailure((Object)object);
                                JSONObject it = (JSONObject)this.L$0;
                                Log.d((String)"FirebaseSessions", (String)("Fetched settings: " + it));
                                Boolean sessionsEnabled = null;
                                Double sessionSamplingRate = null;
                                Integer sessionTimeoutSeconds = null;
                                Integer cacheDuration = null;
                                if (it.has("app_quality")) {
                                    object3 = it.get("app_quality");
                                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.json.JSONObject");
                                    JSONObject aqsSettings = (JSONObject)object3;
                                    try {
                                        if (aqsSettings.has("sessions_enabled")) {
                                            sessionsEnabled = (Boolean)aqsSettings.get("sessions_enabled");
                                        }
                                        if (aqsSettings.has("sampling_rate")) {
                                            sessionSamplingRate = (Double)aqsSettings.get("sampling_rate");
                                        }
                                        if (aqsSettings.has("session_timeout_seconds")) {
                                            sessionTimeoutSeconds = (Integer)aqsSettings.get("session_timeout_seconds");
                                        }
                                        if (aqsSettings.has("cache_duration")) {
                                            cacheDuration = (Integer)aqsSettings.get("cache_duration");
                                        }
                                        object3 = Unit.INSTANCE;
                                    }
                                    catch (JSONException exception) {
                                        object3 = Boxing.boxInt((int)Log.e((String)"FirebaseSessions", (String)"Error parsing the configs remotely fetched: ", (Throwable)exception));
                                    }
                                }
                                Boolean bl = sessionsEnabled;
                                object3 = sessionTimeoutSeconds;
                                Double d = sessionSamplingRate;
                                Integer n = cacheDuration;
                                int n2 = n != null ? n.intValue() : RemoteSettings.access$getCompanion$p().getDefaultCacheDuration();
                                long l = RemoteSettings.access$getTimeProvider$p(this.this$0).currentTime().getSeconds();
                                this.label = 1;
                                Object object4 = RemoteSettings.access$getSettingsCache$p(this.this$0).updateConfigs(new SessionConfigs(bl, d, (Integer)object3, Boxing.boxInt((int)n2), Boxing.boxLong((long)l)), (Continuation<? super Unit>)((Continuation)this));
                                if (object4 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<JSONObject, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(JSONObject p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Function2<? super String, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<String, Continuation<? super Unit>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                String msg = (String)this.L$0;
                                Log.e((String)"FirebaseSessions", (String)("Error failed to fetch the remote configs: " + msg));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<String, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(String p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)$continuation);
                ** if (v4 != var14_4) goto lbl84
lbl83:
                // 1 sources

                return var14_4;
lbl84:
                // 1 sources

                ** GOTO lbl94
            }
            case 3: {
                $i$a$-withLock$default-RemoteSettings$updateSettings$2 = false;
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl94:
                    // 2 sources

                    var9_18 = Unit.INSTANCE;
                }
                catch (Throwable var5_12) {
                    throw var5_12;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean isSettingsStale() {
        return this.settingsCache.hasCacheExpired();
    }

    @VisibleForTesting
    @Nullable
    public final Object clearCachedSettings$com_google_firebase_firebase_sessions(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.settingsCache.updateConfigs(SessionConfigsSerializer.INSTANCE.getDefaultValue(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final String sanitize(String s) {
        CharSequence charSequence = s;
        Regex regex = sanitizeRegex;
        String string = "";
        return regex.replace(charSequence, string);
    }

    public static final /* synthetic */ SettingsCache access$getSettingsCache$p(RemoteSettings $this) {
        return $this.settingsCache;
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    public static final /* synthetic */ TimeProvider access$getTimeProvider$p(RemoteSettings $this) {
        return $this.timeProvider;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/google/firebase/sessions/settings/RemoteSettings$Companion;", "", "<init>", "()V", "defaultCacheDuration", "", "getDefaultCacheDuration", "()I", "sanitizeRegex", "Lkotlin/text/Regex;", "getSanitizeRegex", "()Lkotlin/text/Regex;", "com.google.firebase-firebase-sessions"})
    private static final class Companion {
        private Companion() {
        }

        public final int getDefaultCacheDuration() {
            return defaultCacheDuration;
        }

        @NotNull
        public final Regex getSanitizeRegex() {
            return sanitizeRegex;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

