/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbrc;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzbrf {
    private zzbrc zzcme;
    private Exception zzbLK;
    private int zzcmf;
    private Exception zzcmg;

    public zzbrf(@NonNull zzbrc zzbrc2) {
        this.zzcme = zzbrc2;
    }

    public void zzay(String string, String string2) {
        try {
            this.zzcme.zzay(string, string2);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
        }
    }

    private boolean zzce(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzcmf = -2;
            this.zzcmg = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zzjP(String string) {
        try {
            return this.zzcme.zzjP(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zza(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzce(context)) {
                return;
            }
            this.zzcme.zzjN(string);
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.zzcmf = 0;
            this.zzcmg = null;
            this.zzcme.reset();
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzjO(@Nullable String string) {
        try {
            this.zzcme.zzjO(string);
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzabh() {
        try {
            this.zzcme.zzabh();
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zze.zzE((zzd)this.zzcme.zzabi());
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject zzabq() throws RemoteException {
        return (JSONObject)zze.zzE((zzd)this.zzcme.zzabj());
    }

    @Nullable
    public String zzabk() {
        try {
            this.zzcme.zzabk();
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.zzcmg != null) {
                return this.zzcmg;
            }
            return this.zzbLK != null ? this.zzbLK : (Exception)zze.zzE((zzd)this.zzcme.zzabm());
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.zzcmf != 0) {
                return this.zzcmf;
            }
            return this.zzcme.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean zzabn() {
        try {
            if (this.zzcmf == -2 || this.zzcmg != null) {
                return false;
            }
            return this.zzcme.zzabn();
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzabn() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int zzabo() {
        try {
            return this.zzcme.zzabo();
        }
        catch (RemoteException remoteException) {
            this.zzbLK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

