/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbqx;
import com.google.android.gms.internal.zzbrb;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzckz = null;
    private StorageReference zzcki = null;
    private String zzckA = null;
    private String zzckB = null;
    private String zzand = null;
    private String zzckC = null;
    private String zzckD = null;
    private String zzckE = null;
    private long zzckF;
    private String zzckG = null;
    private String zzckH = null;
    private String zzckI = null;
    private String zzckJ = null;
    private String zzckK = null;
    private Map<String, String> zzckL = null;
    private String[] zzckM = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzac.zzw((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzckz = storageMetadata.zzckz;
        this.zzcki = storageMetadata.zzcki;
        this.zzckA = storageMetadata.zzckA;
        this.zzand = storageMetadata.zzand;
        this.zzckH = storageMetadata.zzckH;
        this.zzckI = storageMetadata.zzckI;
        this.zzckJ = storageMetadata.zzckJ;
        this.zzckK = storageMetadata.zzckK;
        if (storageMetadata.zzckL != null) {
            this.zzckL = new HashMap<String, String>(storageMetadata.zzckL);
        }
        this.zzckM = storageMetadata.zzckM;
        if (bl) {
            this.zzckG = storageMetadata.zzckG;
            this.zzckF = storageMetadata.zzckF;
            this.zzckE = storageMetadata.zzckE;
            this.zzckD = storageMetadata.zzckD;
            this.zzckC = storageMetadata.zzckC;
            this.zzckB = storageMetadata.zzckB;
        }
    }

    public String getContentType() {
        return this.zzand;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzckL == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzckL.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzckL == null) {
            return Collections.emptySet();
        }
        return this.zzckL.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzckA;
    }

    @Nullable
    public String getGeneration() {
        return this.zzckB;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzckC;
    }

    public long getCreationTimeMillis() {
        return zzbrb.zzjM(this.zzckD);
    }

    public long getUpdatedTimeMillis() {
        return zzbrb.zzjM(this.zzckE);
    }

    public long getSizeBytes() {
        return this.zzckF;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzckG;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzckM != null && this.zzcki != null) {
            try {
                String string = this.zzcki.zzaaN().zzA(this.zzcki.zzaaO());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.zzckM) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzckH;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzckI;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzckJ;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzckK;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzcki == null && this.zzckz != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzbqx.zzjJ((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzckz);
        }
        return this.zzcki;
    }

    @NonNull
    JSONObject zzaaM() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzckL != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzckL));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zzjI(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzckM = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata zzckN;
        boolean zzckO;

        public Builder() {
            this.zzckN = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzckN = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzckN.zzcki = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.zzckN = new StorageMetadata();
            if (jSONObject != null) {
                this.zzu(jSONObject);
                this.zzckO = true;
            }
        }

        private void zzu(JSONObject jSONObject) throws JSONException {
            this.zzckN.zzckB = jSONObject.optString("generation");
            this.zzckN.mPath = jSONObject.optString("name");
            this.zzckN.zzckA = jSONObject.optString("bucket");
            this.zzckN.zzckC = jSONObject.optString("metageneration");
            this.zzckN.zzckD = jSONObject.optString("timeCreated");
            this.zzckN.zzckE = jSONObject.optString("updated");
            this.zzckN.zzckF = jSONObject.optLong("size");
            this.zzckN.zzckG = jSONObject.optString("md5Hash");
            this.zzckN.zzjI(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzckN, this.zzckO);
        }

        public Builder setContentLanguage(String string) {
            this.zzckN.zzckK = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzckN.zzckJ = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzckN.zzckI = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzckN.zzckH = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzckN.zzckL == null) {
                this.zzckN.zzckL = new HashMap();
            }
            this.zzckN.zzckL.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzckN.zzand = string;
            return this;
        }
    }
}

