/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbqw;
import com.google.android.gms.internal.zzbrf;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.IOException;
import java.io.InputStream;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzcki;
    private zzbqw zzckk;
    private volatile Exception zzbLK = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzcls;
    private long zzckm;
    private long zzaKG;
    private long zzclt;
    private InputStream zzbSc;
    private zzbrf zzclu;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzcki = storageReference;
        this.zzckk = new zzbqw(this.zzcki.getApp(), this.zzcki.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzac.zzw((Object)streamProcessor);
        zzac.zzar((this.zzcls == null ? 1 : 0) != 0);
        this.zzcls = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzcki;
    }

    long getTotalBytes() {
        return this.zzaKG;
    }

    private void zzaT(long l) {
        this.zzckm += l;
        if (this.zzclt + 262144L <= this.zzckm) {
            this.zzf(4, false);
        }
    }

    @Override
    protected void schedule() {
        zzd.zzaaW().zzv(this.zzTj());
    }

    @Override
    void run() {
        boolean bl;
        this.zzckk.reset();
        if (this.zzbLK != null) {
            this.zzf(64, false);
            return;
        }
        if (!this.zzf(4, false)) {
            return;
        }
        try {
            this.zzclu = this.zzcki.zzaaN().zza(this.zzcki.zzaaO(), 0L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.zzbLK = remoteException;
            this.zzf(64, false);
            return;
        }
        this.zzckk.zza(this.zzclu, false);
        this.mResultCode = this.zzclu.getResultCode();
        this.zzbLK = this.zzclu.getException() != null ? this.zzclu.getException() : this.zzbLK;
        boolean bl2 = bl = this.zzpW(this.mResultCode) && this.zzbLK == null && this.zzaaQ() == 4;
        if (bl) {
            this.zzaKG = this.zzclu.zzabo();
            InputStream inputStream = this.zzclu.getStream();
            if (inputStream != null) {
                this.zzbSc = new zza(this, inputStream);
                if (this.zzcls != null) {
                    try {
                        this.zzcls.doInBackground((TaskSnapshot)this.zzaaS(), this.zzbSc);
                    }
                    catch (Exception exception) {
                        Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                        this.zzbLK = exception;
                    }
                }
            } else {
                this.zzbLK = new IOException("Could not open resulting stream.");
            }
        }
        if (this.zzbSc == null) {
            this.zzclu.zzabh();
        }
        boolean bl3 = bl = bl && this.zzbLK == null && this.zzaaQ() == 4;
        if (bl) {
            this.zzf(4, false);
            this.zzf(128, false);
        } else if (!this.zzf(this.zzaaQ() == 32 ? 256 : 64, false)) {
            int n = this.zzaaQ();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot zzaaX() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbLK, this.mResultCode)), this.zzclt);
    }

    @Override
    protected void onCanceled() {
        this.zzckk.cancel();
    }

    @Override
    protected void onProgress() {
        this.zzclt = this.zzckm;
    }

    private boolean zzpW(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzaaK() {
        return this.zzaaX();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzckm;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.zzckm = l;
        }

        public long getBytesTransferred() {
            return this.zzckm;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.zzbSc;
        }
    }

    private static class zza
    extends InputStream {
        private StreamDownloadTask zzclv;
        private InputStream zzclw;
        private int zzclx;

        public zza(@NonNull StreamDownloadTask streamDownloadTask, @NonNull InputStream inputStream) {
            this.zzclv = streamDownloadTask;
            this.zzclw = inputStream;
        }

        private void zzaaY() throws IOException {
            if (this.zzclv.zzaaQ() == 32) {
                throw StorageException.zzckv;
            }
        }

        @Override
        public int read() throws IOException {
            this.zzaaY();
            int n = this.zzclw.read();
            if (n != -1) {
                this.zzclv.zzaT(1L);
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            this.zzaaY();
            return this.zzclw.available();
        }

        @Override
        public void close() throws IOException {
            this.zzclw.close();
            if (this.zzclv.zzclu != null) {
                this.zzclv.zzclu.zzabh();
            }
            this.zzaaY();
        }

        @Override
        public void mark(int n) {
            this.zzclx = n;
            this.zzclw.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this.zzclw.markSupported();
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.zzaaY();
            int n4 = 0;
            while ((long)n2 > 262144L) {
                n3 = this.zzclw.read(byArray, n, 262144);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                n += n3;
                n2 -= n3;
                this.zzclv.zzaT(n3);
                this.zzaaY();
                if ((long)n3 >= 262144L) continue;
                break;
            }
            if (n2 > 0) {
                n3 = this.zzclw.read(byArray, n, n2);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                this.zzclv.zzaT(n3);
            }
            return n4;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.zzaaY();
            this.zzclv.zzaT(-this.zzclx);
            this.zzclw.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            this.zzaaY();
            int n = 0;
            while (l > 262144L) {
                l2 = this.zzclw.skip(262144L);
                n = (int)((long)n + l2);
                if (l2 < 262144L) {
                    this.zzclv.zzaT(l2);
                    return n;
                }
                this.zzclv.zzaT(262144L);
                l -= 262144L;
                this.zzaaY();
            }
            l2 = this.zzclw.skip(l);
            n = (int)((long)n + l2);
            this.zzclv.zzaT(l2);
            return n;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

