/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public class zzbtu {
    private static final Runtime zzcoB = Runtime.getRuntime();
    private final InputStream zzcoC;
    private byte[] buffer;
    private int zzcoD;
    private boolean zzcoE;
    private boolean zzcoF;

    public zzbtu(InputStream inputStream, int n) {
        this.zzcoC = inputStream;
        this.buffer = new byte[n];
        this.zzcoD = 0;
        this.zzcoF = true;
        this.zzcoE = false;
    }

    public int available() {
        return this.zzcoD;
    }

    public byte[] zzacV() {
        return this.buffer;
    }

    public int zzqO(int n) throws IOException {
        int n2;
        if (n <= this.zzcoD) {
            this.zzcoD -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzcoD);
            n2 = n;
        } else {
            n2 = this.zzcoD = 0;
            while (n2 < n) {
                long l = this.zzcoC.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzcoC.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public int zzqP(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzqQ(n));
        }
        while (this.zzcoD < n) {
            int n2 = this.zzcoC.read(this.buffer, this.zzcoD, n - this.zzcoD);
            if (n2 == -1) {
                this.zzcoE = true;
                break;
            }
            this.zzcoD += n2;
        }
        return this.zzcoD;
    }

    private int zzqQ(int n) {
        int n2 = Math.max(this.buffer.length * 2, n);
        if (this.zzcoF && (long)(n2 + 262144) < zzcoB.freeMemory()) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzcoD);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzcoF = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public boolean isFinished() {
        return this.zzcoE;
    }

    public void close() throws IOException {
        this.zzcoC.close();
    }
}

