/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abt;
import com.google.android.gms.internal.abu;
import com.google.android.gms.internal.abz;
import com.google.android.gms.internal.acf;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzac;
import com.google.firebase.storage.zzt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzcoe;
    private final Uri mUri;
    private final long zzcpK;
    private final abt zzcpL;
    private final AtomicLong zzcpM;
    private int zzcpN;
    private abu zzcog;
    private boolean zzcpO;
    private volatile StorageMetadata zzcoK;
    private volatile Uri zzcpP;
    private volatile Exception zzbMj;
    private volatile Exception zzcpQ;
    private volatile int mResultCode;
    private volatile String zzcpR;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzcpM = new AtomicLong(0L);
        this.zzcpN = 262144;
        this.zzcpP = null;
        this.zzbMj = null;
        this.zzcpQ = null;
        this.mResultCode = 0;
        zzbo.zzu((Object)storageReference);
        zzbo.zzu((Object)byArray);
        this.zzcpK = byArray.length;
        this.zzcoe = storageReference;
        this.zzcoK = storageMetadata;
        this.mUri = null;
        this.zzcpL = new abt(new ByteArrayInputStream(byArray), 262144);
        this.zzcpO = true;
        this.zzcog = new abu(this.zzcoe.getStorage().getApp(), this.zzcoe.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzcpM = new AtomicLong(0L);
            this.zzcpN = 262144;
            this.zzcpP = null;
            this.zzbMj = null;
            this.zzcpQ = null;
            this.mResultCode = 0;
            zzbo.zzu((Object)storageReference);
            zzbo.zzu((Object)uri);
            this.zzcoe = storageReference;
            this.zzcoK = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzcog = new abu(this.zzcoe.getStorage().getApp(), this.zzcoe.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzcoe.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzbMj = fileNotFoundException;
            }
        }
        this.zzcpK = l;
        this.zzcpL = new abt(inputStream, 262144);
        this.zzcpO = true;
        this.zzcpP = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzcpM = new AtomicLong(0L);
        this.zzcpN = 262144;
        this.zzcpP = null;
        this.zzbMj = null;
        this.zzcpQ = null;
        this.mResultCode = 0;
        zzbo.zzu((Object)storageReference);
        zzbo.zzu((Object)inputStream);
        this.zzcpK = -1L;
        this.zzcoe = storageReference;
        this.zzcoK = storageMetadata;
        this.zzcpL = new abt(inputStream, 262144);
        this.zzcpO = false;
        this.mUri = null;
        this.zzcog = new abu(this.zzcoe.getStorage().getApp(), this.zzcoe.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzcoe;
    }

    final long getTotalByteCount() {
        return this.zzcpK;
    }

    @Override
    protected void schedule() {
        zzt.zzt(this.zzEf());
    }

    @Override
    final void run() {
        acf acf2;
        UploadTask uploadTask;
        block24: {
            this.zzcog.reset();
            if (!this.zzj(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzcoe.getParent() == null) {
                this.zzbMj = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzbMj != null) {
                return;
            }
            if (this.zzcpP == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzcoK != null) {
                    string2 = uploadTask.zzcoK.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzcoe.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    acf2 = uploadTask.zzcoe.zzKO().zza(uploadTask.zzcoe.zzKP(), uploadTask.zzcoK != null ? uploadTask.zzcoK.zzKN() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzbMj = throwable;
                    break block24;
                }
                if (uploadTask.zzc(acf2) && !TextUtils.isEmpty((CharSequence)(string = acf2.zzhO("X-Goog-Upload-URL")))) {
                    uploadTask.zzcpP = Uri.parse((String)string);
                }
            } else {
                this.zzaK(false);
            }
        }
        boolean bl = this.zzLa();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzcpL.zzch(uploadTask.zzcpN);
                    int n = Math.min(uploadTask.zzcpN, uploadTask.zzcpL.available());
                    try {
                        acf2 = uploadTask.zzcoe.zzKO().zza(uploadTask.zzcoe.zzKP(), uploadTask.zzcpP.toString(), uploadTask.zzcpL.zzLe(), uploadTask.zzcpM.get(), n, uploadTask.zzcpL.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzbMj = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(acf2)) {
                        int n2 = uploadTask.zzcpN = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzcpM.getAndAdd(n);
                    if (!uploadTask.zzcpL.isFinished()) {
                        uploadTask.zzcpL.zzcg(n);
                        if (uploadTask.zzcpN < 0x2000000) {
                            uploadTask.zzcpN <<= 1;
                            int n3 = uploadTask.zzcpN;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzcoK = new StorageMetadata.Builder(acf2.zzLn(), uploadTask.zzcoe).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(acf2.zzLi());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzbMj = throwable;
                        break block25;
                    }
                    uploadTask.zzj(4, false);
                    uploadTask.zzj(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzbMj = iOException;
                }
            }
            if (!(bl = this.zzLa())) continue;
            this.zzj(4, false);
        }
        if (this.zzcpO && this.zzKR() != 16) {
            try {
                this.zzcpL.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzbMj = null;
        this.zzcpQ = null;
        this.mResultCode = 0;
        this.zzcpR = null;
    }

    private final boolean zzLa() {
        if (this.zzKR() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbMj = new InterruptedException();
            this.zzj(64, false);
            return false;
        }
        if (this.zzKR() == 32) {
            this.zzj(256, false);
            return false;
        }
        if (this.zzKR() == 8) {
            this.zzj(16, false);
            return false;
        }
        if (!this.zzLb()) {
            return false;
        }
        if (this.zzcpP == null) {
            if (this.zzbMj == null) {
                this.zzbMj = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzj(64, false);
            return false;
        }
        if (this.zzbMj != null) {
            this.zzj(64, false);
            return false;
        }
        if ((this.zzcpQ != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzaK(true)) {
            if (this.zzLb()) {
                this.zzj(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzLb() {
        if ("final".equals(this.zzcpR)) {
            if (this.zzbMj == null) {
                this.zzbMj = new IOException("The server has terminated the upload session");
            }
            this.zzj(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzaK(boolean bl) {
        acf acf2;
        try {
            acf2 = this.zzcoe.zzKO().zzb(this.zzcoe.zzKP(), this.zzcpP.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbMj = remoteException;
            return false;
        }
        if ("final".equals(this.zzcpR)) {
            return false;
        }
        if (bl ? !this.zzc(acf2) : !this.zzb(acf2)) {
            return false;
        }
        if ("final".equals(acf2.zzhO("X-Goog-Upload-Status"))) {
            this.zzbMj = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = acf2.zzhO("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzcpM.get();
        if (l2 > l) {
            this.zzbMj = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzcpL.zzcg((int)(l - l2)) != l - l2) {
                    this.zzbMj = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzcpM.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbMj = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbMj = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(acf acf2) {
        acf2.zze(abz.zzf(this.zzcoe.getStorage().getApp()), this.zzcoe.getStorage().getApp().getApplicationContext());
        return this.zzd(acf2);
    }

    private final boolean zzc(acf acf2) {
        acf acf3 = acf2;
        this.zzcog.zza(acf3, true);
        return this.zzd(acf2);
    }

    private final boolean zzd(acf acf2) {
        int n = acf2.getResultCode();
        this.mResultCode = abu.zzcj(n) ? -2 : n;
        this.zzcpQ = acf2.getException();
        this.zzcpR = acf2.zzhO("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzcpQ == null;
    }

    @Override
    protected void onCanceled() {
        this.zzcog.cancel();
        acf acf2 = null;
        if (this.zzcpP != null) {
            try {
                acf2 = this.zzcoe.zzKO().zza(this.zzcoe.zzKP(), this.zzcpP.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (acf2 != null) {
            acf acf3 = acf2;
            zzt.zzs(new zzac(this, acf3));
        }
        this.zzbMj = StorageException.fromErrorStatus(Status.zzaBq);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzKM() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzbMj != null ? uploadTask.zzbMj : uploadTask.zzcpQ;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzcpM.get(), uploadTask.zzcpP, uploadTask.zzcoK);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzcoe;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcpU;
        private final Uri zzcpP;
        private final StorageMetadata zzcoK;
        private /* synthetic */ UploadTask zzcpT;

        TaskSnapshot(UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzcpT = uploadTask;
            super(uploadTask, exception);
            this.zzcpU = l;
            this.zzcpP = uri;
            this.zzcoK = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzcpU;
        }

        public long getTotalByteCount() {
            return this.zzcpT.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzcpP;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzcoK;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

