/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public final class zzecd {
    private static final Runtime zzmut = Runtime.getRuntime();
    private final InputStream zzmuu;
    private byte[] buffer;
    private int zzmuv;
    private boolean zzmuw;
    private boolean zzmux;

    public zzecd(InputStream inputStream, int n) {
        this.zzmuu = inputStream;
        this.buffer = new byte[262144];
        this.zzmuv = 0;
        this.zzmux = true;
        this.zzmuw = false;
    }

    public final int available() {
        return this.zzmuv;
    }

    public final byte[] zzcba() {
        return this.buffer;
    }

    public final int zzgd(int n) throws IOException {
        int n2;
        if (n <= this.zzmuv) {
            this.zzmuv -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzmuv);
            n2 = n;
        } else {
            n2 = this.zzmuv = 0;
            while (n2 < n) {
                long l = this.zzmuu.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzmuu.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public final int zzge(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzgf(n));
        }
        while (this.zzmuv < n) {
            int n2 = this.zzmuu.read(this.buffer, this.zzmuv, n - this.zzmuv);
            if (n2 == -1) {
                this.zzmuw = true;
                break;
            }
            this.zzmuv += n2;
        }
        return this.zzmuv;
    }

    private final int zzgf(int n) {
        int n2 = Math.max(this.buffer.length << 1, n);
        if (this.zzmux && (long)(n2 + 262144) < zzmut.freeMemory()) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzmuv);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzmux = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public final boolean isFinished() {
        return this.zzmuw;
    }

    public final void close() throws IOException {
        this.zzmuu.close();
    }
}

