/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.firebase.FirebaseException;
import com.google.firebase.storage.zza;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StorageException
extends FirebaseException {
    public static final int ERROR_UNKNOWN = -13000;
    public static final int ERROR_OBJECT_NOT_FOUND = -13010;
    public static final int ERROR_BUCKET_NOT_FOUND = -13011;
    public static final int ERROR_PROJECT_NOT_FOUND = -13012;
    public static final int ERROR_QUOTA_EXCEEDED = -13013;
    public static final int ERROR_NOT_AUTHENTICATED = -13020;
    public static final int ERROR_NOT_AUTHORIZED = -13021;
    public static final int ERROR_RETRY_LIMIT_EXCEEDED = -13030;
    public static final int ERROR_INVALID_CHECKSUM = -13031;
    public static final int ERROR_CANCELED = -13040;
    private static IOException zzmrk = new IOException("The operation was canceled.");
    private final int mErrorCode;
    private final int zzmrl;
    private String zzmrm;
    private Throwable zzmrn;

    private StorageException(int n, Throwable throwable, int n2) {
        String string;
        switch (n) {
            case -13000: {
                string = "An unknown error occurred, please check the HTTP result code and inner exception for server response.";
                break;
            }
            case -13010: {
                string = "Object does not exist at location.";
                break;
            }
            case -13011: {
                string = "Bucket does not exist.";
                break;
            }
            case -13012: {
                string = "Project does not exist.";
                break;
            }
            case -13013: {
                string = "Quota for bucket exceeded, please view quota on www.firebase.google.com/storage.";
                break;
            }
            case -13020: {
                string = "User is not authenticated, please authenticate using Firebase Authentication and try again.";
                break;
            }
            case -13021: {
                string = "User does not have permission to access this object.";
                break;
            }
            case -13030: {
                string = "The operation retry limit has been exceeded.";
                break;
            }
            case -13031: {
                string = "Object has a checksum which does not match. Please retry the operation.";
                break;
            }
            case -13040: {
                string = "The operation was cancelled.";
                break;
            }
            default: {
                string = "An unknown error occurred, please check the HTTP result code and inner exception for server response.";
            }
        }
        this.zzmrm = string;
        this.zzmrn = throwable;
        this.mErrorCode = n;
        this.zzmrl = n2;
        String string2 = this.zzmrm;
        String string3 = Integer.toString(this.mErrorCode);
        String string4 = Integer.toString(this.zzmrl);
        Log.e((String)"StorageException", (String)new StringBuilder(52 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("StorageException has occurred.\n").append(string2).append("\n Code: ").append(string3).append(" HttpResult: ").append(string4).toString());
        if (this.zzmrn != null) {
            Log.e((String)"StorageException", (String)this.zzmrn.getMessage(), (Throwable)this.zzmrn);
        }
    }

    @NonNull
    public static StorageException fromErrorStatus(@NonNull Status status) {
        zzbp.zzu((Object)status);
        zzbp.zzbh((!status.isSuccess() ? 1 : 0) != 0);
        Status status2 = status;
        return new StorageException(status2.isCanceled() ? -13040 : (status2 == Status.zzfhs ? -13030 : -13000), null, 0);
    }

    @Nullable
    public static StorageException fromExceptionAndHttpCode(@Nullable Throwable throwable, int n) {
        int n2;
        if (throwable instanceof StorageException) {
            return (StorageException)((Object)throwable);
        }
        if ((n == 0 || n >= 200 && n < 300) && throwable == null) {
            return null;
        }
        if (throwable instanceof zza) {
            n2 = -13040;
        } else {
            switch (n) {
                case -2: {
                    n2 = -13030;
                    break;
                }
                case 401: {
                    n2 = -13020;
                    break;
                }
                case 403: {
                    n2 = -13021;
                    break;
                }
                case 404: {
                    n2 = -13010;
                    break;
                }
                case 409: {
                    n2 = -13031;
                    break;
                }
                default: {
                    n2 = -13000;
                }
            }
        }
        return new StorageException(n2, throwable, n);
    }

    @NonNull
    public static StorageException fromException(@NonNull Throwable throwable) {
        return StorageException.fromExceptionAndHttpCode(throwable, 0);
    }

    public String getMessage() {
        return this.zzmrm;
    }

    public Throwable getCause() {
        if (this.zzmrn == this) {
            return null;
        }
        return this.zzmrn;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public int getHttpResultCode() {
        return this.zzmrl;
    }

    public boolean getIsRecoverableException() {
        return this.getErrorCode() == -13030;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

