/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzecf;
import com.google.android.gms.internal.zzecj;
import com.google.android.gms.internal.zzeco;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzd;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzmro = null;
    private StorageReference zzmqw = null;
    private String zzmrp = null;
    private String zzmrq = null;
    private zza<String> zzmrr = zza.zzbt("");
    private String zzmrs = null;
    private String zzmrt = null;
    private String zzmru = null;
    private long zzmrv;
    private String zzmrw = null;
    private zza<String> zzmrx = zza.zzbt("");
    private zza<String> zzmry = zza.zzbt("");
    private zza<String> zzmrz = zza.zzbt("");
    private zza<String> zzmsa = zza.zzbt("");
    private zza<Map<String, String>> zzmsb = zza.zzbt(Collections.emptyMap());
    private String[] zzmsc = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbp.zzu((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzmro = storageMetadata.zzmro;
        this.zzmqw = storageMetadata.zzmqw;
        this.zzmrp = storageMetadata.zzmrp;
        this.zzmrr = storageMetadata.zzmrr;
        this.zzmrx = storageMetadata.zzmrx;
        this.zzmry = storageMetadata.zzmry;
        this.zzmrz = storageMetadata.zzmrz;
        this.zzmsa = storageMetadata.zzmsa;
        this.zzmsb = storageMetadata.zzmsb;
        this.zzmsc = storageMetadata.zzmsc;
        if (bl) {
            this.zzmrw = storageMetadata.zzmrw;
            this.zzmrv = storageMetadata.zzmrv;
            this.zzmru = storageMetadata.zzmru;
            this.zzmrt = storageMetadata.zzmrt;
            this.zzmrs = storageMetadata.zzmrs;
            this.zzmrq = storageMetadata.zzmrq;
        }
    }

    public String getContentType() {
        return this.zzmrr.getValue();
    }

    public String getCustomMetadata(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzmsb.getValue().get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        return this.zzmsb.getValue().keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzmrp;
    }

    @Nullable
    public String getGeneration() {
        return this.zzmrq;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzmrs;
    }

    public long getCreationTimeMillis() {
        return zzecj.zzqu(this.zzmrt);
    }

    public long getUpdatedTimeMillis() {
        return zzecj.zzqu(this.zzmru);
    }

    public long getSizeBytes() {
        return this.zzmrv;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzmrw;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzmsc != null && this.zzmqw != null) {
            try {
                String string = zzeco.zzg(this.zzmqw.getStorage().getApp()).zzv(this.zzmqw.zzcal());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzmsc;
                    int n = this.zzmsc.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzmrx.getValue();
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzmry.getValue();
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzmrz.getValue();
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzmsa.getValue();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzmqw == null && this.zzmro != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzecf.zzqr((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzmro);
        }
        return this.zzmqw;
    }

    @NonNull
    final JSONObject zzcai() throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.zzmrr.zzcaj()) {
            hashMap.put("contentType", this.getContentType());
        }
        if (this.zzmsb.zzcaj()) {
            hashMap.put("metadata", (String)new JSONObject(this.zzmsb.getValue()));
        }
        if (this.zzmrx.zzcaj()) {
            hashMap.put("cacheControl", this.getCacheControl());
        }
        if (this.zzmry.zzcaj()) {
            hashMap.put("contentDisposition", this.getContentDisposition());
        }
        if (this.zzmrz.zzcaj()) {
            hashMap.put("contentEncoding", this.getContentEncoding());
        }
        if (this.zzmsa.zzcaj()) {
            hashMap.put("contentLanguage", this.getContentLanguage());
        }
        return new JSONObject(hashMap);
    }

    private final void zzqq(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzmsc = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzd zzd2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzmsd;
        private boolean zzmse;

        public Builder() {
            this.zzmsd = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzmsd = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzmsd.zzmqw = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzmsd = new StorageMetadata();
            if (jSONObject != null) {
                this.zzt(jSONObject);
                this.zzmse = true;
            }
        }

        @Nullable
        private static String zze(JSONObject jSONObject, String string) throws JSONException {
            if (jSONObject.has(string) && !jSONObject.isNull(string)) {
                return jSONObject.getString(string);
            }
            return null;
        }

        private final void zzt(JSONObject jSONObject) throws JSONException {
            String string;
            this.zzmsd.zzmrq = jSONObject.optString("generation");
            this.zzmsd.mPath = jSONObject.optString("name");
            this.zzmsd.zzmrp = jSONObject.optString("bucket");
            this.zzmsd.zzmrs = jSONObject.optString("metageneration");
            this.zzmsd.zzmrt = jSONObject.optString("timeCreated");
            this.zzmsd.zzmru = jSONObject.optString("updated");
            this.zzmsd.zzmrv = jSONObject.optLong("size");
            this.zzmsd.zzmrw = jSONObject.optString("md5Hash");
            this.zzmsd.zzqq(jSONObject.optString("downloadTokens"));
            if (jSONObject.has("metadata") && !jSONObject.isNull("metadata")) {
                string = jSONObject.getJSONObject("metadata");
                Iterator iterator = string.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.setCustomMetadata(string2, string.getString(string2));
                }
            }
            if ((string = Builder.zze(jSONObject, "contentType")) != null) {
                this.setContentType(string);
            }
            if ((string = Builder.zze(jSONObject, "cacheControl")) != null) {
                this.setCacheControl(string);
            }
            if ((string = Builder.zze(jSONObject, "contentDisposition")) != null) {
                this.setContentDisposition(string);
            }
            if ((string = Builder.zze(jSONObject, "contentEncoding")) != null) {
                this.setContentEncoding(string);
            }
            if ((string = Builder.zze(jSONObject, "contentLanguage")) != null) {
                this.setContentLanguage(string);
            }
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzmsd, this.zzmse, null);
        }

        public Builder setContentLanguage(@Nullable String string) {
            this.zzmsd.zzmsa = zza.zzbu(string);
            return this;
        }

        public Builder setContentEncoding(@Nullable String string) {
            this.zzmsd.zzmrz = zza.zzbu(string);
            return this;
        }

        public Builder setContentDisposition(@Nullable String string) {
            this.zzmsd.zzmry = zza.zzbu(string);
            return this;
        }

        public Builder setCacheControl(@Nullable String string) {
            this.zzmsd.zzmrx = zza.zzbu(string);
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (!this.zzmsd.zzmsb.zzcaj()) {
                this.zzmsd.zzmsb = zza.zzbu(new HashMap());
            }
            ((Map)this.zzmsd.zzmsb.getValue()).put(string, string2);
            return this;
        }

        public Builder setContentType(@Nullable String string) {
            this.zzmsd.zzmrr = zza.zzbu(string);
            return this;
        }
    }

    static final class zza<T> {
        private final boolean zzmsf;
        @Nullable
        private final T value;

        private zza(@Nullable T t, boolean bl) {
            this.zzmsf = bl;
            this.value = t;
        }

        static <T> zza<T> zzbt(T t) {
            return new zza<T>(t, false);
        }

        static <T> zza<T> zzbu(@Nullable T t) {
            return new zza<T>(t, true);
        }

        final boolean zzcaj() {
            return this.zzmsf;
        }

        @Nullable
        final T getValue() {
            return this.value;
        }
    }
}

