/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbn;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import com.google.firebase.storage.zzw;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzotm;
    private zzfbc zzoto;
    private volatile Exception zzleq = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzowa;
    private long zzgsn = -1L;
    private long zzotq;
    private long zzowb;
    private InputStream zzltm;
    private zzfbn zzowc;
    private String zzotr;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzotm = storageReference;
        this.zzoto = new zzfbc(this.zzotm.getStorage().getApp(), this.zzotm.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbq.checkNotNull((Object)streamProcessor);
        zzbq.checkState((this.zzowa == null ? 1 : 0) != 0);
        this.zzowa = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzotm;
    }

    final long getTotalBytes() {
        return this.zzgsn;
    }

    final void zzcq(long l) {
        this.zzotq += l;
        if (this.zzowb + 262144L <= this.zzotq) {
            if (this.zzcnz() == 4) {
                this.zzk(4, false);
                return;
            }
            this.zzowb = this.zzotq;
        }
    }

    @Override
    @Hide
    protected void schedule() {
        zzu.zzv(this.zzbmh());
    }

    private final InputStream zzcoe() throws Exception {
        this.zzoto.reset();
        if (this.zzowc != null) {
            this.zzowc.zzcon();
        }
        try {
            this.zzowc = this.zzotm.zzcnw().zza(this.zzotm.zzcnx(), this.zzotq);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzoto.zza(this.zzowc, false);
        this.mResultCode = this.zzowc.getResultCode();
        this.zzleq = this.zzowc.getException() != null ? this.zzowc.getException() : this.zzleq;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzleq == null && this.zzcnz() == 4) {
            String string = this.zzowc.zzst("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzotr != null && !this.zzotr.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzotr = string;
            if (this.zzgsn == -1L) {
                this.zzgsn = this.zzowc.zzcot();
            }
            return this.zzowc.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    @Hide
    final void run() {
        if (this.zzleq != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzw(this), this);
        this.zzltm = new BufferedInputStream(zza2);
        try {
            zza2.zzcog();
            if (this.zzowa != null) {
                try {
                    this.zzowa.doInBackground((TaskSnapshot)this.zzcoa(), this.zzltm);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzleq = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzleq = iOException;
        }
        if (this.zzltm == null) {
            this.zzowc.zzcon();
            this.zzowc = null;
        }
        if (this.zzleq == null && this.zzcnz() == 4) {
            this.zzk(4, false);
            this.zzk(128, false);
            return;
        }
        if (!this.zzk(this.zzcnz() == 32 ? 256 : 64, false)) {
            int n = this.zzcnz();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    @Hide
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    @Hide
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzoto.cancel();
        this.zzleq = StorageException.fromErrorStatus(Status.zzftu);
    }

    @Override
    protected void onProgress() {
        this.zzowb = this.zzotq;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcnt() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzleq, streamDownloadTask.mResultCode)), streamDownloadTask.zzowb);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzcoe();
    }

    static /* synthetic */ zzfbn zza(StreamDownloadTask streamDownloadTask, zzfbn zzfbn2) {
        streamDownloadTask.zzowc = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzotq;
        private /* synthetic */ StreamDownloadTask zzowd;

        TaskSnapshot(@Nullable StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzowd = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzotq = l;
        }

        public long getBytesTransferred() {
            return this.zzotq;
        }

        public long getTotalByteCount() {
            return this.zzowd.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzowd.zzltm;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzowe;
        @Nullable
        private InputStream zzowf;
        private Callable<InputStream> zzowg;
        private IOException zzowh;
        private int zzowi;
        private int zzowj;
        private boolean zzowk;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzowe = streamDownloadTask;
            this.zzowg = callable;
        }

        private final void zzcof() throws IOException {
            if (this.zzowe != null && this.zzowe.zzcnz() == 32) {
                throw new com.google.firebase.storage.zza();
            }
        }

        private final void zzcq(long l) {
            if (this.zzowe != null) {
                this.zzowe.zzcq(l);
            }
            this.zzowi = (int)((long)this.zzowi + l);
        }

        private final boolean zzcog() throws IOException {
            this.zzcof();
            if (this.zzowh != null) {
                try {
                    if (this.zzowf != null) {
                        this.zzowf.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzowf = null;
                if (this.zzowj == this.zzowi) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzowh);
                    return false;
                }
                int n = this.zzowi;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzowh);
                this.zzowj = this.zzowi;
                this.zzowh = null;
            }
            if (this.zzowk) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzowf == null) {
                try {
                    this.zzowf = this.zzowg.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzcog()) {
                try {
                    int n = this.zzowf.read();
                    if (n != -1) {
                        this.zzcq(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzowh = iOException;
                }
            }
            throw this.zzowh;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzcog()) {
                try {
                    return this.zzowf.available();
                }
                catch (IOException iOException) {
                    this.zzowh = iOException;
                }
            }
            throw this.zzowh;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzowf != null) {
                this.zzowf.close();
            }
            this.zzowk = true;
            if (this.zzowe != null && this.zzowe.zzowc != null) {
                this.zzowe.zzowc.zzcon();
                StreamDownloadTask.zza(this.zzowe, null);
            }
            this.zzcof();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzcog()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzowf.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzcq(n4);
                        this.zzcof();
                    }
                    if (n2 > 0) {
                        n4 = this.zzowf.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzcq(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzowh = iOException;
                }
            }
            throw this.zzowh;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzcog()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzowf.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcq(l2);
                        this.zzcof();
                    }
                    if (l > 0L) {
                        l2 = this.zzowf.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcq(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzowh = iOException;
                }
            }
            throw this.zzowh;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

