/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzfbb;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbh;
import com.google.android.gms.internal.zzfbn;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzad;
import com.google.firebase.storage.zzu;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzotm;
    private final Uri mUri;
    private final long zzowv;
    private final zzfbb zzoww;
    private final AtomicLong zzowx;
    private int zzowy;
    private zzfbc zzoto;
    private boolean zzowz;
    private volatile StorageMetadata zzouu;
    private volatile Uri zzoxa;
    private volatile Exception zzleq;
    private volatile Exception zzoxb;
    private volatile int mResultCode;
    private volatile String zzoxc;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzowx = new AtomicLong(0L);
        this.zzowy = 262144;
        this.zzoxa = null;
        this.zzleq = null;
        this.zzoxb = null;
        this.mResultCode = 0;
        zzbq.checkNotNull((Object)storageReference);
        zzbq.checkNotNull((Object)byArray);
        this.zzowv = byArray.length;
        this.zzotm = storageReference;
        this.zzouu = storageMetadata;
        this.mUri = null;
        this.zzoww = new zzfbb(new ByteArrayInputStream(byArray), 262144);
        this.zzowz = true;
        this.zzoto = new zzfbc(this.zzotm.getStorage().getApp(), this.zzotm.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzowx = new AtomicLong(0L);
            this.zzowy = 262144;
            this.zzoxa = null;
            this.zzleq = null;
            this.zzoxb = null;
            this.mResultCode = 0;
            zzbq.checkNotNull((Object)storageReference);
            zzbq.checkNotNull((Object)uri);
            this.zzotm = storageReference;
            this.zzouu = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzoto = new zzfbc(this.zzotm.getStorage().getApp(), this.zzotm.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzotm.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzleq = fileNotFoundException;
            }
        }
        this.zzowv = l;
        this.zzoww = new zzfbb(inputStream, 262144);
        this.zzowz = true;
        this.zzoxa = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzowx = new AtomicLong(0L);
        this.zzowy = 262144;
        this.zzoxa = null;
        this.zzleq = null;
        this.zzoxb = null;
        this.mResultCode = 0;
        zzbq.checkNotNull((Object)storageReference);
        zzbq.checkNotNull((Object)inputStream);
        this.zzowv = -1L;
        this.zzotm = storageReference;
        this.zzouu = storageMetadata;
        this.zzoww = new zzfbb(inputStream, 262144);
        this.zzowz = false;
        this.mUri = null;
        this.zzoto = new zzfbc(this.zzotm.getStorage().getApp(), this.zzotm.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzotm;
    }

    final long getTotalByteCount() {
        return this.zzowv;
    }

    @Override
    protected void schedule() {
        zzu.zzu(this.zzbmh());
    }

    @Override
    @Hide
    final void run() {
        zzfbn zzfbn2;
        UploadTask uploadTask;
        block24: {
            this.zzoto.reset();
            if (!this.zzk(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzotm.getParent() == null) {
                this.zzleq = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzleq != null) {
                return;
            }
            if (this.zzoxa == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzouu != null) {
                    string2 = uploadTask.zzouu.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzotm.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    zzfbn2 = uploadTask.zzotm.zzcnw().zza(uploadTask.zzotm.zzcnx(), uploadTask.zzouu != null ? uploadTask.zzouu.zzcnu() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzleq = throwable;
                    break block24;
                }
                if (uploadTask.zzc(zzfbn2) && !TextUtils.isEmpty((CharSequence)(string = zzfbn2.zzst("X-Goog-Upload-URL")))) {
                    uploadTask.zzoxa = Uri.parse((String)string);
                }
            } else {
                this.zzde(false);
            }
        }
        boolean bl = this.zzcoi();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzoww.zzjb(uploadTask.zzowy);
                    int n = Math.min(uploadTask.zzowy, uploadTask.zzoww.available());
                    try {
                        zzfbn2 = uploadTask.zzotm.zzcnw().zza(uploadTask.zzotm.zzcnx(), uploadTask.zzoxa.toString(), uploadTask.zzoww.zzcom(), uploadTask.zzowx.get(), n, uploadTask.zzoww.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzleq = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(zzfbn2)) {
                        int n2 = uploadTask.zzowy = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzowx.getAndAdd(n);
                    if (!uploadTask.zzoww.isFinished()) {
                        uploadTask.zzoww.zzja(n);
                        if (uploadTask.zzowy < 0x2000000) {
                            uploadTask.zzowy <<= 1;
                            int n3 = uploadTask.zzowy;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzouu = new StorageMetadata.Builder(zzfbn2.zzcov(), uploadTask.zzotm).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(zzfbn2.zzcoq());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzleq = throwable;
                        break block25;
                    }
                    uploadTask.zzk(4, false);
                    uploadTask.zzk(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzleq = iOException;
                }
            }
            if (!(bl = this.zzcoi())) continue;
            this.zzk(4, false);
        }
        if (this.zzowz && this.zzcnz() != 16) {
            try {
                this.zzoww.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzleq = null;
        this.zzoxb = null;
        this.mResultCode = 0;
        this.zzoxc = null;
    }

    private final boolean zzcoi() {
        if (this.zzcnz() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzleq = new InterruptedException();
            this.zzk(64, false);
            return false;
        }
        if (this.zzcnz() == 32) {
            this.zzk(256, false);
            return false;
        }
        if (this.zzcnz() == 8) {
            this.zzk(16, false);
            return false;
        }
        if (!this.zzcoj()) {
            return false;
        }
        if (this.zzoxa == null) {
            if (this.zzleq == null) {
                this.zzleq = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzk(64, false);
            return false;
        }
        if (this.zzleq != null) {
            this.zzk(64, false);
            return false;
        }
        if ((this.zzoxb != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzde(true)) {
            if (this.zzcoj()) {
                this.zzk(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzcoj() {
        if ("final".equals(this.zzoxc)) {
            if (this.zzleq == null) {
                this.zzleq = new IOException("The server has terminated the upload session", this.zzoxb);
            }
            this.zzk(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzde(boolean bl) {
        zzfbn zzfbn2;
        try {
            zzfbn2 = this.zzotm.zzcnw().zzb(this.zzotm.zzcnx(), this.zzoxa.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzleq = remoteException;
            return false;
        }
        if ("final".equals(this.zzoxc)) {
            return false;
        }
        if (bl ? !this.zzc(zzfbn2) : !this.zzb(zzfbn2)) {
            return false;
        }
        if ("final".equals(zzfbn2.zzst("X-Goog-Upload-Status"))) {
            this.zzleq = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzfbn2.zzst("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzowx.get();
        if (l2 > l) {
            this.zzleq = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzoww.zzja((int)(l - l2)) != l - l2) {
                    this.zzleq = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzowx.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzleq = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzleq = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(zzfbn zzfbn2) {
        zzfbn2.zze(zzfbh.zzh(this.zzotm.getStorage().getApp()), this.zzotm.getStorage().getApp().getApplicationContext());
        return this.zzd(zzfbn2);
    }

    private final boolean zzc(zzfbn zzfbn2) {
        zzfbn zzfbn3 = zzfbn2;
        this.zzoto.zza(zzfbn3, true);
        return this.zzd(zzfbn2);
    }

    private final boolean zzd(zzfbn zzfbn2) {
        int n = zzfbn2.getResultCode();
        this.mResultCode = zzfbc.zzjd(n) ? -2 : n;
        this.zzoxb = zzfbn2.getException();
        this.zzoxc = zzfbn2.zzst("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzoxb == null;
    }

    @Override
    protected void onCanceled() {
        this.zzoto.cancel();
        zzfbn zzfbn2 = null;
        if (this.zzoxa != null) {
            try {
                zzfbn2 = this.zzotm.zzcnw().zza(this.zzotm.zzcnx(), this.zzoxa.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzfbn2 != null) {
            zzfbn zzfbn3 = zzfbn2;
            zzu.zzt(new zzad(this, zzfbn3));
        }
        this.zzleq = StorageException.fromErrorStatus(Status.zzftu);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcnt() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzleq != null ? uploadTask.zzleq : uploadTask.zzoxb;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzowx.get(), uploadTask.zzoxa, uploadTask.zzouu);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzotm;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzoxf;
        private final Uri zzoxa;
        private final StorageMetadata zzouu;
        private /* synthetic */ UploadTask zzoxe;

        TaskSnapshot(UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzoxe = uploadTask;
            super(uploadTask, exception);
            this.zzoxf = l;
            this.zzoxa = uri;
            this.zzouu = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzoxf;
        }

        public long getTotalByteCount() {
            return this.zzoxe.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzoxa;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzouu;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

