/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.network;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.network.ResumableNetworkRequest;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ResumableUploadStartRequest
extends ResumableNetworkRequest {
    private final JSONObject metadata;
    private final String contentType;

    public ResumableUploadStartRequest(@NonNull Uri gsUri, @NonNull FirebaseApp app, @Nullable JSONObject metadata, @NonNull String contentType) {
        super(gsUri, app);
        this.metadata = metadata;
        this.contentType = contentType;
        if (TextUtils.isEmpty((CharSequence)this.contentType)) {
            this.mException = new IllegalArgumentException("mContentType is null or empty");
        }
        super.setCustomHeader("X-Goog-Upload-Protocol", "resumable");
        super.setCustomHeader("X-Goog-Upload-Command", "start");
        super.setCustomHeader("X-Goog-Upload-Header-Content-Type", this.contentType);
    }

    @Override
    @NonNull
    protected Uri getURL() {
        Uri.Builder uriBuilder = sNetworkRequestUrl.buildUpon();
        uriBuilder.appendPath("b");
        uriBuilder.appendPath(this.mGsUri.getAuthority());
        uriBuilder.appendPath("o");
        return uriBuilder.build();
    }

    @Override
    @NonNull
    protected String getAction() {
        return "POST";
    }

    @Override
    @NonNull
    protected Map<String, String> getQueryParameters() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("name", this.getPathWithoutBucket());
        headers.put("uploadType", "resumable");
        return headers;
    }

    @Override
    @Nullable
    protected JSONObject getOutputJSON() {
        return this.metadata;
    }
}

