/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.ListResult;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.ListNetworkRequest;
import org.json.JSONException;

class ListTask
implements Runnable {
    private static final String TAG = "ListTask";
    private final StorageReference storageRef;
    private final TaskCompletionSource<ListResult> pendingResult;
    private final ExponentialBackoffSender sender;
    @Nullable
    private final String pageToken;
    @Nullable
    private final Integer maxResults;

    ListTask(@NonNull StorageReference storageRef, @Nullable Integer maxResults, @Nullable String pageToken, @NonNull TaskCompletionSource<ListResult> pendingResult) {
        Preconditions.checkNotNull((Object)storageRef);
        Preconditions.checkNotNull(pendingResult);
        this.storageRef = storageRef;
        this.maxResults = maxResults;
        this.pageToken = pageToken;
        this.pendingResult = pendingResult;
        FirebaseStorage storage = this.storageRef.getStorage();
        this.sender = new ExponentialBackoffSender(storage.getApp().getApplicationContext(), storage.getAuthProvider(), storage.getAppCheckProvider(), storage.getMaxDownloadRetryTimeMillis());
    }

    @Override
    public void run() {
        ListNetworkRequest request = new ListNetworkRequest(this.storageRef.getStorageReferenceUri(), this.storageRef.getApp(), this.maxResults, this.pageToken);
        this.sender.sendWithExponentialBackoff(request);
        ListResult listResult = null;
        if (request.isResultSuccess()) {
            try {
                listResult = ListResult.fromJSON(this.storageRef.getStorage(), request.getResultBody());
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Unable to parse response body. " + request.getRawResult()), (Throwable)e);
                this.pendingResult.setException((Exception)((Object)StorageException.fromException(e)));
                return;
            }
        }
        if (this.pendingResult != null) {
            request.completeTask(this.pendingResult, listResult);
        }
    }
}

