/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.network;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.emulators.EmulatedServiceSettings;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.internal.StorageReferenceUri;
import com.google.firebase.storage.network.connection.HttpURLConnectionFactory;
import com.google.firebase.storage.network.connection.HttpURLConnectionFactoryImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class NetworkRequest {
    private static final String TAG = "NetworkRequest";
    private static final String X_FIREBASE_GMPID = "x-firebase-gmpid";
    private static final String X_FIREBASE_APPCHECK = "x-firebase-appcheck";
    public static final Uri PROD_BASE_URL = Uri.parse((String)"https://firebasestorage.googleapis.com/v0");
    public static final int INITIALIZATION_EXCEPTION = -1;
    public static final int NETWORK_UNAVAILABLE = -2;
    static final String GET = "GET";
    static final String DELETE = "DELETE";
    static final String POST = "POST";
    static final String PATCH = "PATCH";
    static final String PUT = "PUT";
    private static final int MAXIMUM_TOKEN_WAIT_TIME_MS = 30000;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String UTF_8 = "UTF-8";
    static HttpURLConnectionFactory connectionFactory = new HttpURLConnectionFactoryImpl();
    protected Exception mException;
    private StorageReferenceUri storageReferenceUri;
    private static String gmsCoreVersion;
    private Context context;
    private Map<String, List<String>> resultHeaders;
    private int resultCode;
    private String rawStringResponse;
    private int resultingContentLength;
    private InputStream resultInputStream;
    private HttpURLConnection connection;
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    public NetworkRequest(@NonNull StorageReferenceUri storageReferenceUri, @NonNull FirebaseApp app) {
        Preconditions.checkNotNull((Object)storageReferenceUri);
        Preconditions.checkNotNull((Object)app);
        this.storageReferenceUri = storageReferenceUri;
        this.context = app.getApplicationContext();
        this.setCustomHeader(X_FIREBASE_GMPID, app.getOptions().getApplicationId());
    }

    @NonNull
    public static Uri getBaseUrl(@Nullable EmulatedServiceSettings emulatorSettings) {
        if (emulatorSettings != null) {
            return Uri.parse((String)("http://" + emulatorSettings.getHost() + ":" + emulatorSettings.getPort() + "/v0"));
        }
        return PROD_BASE_URL;
    }

    private static String getPathWithoutBucket(@NonNull Uri gsUri) {
        String path = gsUri.getPath();
        if (path == null) {
            return "";
        }
        return path.startsWith("/") ? path.substring(1) : path;
    }

    String getPathWithoutBucket() {
        return NetworkRequest.getPathWithoutBucket(this.storageReferenceUri.getGsUri());
    }

    @NonNull
    protected abstract String getAction();

    @NonNull
    @VisibleForTesting
    public Uri getURL() {
        return this.storageReferenceUri.getHttpUri();
    }

    @Nullable
    protected JSONObject getOutputJSON() {
        return null;
    }

    @Nullable
    protected byte[] getOutputRaw() {
        return null;
    }

    protected int getOutputRawSize() {
        return 0;
    }

    @Nullable
    protected Map<String, String> getQueryParameters() {
        return null;
    }

    @NonNull
    protected StorageReferenceUri getStorageReferenceUri() {
        return this.storageReferenceUri;
    }

    public final void reset() {
        this.mException = null;
        this.resultCode = 0;
    }

    public void setCustomHeader(String key, String value) {
        this.requestHeaders.put(key, value);
    }

    public InputStream getStream() {
        return this.resultInputStream;
    }

    public JSONObject getResultBody() {
        JSONObject resultBody;
        if (!TextUtils.isEmpty((CharSequence)this.rawStringResponse)) {
            try {
                resultBody = new JSONObject(this.rawStringResponse);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("error parsing result into JSON:" + this.rawStringResponse), (Throwable)e);
                resultBody = new JSONObject();
            }
        } else {
            resultBody = new JSONObject();
        }
        return resultBody;
    }

    public void performRequestStart(@Nullable String authToken, @Nullable String appCheckToken) {
        ConnectivityManager connMgr;
        NetworkInfo networkInfo;
        if (this.mException != null) {
            this.resultCode = -1;
            return;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("sending network request " + this.getAction() + " " + this.getURL()));
        }
        if ((networkInfo = (connMgr = (ConnectivityManager)this.context.getSystemService("connectivity")).getActiveNetworkInfo()) == null || !networkInfo.isConnected()) {
            this.resultCode = -2;
            this.mException = new SocketException("Network subsystem is unavailable");
            return;
        }
        try {
            this.connection = this.createConnection();
            this.connection.setRequestMethod(this.getAction());
            this.constructMessage(this.connection, authToken, appCheckToken);
            this.parseResponse(this.connection);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("network request result " + this.resultCode));
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("error sending network request " + this.getAction() + " " + this.getURL()), (Throwable)e);
            this.mException = e;
            this.resultCode = -2;
        }
    }

    public void performRequestEnd() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private final void performRequest(@Nullable String authToken, @Nullable String appCheckToken) {
        this.performRequestStart(authToken, appCheckToken);
        try {
            this.processResponseStream();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("error sending network request " + this.getAction() + " " + this.getURL()), (Throwable)e);
            this.mException = e;
            this.resultCode = -2;
        }
        this.performRequestEnd();
    }

    public void performRequest(@Nullable String authToken, @Nullable String appCheckToken, @NonNull Context applicationContext) {
        if (!this.ensureNetworkAvailable(applicationContext)) {
            return;
        }
        this.performRequest(authToken, appCheckToken);
    }

    private boolean ensureNetworkAvailable(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.mException = new SocketException("Network subsystem is unavailable");
            this.resultCode = -2;
            return false;
        }
        return true;
    }

    private HttpURLConnection createConnection() throws IOException {
        Uri connectionUri = this.getURL();
        Map<String, String> queryParams = this.getQueryParameters();
        if (queryParams != null) {
            Uri.Builder uriBuilder = connectionUri.buildUpon();
            for (Map.Entry<String, String> param : queryParams.entrySet()) {
                uriBuilder.appendQueryParameter(param.getKey(), param.getValue());
            }
            connectionUri = uriBuilder.build();
        }
        HttpURLConnection conn = connectionFactory.createInstance(new URL(connectionUri.toString()));
        return conn;
    }

    @NonNull
    private static String getGmsCoreVersion(Context context) {
        if (gmsCoreVersion == null) {
            PackageManager packageManager = context.getPackageManager();
            try {
                PackageInfo info = packageManager.getPackageInfo("com.google.android.gms", 0);
                gmsCoreVersion = info.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)"Unable to find gmscore in package manager", (Throwable)e);
            }
            if (gmsCoreVersion == null) {
                gmsCoreVersion = "[No Gmscore]";
            }
        }
        return gmsCoreVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructMessage(@NonNull HttpURLConnection conn, @Nullable String authToken, @Nullable String appCheckToken) throws IOException {
        int rawSize;
        byte[] rawOutput;
        Preconditions.checkNotNull((Object)conn);
        if (!TextUtils.isEmpty((CharSequence)authToken)) {
            conn.setRequestProperty("Authorization", "Firebase " + authToken);
        } else {
            Log.w((String)TAG, (String)"no auth token for request");
        }
        if (!TextUtils.isEmpty((CharSequence)appCheckToken)) {
            conn.setRequestProperty(X_FIREBASE_APPCHECK, appCheckToken);
        } else {
            Log.w((String)TAG, (String)"No App Check token for request.");
        }
        StringBuilder userAgent = new StringBuilder("Android/");
        String gmsCore = NetworkRequest.getGmsCoreVersion(this.context);
        if (!TextUtils.isEmpty((CharSequence)gmsCore)) {
            userAgent.append(gmsCore);
        }
        conn.setRequestProperty("X-Firebase-Storage-Version", userAgent.toString());
        Map<String, String> requestProperties = this.requestHeaders;
        for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        JSONObject jsonObject = this.getOutputJSON();
        if (jsonObject != null) {
            rawOutput = jsonObject.toString().getBytes(UTF_8);
            rawSize = rawOutput.length;
        } else {
            rawOutput = this.getOutputRaw();
            rawSize = this.getOutputRawSize();
            if (rawSize == 0 && rawOutput != null) {
                rawSize = rawOutput.length;
            }
        }
        if (rawOutput != null && rawOutput.length > 0) {
            if (jsonObject != null) {
                conn.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
            }
            conn.setDoOutput(true);
            conn.setRequestProperty(CONTENT_LENGTH, Integer.toString(rawSize));
        } else {
            conn.setRequestProperty(CONTENT_LENGTH, "0");
        }
        conn.setUseCaches(false);
        conn.setDoInput(true);
        if (rawOutput != null && rawOutput.length > 0) {
            OutputStream outputStream = conn.getOutputStream();
            if (outputStream != null) {
                try (BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);){
                    bufferedStream.write(rawOutput, 0, rawSize);
                }
            } else {
                Log.e((String)TAG, (String)"Unable to write to the http request!");
            }
        }
    }

    private void parseResponse(@NonNull HttpURLConnection conn) throws IOException {
        Preconditions.checkNotNull((Object)conn);
        this.resultCode = conn.getResponseCode();
        this.resultHeaders = conn.getHeaderFields();
        this.resultingContentLength = conn.getContentLength();
        this.resultInputStream = this.isResultSuccess() ? conn.getInputStream() : conn.getErrorStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResponse(@Nullable InputStream resultStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (resultStream != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(resultStream, UTF_8));){
                String input;
                while ((input = br.readLine()) != null) {
                    sb.append(input);
                }
            }
        }
        this.rawStringResponse = sb.toString();
        if (!this.isResultSuccess()) {
            this.mException = new IOException(this.rawStringResponse);
        }
    }

    private void processResponseStream() throws IOException {
        if (this.isResultSuccess()) {
            this.parseSuccessulResponse(this.resultInputStream);
        } else {
            this.parseErrorResponse(this.resultInputStream);
        }
    }

    protected void parseSuccessulResponse(@Nullable InputStream resultStream) throws IOException {
        this.parseResponse(resultStream);
    }

    protected void parseErrorResponse(@Nullable InputStream resultStream) throws IOException {
        this.parseResponse(resultStream);
    }

    @Nullable
    public String getRawResult() {
        return this.rawStringResponse;
    }

    @NonNull
    public Map<String, String> getResultHeaders() {
        return this.requestHeaders;
    }

    @Nullable
    public Exception getException() {
        return this.mException;
    }

    @Nullable
    public Map<String, List<String>> getResultHeadersImpl() {
        return this.resultHeaders;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public boolean isResultSuccess() {
        return this.resultCode >= 200 && this.resultCode < 300;
    }

    @Nullable
    public String getResultString(String key) {
        List<String> urlList;
        Map<String, List<String>> resultHeaders = this.getResultHeadersImpl();
        if (resultHeaders != null && (urlList = resultHeaders.get(key)) != null && urlList.size() > 0) {
            return urlList.get(0);
        }
        return null;
    }

    public int getResultingContentLength() {
        return this.resultingContentLength;
    }

    public <TResult> void completeTask(TaskCompletionSource<TResult> source, TResult result) {
        Exception exception = this.getException();
        if (this.isResultSuccess() && exception == null) {
            source.setResult(result);
        } else {
            StorageException se = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (se != null);
            source.setException((Exception)((Object)se));
        }
    }
}

