/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzajt;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.IOException;
import java.io.InputStream;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzbTR;
    private zzajk zzbTT;
    private volatile Exception zzbwC = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzbVa;
    private long zzbTV;
    private long zzawx;
    private long zzbVb;
    private InputStream zzbCO;
    private zzajt zzbVc;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzbTR = storageReference;
        this.zzbTT = new zzajk(this.zzbTR.getApp(), this.zzbTR.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzaa.zzz((Object)streamProcessor);
        zzaa.zzai((this.zzbVa == null ? 1 : 0) != 0);
        this.zzbVa = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzbTR;
    }

    long getTotalBytes() {
        return this.zzawx;
    }

    private void zzaM(long l) {
        this.zzbTV += l;
        if (this.zzbVb + 262144L <= this.zzbTV) {
            this.zzi(4, false);
        }
    }

    @Override
    protected void schedule() {
        zzd.zzVc().zzn(this.zzVa());
    }

    @Override
    void run() {
        boolean bl;
        this.zzbTT.reset();
        if (this.zzbwC != null) {
            this.zzi(64, false);
            return;
        }
        if (!this.zzi(4, false)) {
            return;
        }
        try {
            this.zzbVc = this.zzbTR.zzUT().zza(this.zzbTR.zzUU(), 0L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.zzbwC = remoteException;
            this.zzi(64, false);
            return;
        }
        this.zzbTT.zza(this.zzbVc, false);
        this.mResultCode = this.zzbVc.getResultCode();
        this.zzbwC = this.zzbVc.getException() != null ? this.zzbVc.getException() : this.zzbwC;
        boolean bl2 = bl = this.zznK(this.mResultCode) && this.zzbwC == null && this.zzUW() == 4;
        if (bl) {
            this.zzawx = this.zzbVc.zzVu();
            InputStream inputStream = this.zzbVc.getStream();
            if (inputStream != null) {
                this.zzbCO = new zza(this, inputStream);
                if (this.zzbVa != null) {
                    try {
                        this.zzbVa.doInBackground((TaskSnapshot)this.zzUY(), this.zzbCO);
                    }
                    catch (Exception exception) {
                        Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                        this.zzbwC = exception;
                    }
                }
            } else {
                this.zzbwC = new IOException("Could not open resulting stream.");
            }
        }
        if (this.zzbCO == null) {
            this.zzbVc.zzVn();
        }
        boolean bl3 = bl = bl && this.zzbwC == null && this.zzUW() == 4;
        if (bl) {
            this.zzi(4, false);
            this.zzi(128, false);
        } else if (!this.zzi(this.zzUW() == 32 ? 256 : 64, false)) {
            int n = this.zzUW();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot zzVd() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbwC, this.mResultCode)), this.zzbVb);
    }

    @Override
    protected void onCanceled() {
        this.zzbTT.cancel();
    }

    @Override
    protected void onProgress() {
        this.zzbVb = this.zzbTV;
    }

    private boolean zznK(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzUQ() {
        return this.zzVd();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzbTV;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.zzbTV = l;
        }

        public long getBytesTransferred() {
            return this.zzbTV;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.zzbCO;
        }
    }

    private static class zza
    extends InputStream {
        private StreamDownloadTask zzbVd;
        private InputStream zzbVe;
        private int zzbVf;

        public zza(@NonNull StreamDownloadTask streamDownloadTask, @NonNull InputStream inputStream) {
            this.zzbVd = streamDownloadTask;
            this.zzbVe = inputStream;
        }

        private void zzVe() throws IOException {
            if (this.zzbVd.zzUW() == 32) {
                throw StorageException.zzbUe;
            }
        }

        @Override
        public int read() throws IOException {
            this.zzVe();
            int n = this.zzbVe.read();
            if (n != -1) {
                this.zzbVd.zzaM(1L);
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            this.zzVe();
            return this.zzbVe.available();
        }

        @Override
        public void close() throws IOException {
            this.zzbVe.close();
            if (this.zzbVd.zzbVc != null) {
                this.zzbVd.zzbVc.zzVn();
            }
            this.zzVe();
        }

        @Override
        public void mark(int n) {
            this.zzbVf = n;
            this.zzbVe.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this.zzbVe.markSupported();
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.zzVe();
            int n4 = 0;
            while ((long)n2 > 262144L) {
                n3 = this.zzbVe.read(byArray, n, 262144);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                n += n3;
                n2 -= n3;
                this.zzbVd.zzaM(n3);
                this.zzVe();
                if ((long)n3 >= 262144L) continue;
                break;
            }
            if (n2 > 0) {
                n3 = this.zzbVe.read(byArray, n, n2);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                this.zzbVd.zzaM(n3);
            }
            return n4;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.zzVe();
            this.zzbVd.zzaM(-this.zzbVf);
            this.zzbVe.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            this.zzVe();
            int n = 0;
            while (l > 262144L) {
                l2 = this.zzbVe.skip(262144L);
                n = (int)((long)n + l2);
                if (l2 < 262144L) {
                    this.zzbVd.zzaM(l2);
                    return n;
                }
                this.zzbVd.zzaM(262144L);
                l -= 262144L;
                this.zzVe();
            }
            l2 = this.zzbVe.skip(l);
            n = (int)((long)n + l2);
            this.zzbVd.zzaM(l2);
            return n;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

