/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzajq;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzajt {
    private zzajq zzbVK;
    private Exception zzbwC;
    private int zzbVL;
    private Exception zzbVM;

    public zzajt(@NonNull zzajq zzajq2) {
        this.zzbVK = zzajq2;
    }

    private boolean zzbH(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzbVL = -2;
            this.zzbVM = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zziN(String string) {
        try {
            return this.zzbVK.zziN(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zza(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzbH(context)) {
                return;
            }
            this.zzbVK.zziL(string);
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.zzbVL = 0;
            this.zzbVM = null;
            this.zzbVK.reset();
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zziM(@Nullable String string) {
        try {
            this.zzbVK.zziM(string);
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzVn() {
        try {
            this.zzbVK.zzVn();
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zze.zzx((zzd)this.zzbVK.zzVo());
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject zzVw() throws RemoteException {
        return (JSONObject)zze.zzx((zzd)this.zzbVK.zzVp());
    }

    @Nullable
    public String zzVq() {
        try {
            this.zzbVK.zzVq();
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.zzbVM != null) {
                return this.zzbVM;
            }
            return this.zzbwC != null ? this.zzbwC : (Exception)zze.zzx((zzd)this.zzbVK.zzVs());
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.zzbVL != 0) {
                return this.zzbVL;
            }
            return this.zzbVK.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean zzVt() {
        try {
            if (this.zzbVL == -2 || this.zzbVM != null) {
                return false;
            }
            return this.zzbVK.zzVt();
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzVt() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int zzVu() {
        try {
            return this.zzbVK.zzVu();
        }
        catch (RemoteException remoteException) {
            this.zzbwC = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

