/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzc;
import com.google.firebase.storage.zze;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zzbUE = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzbUF = new HashMap();
    protected final Object mSyncObject = new Object();
    private final zze<OnSuccessListener<? super TResult>, TResult> zzbUG = new zze(this, 128, new zze.zza<OnSuccessListener<? super TResult>, TResult>(){

        public void zza(@NonNull OnSuccessListener<? super TResult> onSuccessListener, @NonNull TResult TResult) {
            zzc.zzVb().zzb(StorageTask.this);
            onSuccessListener.onSuccess(TResult);
        }

        @Override
        public /* synthetic */ void zzl(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnSuccessListener)object, (ProvideError)object2);
        }
    });
    private final zze<OnFailureListener, TResult> zzbUH = new zze(this, 320, new zze.zza<OnFailureListener, TResult>(){

        public void zza(@NonNull OnFailureListener onFailureListener, @NonNull TResult TResult) {
            zzc.zzVb().zzb(StorageTask.this);
            onFailureListener.onFailure(TResult.getError());
        }

        @Override
        public /* synthetic */ void zzl(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnFailureListener)object, (ProvideError)object2);
        }
    });
    private final zze<OnProgressListener<? super TResult>, TResult> zzbUI = new zze(this, -465, new zze.zza<OnProgressListener<? super TResult>, TResult>(){

        public void zza(@NonNull OnProgressListener<? super TResult> onProgressListener, @NonNull TResult TResult) {
            onProgressListener.onProgress(TResult);
        }

        @Override
        public /* synthetic */ void zzl(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnProgressListener)object, (ProvideError)object2);
        }
    });
    private final zze<OnPausedListener<? super TResult>, TResult> zzbUJ = new zze(this, 16, new zze.zza<OnPausedListener<? super TResult>, TResult>(){

        public void zza(@NonNull OnPausedListener<? super TResult> onPausedListener, @NonNull TResult TResult) {
            onPausedListener.onPaused(TResult);
        }

        @Override
        public /* synthetic */ void zzl(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnPausedListener)object, (ProvideError)object2);
        }
    });
    private int zzGN = 1;
    private TResult zzbUK;

    protected StorageTask() {
    }

    boolean zzUV() {
        if (this.zzi(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    void resetState() {
    }

    abstract StorageReference getStorage();

    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzi(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zzi(16, true) || this.zzi(8, true);
    }

    @Override
    public boolean cancel() {
        return this.zzi(256, true) || this.zzi(32, true);
    }

    public boolean isComplete() {
        return (this.zzUW() & 0x80) != 0 || (this.zzUW() & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzUW() & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzUW() == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzUW() & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzUW() & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzUZ() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzUZ().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzUZ();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzUZ() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzUZ().getError())) {
            throw (Throwable)clazz.cast(this.zzUZ().getError());
        }
        Exception exception = this.zzUZ().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzUZ();
    }

    @Nullable
    public Exception getException() {
        if (this.zzUZ() == null) {
            return null;
        }
        return this.zzUZ().getError();
    }

    public TResult getSnapshot() {
        return this.zzUY();
    }

    int zzUW() {
        return this.zzGN;
    }

    Object zzUX() {
        return this.mSyncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    TResult zzUY() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzUQ();
        }
    }

    @NonNull
    abstract TResult zzUQ();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzi(int n, boolean bl) {
        Object object;
        Object object2;
        if (Log.isLoggable((String)"StorageTask", (int)3)) {
            object2 = String.valueOf(this.zznN(n));
            object = String.valueOf(this.zznN(this.zzGN));
            Log.d((String)"StorageTask", (String)new StringBuilder(54 + String.valueOf(object2).length() + String.valueOf(object).length()).append("changing internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append((String)object).toString());
        }
        object2 = this.mSyncObject;
        synchronized (object2) {
            object = bl ? zzbUE : zzbUF;
            HashSet<Integer> hashSet = ((HashMap)object).get(this.zzUW());
            if (hashSet != null && hashSet.contains(n)) {
                this.zzGN = n;
                switch (this.zzGN) {
                    case 2: {
                        zzc.zzVb().zza(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzbUG.zzVf();
                this.zzbUH.zzVf();
                this.zzbUJ.zzVf();
                this.zzbUI.zzVf();
                return true;
            }
            String string = String.valueOf(this.zznN(n));
            String string2 = String.valueOf(this.zznN(this.zzGN));
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string2).length()).append("unable to change internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
            return false;
        }
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private TResult zzUZ() {
        if (this.zzbUK != null) {
            return this.zzbUK;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzbUK == null) {
            this.zzbUK = this.zzUY();
        }
        return this.zzbUK;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzaa.zzz(onPausedListener);
        this.zzbUJ.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzaa.zzz(onPausedListener);
        zzaa.zzz((Object)executor);
        this.zzbUJ.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzaa.zzz(onPausedListener);
        zzaa.zzz((Object)activity);
        this.zzbUJ.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzaa.zzz(onPausedListener);
        this.zzbUJ.zzaF(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzaa.zzz(onProgressListener);
        this.zzbUI.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzaa.zzz(onProgressListener);
        zzaa.zzz((Object)executor);
        this.zzbUI.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzaa.zzz(onProgressListener);
        zzaa.zzz((Object)activity);
        this.zzbUI.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzaa.zzz(onProgressListener);
        this.zzbUI.zzaF(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzaa.zzz(onSuccessListener);
        this.zzbUG.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzaa.zzz((Object)executor);
        zzaa.zzz(onSuccessListener);
        this.zzbUG.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzaa.zzz((Object)activity);
        zzaa.zzz(onSuccessListener);
        this.zzbUG.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzaa.zzz(onSuccessListener);
        this.zzbUG.zzaF(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzaa.zzz((Object)onFailureListener);
        this.zzbUH.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzaa.zzz((Object)onFailureListener);
        zzaa.zzz((Object)executor);
        this.zzbUH.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzaa.zzz((Object)onFailureListener);
        zzaa.zzz((Object)activity);
        this.zzbUH.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzaa.zzz((Object)onFailureListener);
        this.zzbUH.zzaF(onFailureListener);
        return this;
    }

    abstract void run();

    Runnable zzVa() {
        return new Runnable(){

            @Override
            public void run() {
                StorageTask.this.run();
            }
        };
    }

    private String zznN(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static {
        zzbUE.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zzbUE.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzbUE.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzbUE.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzbUE.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzbUF.put(1, new HashSet<Integer>(Collections.singletonList(2)));
        zzbUF.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzbUF.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzbUF.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzbUF.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    class SnapshotBase
    implements ProvideError {
        private final Exception zzbUM;

        public SnapshotBase(Exception exception) {
            this.zzbUM = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return StorageTask.this;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zzbUM;
        }
    }

    protected static interface ProvideError {
        public Exception getError();
    }
}

