/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.GetTokenResult;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzami {
    public static long zzsr(@Nullable String string) {
        if (string == null) {
            return 0L;
        }
        string = string.replaceAll("Z$", "-0000");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        try {
            return simpleDateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            String string2 = String.valueOf(string);
            Log.w((String)"StorageUtil", (String)(string2.length() != 0 ? "unable to parse datetime:".concat(string2) : new String("unable to parse datetime:")), (Throwable)parseException);
            return 0L;
        }
    }

    public static boolean equals(@Nullable Object object, @Nullable Object object2) {
        return zzaa.equal((Object)object, (Object)object2);
    }

    private static String zzg(FirebaseApp firebaseApp) throws RemoteException {
        return zzaml.zzi(firebaseApp).zzczc();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Uri zzc(@NonNull FirebaseApp firebaseApp, @Nullable String string) throws UnsupportedEncodingException {
        String string2;
        String string3;
        block11: {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            String string4 = string.toLowerCase();
            if (string4.startsWith("gs://")) {
                String string5;
                String string6 = zzame.zzso((String)zzame.zzsq((String)string.substring(5)));
                String string7 = String.valueOf(string6);
                if (string7.length() != 0) {
                    string5 = "gs://".concat(string7);
                    return Uri.parse((String)string5);
                }
                string5 = new String("gs://");
                return Uri.parse((String)string5);
            }
            Uri uri = Uri.parse((String)string);
            String string8 = uri.getScheme().toLowerCase();
            if (zzami.equals(string8, "http") || zzami.equals(string8, "https")) {
                int n;
                String string9 = uri.getAuthority().toLowerCase();
                try {
                    n = string9.indexOf(zzami.zzg(firebaseApp));
                }
                catch (RemoteException remoteException) {
                    throw new UnsupportedEncodingException("Could not parse Url because the Storage network layer did not load");
                }
                string3 = zzame.zzsp((String)uri.getEncodedPath());
                if (n == 0 && string3.startsWith("/")) {
                    int n2 = string3.indexOf("/b/", 0);
                    int n3 = string3.indexOf("/", n2 + 3);
                    int n4 = string3.indexOf("/o/", 0);
                    if (n2 != -1 && n3 != -1) {
                        string2 = string3.substring(n2 + 3, n3);
                        string3 = n4 != -1 ? string3.substring(n4 + 3) : "";
                        break block11;
                    } else {
                        Log.w((String)"StorageUtil", (String)"Only URLs to firebasestorage.googleapis.com are supported.");
                        throw new IllegalArgumentException("Only URLs to firebasestorage.googleapis.com are supported.");
                    }
                }
                if (n <= 1) {
                    Log.w((String)"StorageUtil", (String)"Only URLs to firebasestorage.googleapis.com are supported.");
                    throw new IllegalArgumentException("Only URLs to firebasestorage.googleapis.com are supported.");
                }
                string2 = uri.getAuthority().substring(0, n - 1);
            } else {
                String string10 = String.valueOf(string8);
                Log.w((String)"StorageUtil", (String)(string10.length() != 0 ? "FirebaseStorage is unable to support the scheme:".concat(string10) : new String("FirebaseStorage is unable to support the scheme:")));
                throw new IllegalArgumentException("Uri scheme");
            }
        }
        zzab.zzh((String)string2, (Object)"No bucket specified");
        return new Uri.Builder().scheme("gs").authority(string2).encodedPath(string3).build();
    }

    @Nullable
    public static String zzh(FirebaseApp firebaseApp) {
        Task task = firebaseApp.getToken(false);
        try {
            GetTokenResult getTokenResult = (GetTokenResult)Tasks.await((Task)task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
            String string = getTokenResult.getToken();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            Log.w((String)"StorageUtil", (String)"no auth token for request");
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            String string = String.valueOf(exception);
            Log.e((String)"StorageUtil", (String)new StringBuilder(20 + String.valueOf(string).length()).append("error getting token ").append(string).toString());
        }
        return null;
    }
}

