/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzamm {
    private zzamj bdL;
    private Exception aDS;
    private int bdM;
    private Exception bdN;

    public zzamm(@NonNull zzamj zzamj2) {
        this.bdL = zzamj2;
    }

    private boolean zzet(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.bdM = -2;
            this.bdN = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zzsu(String string) {
        try {
            return this.bdL.zzsu(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zza(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzet(context)) {
                return;
            }
            this.bdL.zzss(string);
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.bdM = 0;
            this.bdN = null;
            this.bdL.reset();
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzst(@Nullable String string) {
        try {
            this.bdL.zzst(string);
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzcyu() {
        try {
            this.bdL.zzcyu();
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zze.zzad((zzd)this.bdL.zzcyv());
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject zzczd() throws RemoteException {
        return (JSONObject)zze.zzad((zzd)this.bdL.zzcyw());
    }

    @Nullable
    public String zzcyx() {
        try {
            this.bdL.zzcyx();
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.bdN != null) {
                return this.bdN;
            }
            return this.aDS != null ? this.aDS : (Exception)zze.zzad((zzd)this.bdL.zzcyz());
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.bdM != 0) {
                return this.bdM;
            }
            return this.bdL.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean zzcza() {
        try {
            if (this.bdM == -2 || this.bdN != null) {
                return false;
            }
            return this.bdL.zzcza();
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzcza() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int zzczb() {
        try {
            return this.bdL.zzczb();
        }
        catch (RemoteException remoteException) {
            this.aDS = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

