/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzamd;
import com.google.android.gms.internal.zzamm;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri bbV;
    private long bbW;
    private StorageReference bbS;
    private zzamd bbU;
    private long Go = -1L;
    private String bbX = null;
    private volatile Exception aDS = null;
    private long bbY = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.bbS = storageReference;
        this.bbV = uri;
        this.bbU = new zzamd(this.bbS.getStorage().getApp(), this.bbS.getStorage().getMaxDownloadRetryTimeMillis());
    }

    long getTotalBytes() {
        return this.Go;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.bbS;
    }

    @Override
    protected void schedule() {
        zzd.zzcyj().zzu(this.zzcjq());
    }

    @NonNull
    TaskSnapshot zzcxx() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.aDS, this.mResultCode)), this.bbW);
    }

    @Override
    void run() {
        Object object;
        boolean bl;
        zzamm zzamm2;
        this.zzi(4, false);
        this.bbU.reset();
        try {
            zzamm2 = this.bbS.zzcyb().zza(this.bbS.zzcyc(), this.bbY);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.aDS = remoteException;
            this.zzi(64, false);
            return;
        }
        this.bbU.zza(zzamm2, false);
        this.mResultCode = zzamm2.getResultCode();
        this.aDS = zzamm2.getException() != null ? zzamm2.getException() : this.aDS;
        boolean bl2 = bl = this.zzadw(this.mResultCode) && this.aDS == null && this.zzcye() == 4;
        if (bl) {
            this.Go = zzamm2.zzczb();
            object = zzamm2.zzsu("ETag");
            if (!TextUtils.isEmpty((CharSequence)object) && this.bbX != null && !this.bbX.equals(object)) {
                Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                this.bbY = 0L;
                this.bbX = null;
                zzamm2.zzcyu();
                this.schedule();
                return;
            }
            this.bbX = object;
            InputStream inputStream = zzamm2.getStream();
            if (inputStream != null) {
                try {
                    int n;
                    FileOutputStream fileOutputStream;
                    File file = new File(this.bbV.getPath());
                    if (!file.exists()) {
                        if (this.bbY > 0L) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                            throw new IllegalStateException("expected a file to resume from.");
                        }
                        boolean bl3 = file.createNewFile();
                        if (!bl3) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                        }
                    }
                    if (this.bbY > 0L) {
                        String string = String.valueOf(file.getAbsolutePath());
                        Log.d((String)"FileDownloadTask", (String)(string.length() != 0 ? "Resuming download file ".concat(string) : new String("Resuming download file ")));
                        fileOutputStream = new FileOutputStream(file, true);
                    } else {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    byte[] byArray = new byte[262144];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        this.bbW += (long)n;
                        if (this.zzi(4, false)) continue;
                    }
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    inputStream.close();
                }
                catch (Exception exception) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file download", (Throwable)exception);
                    this.aDS = exception;
                }
            } else {
                this.aDS = new IllegalStateException("Unable to open Firebase Storage stream.");
            }
        }
        zzamm2.zzcyu();
        boolean bl4 = bl = bl && this.aDS == null && this.zzcye() == 4;
        if (bl) {
            this.zzi(128, false);
        } else {
            object = new File(this.bbV.getPath());
            this.bbY = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcye() == 8) {
                this.zzi(16, false);
            } else if (!this.zzi(this.zzcye() == 32 ? 256 : 64, false)) {
                int n = this.zzcye();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
            }
        }
    }

    @Override
    protected void onCanceled() {
        this.bbU.cancel();
    }

    private boolean zzadw(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzcxy() {
        return this.zzcxx();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long bbW;

        TaskSnapshot(Exception exception, long l) {
            super(FileDownloadTask.this, exception);
            this.bbW = l;
        }

        public long getBytesTransferred() {
            return this.bbW;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

