/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzamd;
import com.google.android.gms.internal.zzamm;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.IOException;
import java.io.InputStream;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference bbS;
    private zzamd bbU;
    private volatile Exception aDS = null;
    private volatile int mResultCode = 0;
    private StreamProcessor bdb;
    private long bbW;
    private long Go;
    private long bdc;
    private InputStream aKk;
    private zzamm bdd;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.bbS = storageReference;
        this.bbU = new zzamd(this.bbS.getApp(), this.bbS.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzab.zzaa((Object)streamProcessor);
        zzab.zzbm((this.bdb == null ? 1 : 0) != 0);
        this.bdb = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.bbS;
    }

    long getTotalBytes() {
        return this.Go;
    }

    private void zzco(long l) {
        this.bbW += l;
        if (this.bdc + 262144L <= this.bbW) {
            this.zzi(4, false);
        }
    }

    @Override
    protected void schedule() {
        zzd.zzcyj().zzu(this.zzcjq());
    }

    @Override
    void run() {
        boolean bl;
        this.bbU.reset();
        if (this.aDS != null) {
            this.zzi(64, false);
            return;
        }
        if (!this.zzi(4, false)) {
            return;
        }
        try {
            this.bdd = this.bbS.zzcyb().zza(this.bbS.zzcyc(), 0L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.aDS = remoteException;
            this.zzi(64, false);
            return;
        }
        this.bbU.zza(this.bdd, false);
        this.mResultCode = this.bdd.getResultCode();
        this.aDS = this.bdd.getException() != null ? this.bdd.getException() : this.aDS;
        boolean bl2 = bl = this.zzadw(this.mResultCode) && this.aDS == null && this.zzcye() == 4;
        if (bl) {
            this.Go = this.bdd.zzczb();
            InputStream inputStream = this.bdd.getStream();
            if (inputStream != null) {
                this.aKk = new zza(this, inputStream);
                if (this.bdb != null) {
                    try {
                        this.bdb.doInBackground((TaskSnapshot)this.zzcyg(), this.aKk);
                    }
                    catch (Exception exception) {
                        Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                        this.aDS = exception;
                    }
                }
            } else {
                this.aDS = new IOException("Could not open resulting stream.");
            }
        }
        if (this.aKk == null) {
            this.bdd.zzcyu();
        }
        boolean bl3 = bl = bl && this.aDS == null && this.zzcye() == 4;
        if (bl) {
            this.zzi(4, false);
            this.zzi(128, false);
        } else if (!this.zzi(this.zzcye() == 32 ? 256 : 64, false)) {
            int n = this.zzcye();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot zzcyk() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.aDS, this.mResultCode)), this.bdc);
    }

    @Override
    protected void onCanceled() {
        this.bbU.cancel();
    }

    @Override
    protected void onProgress() {
        this.bdc = this.bbW;
    }

    private boolean zzadw(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzcxy() {
        return this.zzcyk();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long bbW;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.bbW = l;
        }

        public long getBytesTransferred() {
            return this.bbW;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.aKk;
        }
    }

    private static class zza
    extends InputStream {
        private StreamDownloadTask bde;
        private InputStream bdf;
        private int bdg;

        public zza(@NonNull StreamDownloadTask streamDownloadTask, @NonNull InputStream inputStream) {
            this.bde = streamDownloadTask;
            this.bdf = inputStream;
        }

        private void zzcyl() throws IOException {
            if (this.bde.zzcye() == 32) {
                throw StorageException.bcf;
            }
        }

        @Override
        public int read() throws IOException {
            this.zzcyl();
            int n = this.bdf.read();
            if (n != -1) {
                this.bde.zzco(1L);
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            this.zzcyl();
            return this.bdf.available();
        }

        @Override
        public void close() throws IOException {
            this.bdf.close();
            if (this.bde.bdd != null) {
                this.bde.bdd.zzcyu();
            }
            this.zzcyl();
        }

        @Override
        public void mark(int n) {
            this.bdg = n;
            this.bdf.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this.bdf.markSupported();
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.zzcyl();
            int n4 = 0;
            while ((long)n2 > 262144L) {
                n3 = this.bdf.read(byArray, n, 262144);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                n += n3;
                n2 -= n3;
                this.bde.zzco(n3);
                this.zzcyl();
                if ((long)n3 >= 262144L) continue;
                break;
            }
            if (n2 > 0) {
                n3 = this.bdf.read(byArray, n, n2);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                this.bde.zzco(n3);
            }
            return n4;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.zzcyl();
            this.bde.zzco(-this.bdg);
            this.bdf.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            this.zzcyl();
            int n = 0;
            while (l > 262144L) {
                l2 = this.bdf.skip(262144L);
                n = (int)((long)n + l2);
                if (l2 < 262144L) {
                    this.bde.zzco(l2);
                    return n;
                }
                this.bde.zzco(262144L);
                l -= 262144L;
                this.zzcyl();
            }
            l2 = this.bdf.skip(l);
            n = (int)((long)n + l2);
            this.bde.zzco(l2);
            return n;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

