/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.Batches;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.BatchJob;
import com.google.genai.types.BatchJobSource;
import com.google.genai.types.CancelBatchJobConfig;
import com.google.genai.types.CreateBatchJobConfig;
import com.google.genai.types.DeleteBatchJobConfig;
import com.google.genai.types.DeleteResourceJob;
import com.google.genai.types.GetBatchJobConfig;
import com.google.genai.types.ListBatchJobsConfig;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncBatches {
    Batches batches;

    public AsyncBatches(ApiClient apiClient) {
        this.batches = new Batches(apiClient);
    }

    public CompletableFuture<BatchJob> get(String name, GetBatchJobConfig config) {
        return CompletableFuture.supplyAsync(() -> this.batches.get(name, config));
    }

    public CompletableFuture<Void> cancel(String name, CancelBatchJobConfig config) {
        return CompletableFuture.runAsync(() -> this.batches.cancel(name, config));
    }

    public CompletableFuture<DeleteResourceJob> delete(String name, DeleteBatchJobConfig config) {
        return CompletableFuture.supplyAsync(() -> this.batches.delete(name, config));
    }

    public CompletableFuture<BatchJob> create(String model, BatchJobSource src, CreateBatchJobConfig config) {
        return CompletableFuture.supplyAsync(() -> this.batches.create(model, src, config));
    }

    public CompletableFuture<AsyncPager<BatchJob>> list(ListBatchJobsConfig config) {
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListBatchJobsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListBatchJobsConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.batches.privateList((ListBatchJobsConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.BATCH_JOBS, request, (ObjectNode)JsonSerializable.toJsonNode(config), (CompletableFuture)request.apply(config)));
    }
}

