/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerateContentResponse;
import com.google.genai.types.Candidate;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.GenerateContentResponsePromptFeedback;
import com.google.genai.types.GenerateContentResponseUsageMetadata;
import com.google.genai.types.HttpResponse;
import com.google.genai.types.Part;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerateContentResponse
extends JsonSerializable {
    private static final Logger logger = Logger.getLogger(GenerateContentResponse.class.getName());
    private static final ImmutableSet<FinishReason.Known> EXPECTED_FINISH_REASONS = ImmutableSet.of((Object)((Object)FinishReason.Known.FINISH_REASON_UNSPECIFIED), (Object)((Object)FinishReason.Known.STOP), (Object)((Object)FinishReason.Known.MAX_TOKENS));

    @JsonProperty(value="sdkHttpResponse")
    public abstract Optional<HttpResponse> sdkHttpResponse();

    @JsonProperty(value="candidates")
    public abstract Optional<List<Candidate>> candidates();

    @JsonProperty(value="createTime")
    public abstract Optional<Instant> createTime();

    @JsonProperty(value="responseId")
    public abstract Optional<String> responseId();

    @JsonProperty(value="automaticFunctionCallingHistory")
    public abstract Optional<List<Content>> automaticFunctionCallingHistory();

    @JsonProperty(value="modelVersion")
    public abstract Optional<String> modelVersion();

    @JsonProperty(value="promptFeedback")
    public abstract Optional<GenerateContentResponsePromptFeedback> promptFeedback();

    @JsonProperty(value="usageMetadata")
    public abstract Optional<GenerateContentResponseUsageMetadata> usageMetadata();

    public static Builder builder() {
        return new AutoValue_GenerateContentResponse.Builder();
    }

    public abstract Builder toBuilder();

    public static GenerateContentResponse fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerateContentResponse.class);
    }

    public @Nullable ImmutableList<Part> parts() {
        this.checkFinishReason();
        Optional<List<Candidate>> candidates = this.candidates();
        if (!candidates.isPresent() || candidates.get().isEmpty()) {
            return null;
        }
        Optional<Content> content = candidates.get().get(0).content();
        if (!content.isPresent()) {
            return null;
        }
        return ImmutableList.copyOf((Collection)content.get().parts().orElse(new ArrayList()));
    }

    public @Nullable String text() {
        return Content.aggregateTextFromParts(this.parts());
    }

    public @Nullable ImmutableList<FunctionCall> functionCalls() {
        ImmutableList<Part> parts = this.parts();
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        return ImmutableList.copyOf((Collection)parts.stream().filter(part -> part.functionCall().isPresent()).map(part -> part.functionCall().get()).collect(Collectors.toList()));
    }

    public @Nullable String executableCode() {
        ImmutableList<Part> parts = this.parts();
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        for (Part part : parts) {
            if (!part.executableCode().isPresent()) continue;
            return part.executableCode().get().code().orElse("");
        }
        return null;
    }

    public @Nullable String codeExecutionResult() {
        ImmutableList<Part> parts = this.parts();
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        for (Part part : parts) {
            if (!part.codeExecutionResult().isPresent()) continue;
            return part.codeExecutionResult().get().output().orElse("");
        }
        return null;
    }

    public FinishReason finishReason() {
        Optional<FinishReason> finishReason;
        List<Candidate> candidates = this.candidates().orElse(Arrays.asList(Candidate.builder().build()));
        if (candidates.size() > 1) {
            logger.warning(String.format("This response has %d candidates, will only use the first candidate", candidates.size()));
        }
        if (!(finishReason = candidates.get(0).finishReason()).isPresent()) {
            return new FinishReason(FinishReason.Known.FINISH_REASON_UNSPECIFIED);
        }
        return finishReason.get();
    }

    @InternalApi
    public void checkFinishReason() {
        FinishReason finishReason = this.finishReason();
        if (!EXPECTED_FINISH_REASONS.contains((Object)finishReason.knownEnum())) {
            throw new IllegalArgumentException(String.format("The response finished unexpectedly with reason %s.", finishReason));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerateContentResponse.Builder();
        }

        @JsonProperty(value="sdkHttpResponse")
        public abstract Builder sdkHttpResponse(HttpResponse var1);

        public Builder sdkHttpResponse(HttpResponse.Builder sdkHttpResponseBuilder) {
            return this.sdkHttpResponse(sdkHttpResponseBuilder.build());
        }

        @JsonProperty(value="candidates")
        public abstract Builder candidates(List<Candidate> var1);

        public Builder candidates(Candidate ... candidates) {
            return this.candidates(Arrays.asList(candidates));
        }

        public Builder candidates(Candidate.Builder ... candidatesBuilders) {
            return this.candidates((List)Arrays.asList(candidatesBuilders).stream().map(Candidate.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="createTime")
        public abstract Builder createTime(Instant var1);

        @JsonProperty(value="responseId")
        public abstract Builder responseId(String var1);

        @JsonProperty(value="automaticFunctionCallingHistory")
        public abstract Builder automaticFunctionCallingHistory(List<Content> var1);

        public Builder automaticFunctionCallingHistory(Content ... automaticFunctionCallingHistory) {
            return this.automaticFunctionCallingHistory(Arrays.asList(automaticFunctionCallingHistory));
        }

        public Builder automaticFunctionCallingHistory(Content.Builder ... automaticFunctionCallingHistoryBuilders) {
            return this.automaticFunctionCallingHistory((List)Arrays.asList(automaticFunctionCallingHistoryBuilders).stream().map(Content.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="modelVersion")
        public abstract Builder modelVersion(String var1);

        @JsonProperty(value="promptFeedback")
        public abstract Builder promptFeedback(GenerateContentResponsePromptFeedback var1);

        public Builder promptFeedback(GenerateContentResponsePromptFeedback.Builder promptFeedbackBuilder) {
            return this.promptFeedback(promptFeedbackBuilder.build());
        }

        @JsonProperty(value="usageMetadata")
        public abstract Builder usageMetadata(GenerateContentResponseUsageMetadata var1);

        public Builder usageMetadata(GenerateContentResponseUsageMetadata.Builder usageMetadataBuilder) {
            return this.usageMetadata(usageMetadataBuilder.build());
        }

        public abstract GenerateContentResponse build();
    }
}

