/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_VertexRagStore;
import com.google.genai.types.RagRetrievalConfig;
import com.google.genai.types.VertexRagStoreRagResource;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class VertexRagStore
extends JsonSerializable {
    @JsonProperty(value="ragCorpora")
    public abstract Optional<List<String>> ragCorpora();

    @JsonProperty(value="ragResources")
    public abstract Optional<List<VertexRagStoreRagResource>> ragResources();

    @JsonProperty(value="ragRetrievalConfig")
    public abstract Optional<RagRetrievalConfig> ragRetrievalConfig();

    @JsonProperty(value="similarityTopK")
    public abstract Optional<Integer> similarityTopK();

    @JsonProperty(value="storeContext")
    public abstract Optional<Boolean> storeContext();

    @JsonProperty(value="vectorDistanceThreshold")
    public abstract Optional<Double> vectorDistanceThreshold();

    public static Builder builder() {
        return new AutoValue_VertexRagStore.Builder();
    }

    public abstract Builder toBuilder();

    public static VertexRagStore fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, VertexRagStore.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_VertexRagStore.Builder();
        }

        @JsonProperty(value="ragCorpora")
        public abstract Builder ragCorpora(List<String> var1);

        public Builder ragCorpora(String ... ragCorpora) {
            return this.ragCorpora(Arrays.asList(ragCorpora));
        }

        @JsonProperty(value="ragResources")
        public abstract Builder ragResources(List<VertexRagStoreRagResource> var1);

        public Builder ragResources(VertexRagStoreRagResource ... ragResources) {
            return this.ragResources(Arrays.asList(ragResources));
        }

        public Builder ragResources(VertexRagStoreRagResource.Builder ... ragResourcesBuilders) {
            return this.ragResources((List)Arrays.asList(ragResourcesBuilders).stream().map(VertexRagStoreRagResource.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="ragRetrievalConfig")
        public abstract Builder ragRetrievalConfig(RagRetrievalConfig var1);

        public Builder ragRetrievalConfig(RagRetrievalConfig.Builder ragRetrievalConfigBuilder) {
            return this.ragRetrievalConfig(ragRetrievalConfigBuilder.build());
        }

        @JsonProperty(value="similarityTopK")
        public abstract Builder similarityTopK(Integer var1);

        @JsonProperty(value="storeContext")
        public abstract Builder storeContext(boolean var1);

        @JsonProperty(value="vectorDistanceThreshold")
        public abstract Builder vectorDistanceThreshold(Double var1);

        public abstract VertexRagStore build();
    }
}

