/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated code. Do not edit.

package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import java.util.Map;
import java.util.Optional;

/**
 * A datatype containing media content.
 *
 * <p>Exactly one field within a Part should be set, representing the specific type of content being
 * conveyed. Using multiple fields within the same `Part` instance is considered invalid.
 */
@AutoValue
@JsonDeserialize(builder = Part.Builder.class)
public abstract class Part extends JsonSerializable {
  /** Metadata for a given video. */
  @JsonProperty("videoMetadata")
  public abstract Optional<VideoMetadata> videoMetadata();

  /** Indicates if the part is thought from the model. */
  @JsonProperty("thought")
  public abstract Optional<Boolean> thought();

  /** Optional. Inlined bytes data. */
  @JsonProperty("inlineData")
  public abstract Optional<Blob> inlineData();

  /** Optional. URI based data. */
  @JsonProperty("fileData")
  public abstract Optional<FileData> fileData();

  /** An opaque signature for the thought so it can be reused in subsequent requests. */
  @JsonProperty("thoughtSignature")
  public abstract Optional<byte[]> thoughtSignature();

  /**
   * A predicted [FunctionCall] returned from the model that contains a string representing the
   * [FunctionDeclaration.name] and a structured JSON object containing the parameters and their
   * values.
   */
  @JsonProperty("functionCall")
  public abstract Optional<FunctionCall> functionCall();

  /** Optional. Result of executing the [ExecutableCode]. */
  @JsonProperty("codeExecutionResult")
  public abstract Optional<CodeExecutionResult> codeExecutionResult();

  /** Optional. Code generated by the model that is meant to be executed. */
  @JsonProperty("executableCode")
  public abstract Optional<ExecutableCode> executableCode();

  /**
   * Optional. The result output of a [FunctionCall] that contains a string representing the
   * [FunctionDeclaration.name] and a structured JSON object containing any output from the function
   * call. It is used as context to the model.
   */
  @JsonProperty("functionResponse")
  public abstract Optional<FunctionResponse> functionResponse();

  /** Optional. Text part (can be code). */
  @JsonProperty("text")
  public abstract Optional<String> text();

  /** Instantiates a builder for Part. */
  @ExcludeFromGeneratedCoverageReport
  public static Builder builder() {
    return new AutoValue_Part.Builder();
  }

  /** Creates a builder with the same values as this instance. */
  public abstract Builder toBuilder();

  /** Builder for Part. */
  @AutoValue.Builder
  public abstract static class Builder {
    /** For internal usage. Please use `Part.builder()` for instantiation. */
    @JsonCreator
    private static Builder create() {
      return new AutoValue_Part.Builder();
    }

    /**
     * Setter for videoMetadata.
     *
     * <p>videoMetadata: Metadata for a given video.
     */
    @JsonProperty("videoMetadata")
    public abstract Builder videoMetadata(VideoMetadata videoMetadata);

    /**
     * Setter for videoMetadata builder.
     *
     * <p>videoMetadata: Metadata for a given video.
     */
    public Builder videoMetadata(VideoMetadata.Builder videoMetadataBuilder) {
      return videoMetadata(videoMetadataBuilder.build());
    }

    /**
     * Setter for thought.
     *
     * <p>thought: Indicates if the part is thought from the model.
     */
    @JsonProperty("thought")
    public abstract Builder thought(boolean thought);

    /**
     * Setter for inlineData.
     *
     * <p>inlineData: Optional. Inlined bytes data.
     */
    @JsonProperty("inlineData")
    public abstract Builder inlineData(Blob inlineData);

    /**
     * Setter for inlineData builder.
     *
     * <p>inlineData: Optional. Inlined bytes data.
     */
    public Builder inlineData(Blob.Builder inlineDataBuilder) {
      return inlineData(inlineDataBuilder.build());
    }

    /**
     * Setter for fileData.
     *
     * <p>fileData: Optional. URI based data.
     */
    @JsonProperty("fileData")
    public abstract Builder fileData(FileData fileData);

    /**
     * Setter for fileData builder.
     *
     * <p>fileData: Optional. URI based data.
     */
    public Builder fileData(FileData.Builder fileDataBuilder) {
      return fileData(fileDataBuilder.build());
    }

    /**
     * Setter for thoughtSignature.
     *
     * <p>thoughtSignature: An opaque signature for the thought so it can be reused in subsequent
     * requests.
     */
    @JsonProperty("thoughtSignature")
    public abstract Builder thoughtSignature(byte[] thoughtSignature);

    /**
     * Setter for functionCall.
     *
     * <p>functionCall: A predicted [FunctionCall] returned from the model that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object containing the
     * parameters and their values.
     */
    @JsonProperty("functionCall")
    public abstract Builder functionCall(FunctionCall functionCall);

    /**
     * Setter for functionCall builder.
     *
     * <p>functionCall: A predicted [FunctionCall] returned from the model that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object containing the
     * parameters and their values.
     */
    public Builder functionCall(FunctionCall.Builder functionCallBuilder) {
      return functionCall(functionCallBuilder.build());
    }

    /**
     * Setter for codeExecutionResult.
     *
     * <p>codeExecutionResult: Optional. Result of executing the [ExecutableCode].
     */
    @JsonProperty("codeExecutionResult")
    public abstract Builder codeExecutionResult(CodeExecutionResult codeExecutionResult);

    /**
     * Setter for codeExecutionResult builder.
     *
     * <p>codeExecutionResult: Optional. Result of executing the [ExecutableCode].
     */
    public Builder codeExecutionResult(CodeExecutionResult.Builder codeExecutionResultBuilder) {
      return codeExecutionResult(codeExecutionResultBuilder.build());
    }

    /**
     * Setter for executableCode.
     *
     * <p>executableCode: Optional. Code generated by the model that is meant to be executed.
     */
    @JsonProperty("executableCode")
    public abstract Builder executableCode(ExecutableCode executableCode);

    /**
     * Setter for executableCode builder.
     *
     * <p>executableCode: Optional. Code generated by the model that is meant to be executed.
     */
    public Builder executableCode(ExecutableCode.Builder executableCodeBuilder) {
      return executableCode(executableCodeBuilder.build());
    }

    /**
     * Setter for functionResponse.
     *
     * <p>functionResponse: Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object containing any
     * output from the function call. It is used as context to the model.
     */
    @JsonProperty("functionResponse")
    public abstract Builder functionResponse(FunctionResponse functionResponse);

    /**
     * Setter for functionResponse builder.
     *
     * <p>functionResponse: Optional. The result output of a [FunctionCall] that contains a string
     * representing the [FunctionDeclaration.name] and a structured JSON object containing any
     * output from the function call. It is used as context to the model.
     */
    public Builder functionResponse(FunctionResponse.Builder functionResponseBuilder) {
      return functionResponse(functionResponseBuilder.build());
    }

    /**
     * Setter for text.
     *
     * <p>text: Optional. Text part (can be code).
     */
    @JsonProperty("text")
    public abstract Builder text(String text);

    public abstract Part build();
  }

  /** Deserializes a JSON string to a Part object. */
  @ExcludeFromGeneratedCoverageReport
  public static Part fromJson(String jsonString) {
    return JsonSerializable.fromJsonString(jsonString, Part.class);
  }

  /** Constructs a Text Part from a text string. */
  public static Part fromText(String text) {
    return builder().text(text).build();
  }

  /** Constructs a FileData Part from a file URI and MIME type. */
  public static Part fromUri(String fileUri, String mimeType) {
    return builder()
        .fileData(FileData.builder().fileUri(fileUri).mimeType(mimeType).build())
        .build();
  }

  /** Constructs a InlineData Part from a byte array and MIME type. */
  public static Part fromBytes(byte[] bytes, String mimeType) {
    return builder().inlineData(Blob.builder().data(bytes).mimeType(mimeType).build()).build();
  }

  /** Constructs a FunctionCall Part from a function name and args. */
  public static Part fromFunctionCall(String name, Map<String, Object> args) {
    return builder().functionCall(FunctionCall.builder().name(name).args(args).build()).build();
  }

  /** Constructs a FunctionResponse Part from a function name and response. */
  public static Part fromFunctionResponse(String name, Map<String, Object> response) {
    return builder()
        .functionResponse(FunctionResponse.builder().name(name).response(response).build())
        .build();
  }
}
