/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated code. Do not edit.

package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Ascii;
import java.util.Objects;

/** The reason why the turn is complete. */
public class TurnCompleteReason {

  /** Enum representing the known values for TurnCompleteReason. */
  public enum Known {
    /** Default value. Reason is unspecified. */
    TURN_COMPLETE_REASON_UNSPECIFIED,

    /** The function call generated by the model is invalid. */
    MALFORMED_FUNCTION_CALL,

    /** The response is rejected by the model. */
    RESPONSE_REJECTED,

    /** Needs more input from the user. */
    NEED_MORE_INPUT
  }

  private Known turnCompleteReasonEnum;
  private final String value;

  @JsonCreator
  public TurnCompleteReason(String value) {
    this.value = value;
    for (Known turnCompleteReasonEnum : Known.values()) {
      if (Ascii.equalsIgnoreCase(turnCompleteReasonEnum.toString(), value)) {
        this.turnCompleteReasonEnum = turnCompleteReasonEnum;
        break;
      }
    }
    if (this.turnCompleteReasonEnum == null) {
      this.turnCompleteReasonEnum = Known.TURN_COMPLETE_REASON_UNSPECIFIED;
    }
  }

  public TurnCompleteReason(Known knownValue) {
    this.turnCompleteReasonEnum = knownValue;
    this.value = knownValue.toString();
  }

  @ExcludeFromGeneratedCoverageReport
  @Override
  @JsonValue
  public String toString() {
    return this.value;
  }

  @ExcludeFromGeneratedCoverageReport
  @SuppressWarnings("PatternMatchingInstanceof")
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null) {
      return false;
    }

    if (!(o instanceof TurnCompleteReason)) {
      return false;
    }

    TurnCompleteReason other = (TurnCompleteReason) o;

    if (this.turnCompleteReasonEnum != Known.TURN_COMPLETE_REASON_UNSPECIFIED
        && other.turnCompleteReasonEnum != Known.TURN_COMPLETE_REASON_UNSPECIFIED) {
      return this.turnCompleteReasonEnum == other.turnCompleteReasonEnum;
    } else if (this.turnCompleteReasonEnum == Known.TURN_COMPLETE_REASON_UNSPECIFIED
        && other.turnCompleteReasonEnum == Known.TURN_COMPLETE_REASON_UNSPECIFIED) {
      return this.value.equals(other.value);
    }
    return false;
  }

  @ExcludeFromGeneratedCoverageReport
  @Override
  public int hashCode() {
    if (this.turnCompleteReasonEnum != Known.TURN_COMPLETE_REASON_UNSPECIFIED) {
      return this.turnCompleteReasonEnum.hashCode();
    } else {
      return Objects.hashCode(this.value);
    }
  }

  @ExcludeFromGeneratedCoverageReport
  public Known knownEnum() {
    return this.turnCompleteReasonEnum;
  }
}
