/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Image;
import com.google.genai.types.ScribbleImage;
import com.google.genai.types.SegmentImageSource;
import java.util.Optional;

final class AutoValue_SegmentImageSource
extends SegmentImageSource {
    private final Optional<String> prompt;
    private final Optional<Image> image;
    private final Optional<ScribbleImage> scribbleImage;

    private AutoValue_SegmentImageSource(Optional<String> prompt, Optional<Image> image, Optional<ScribbleImage> scribbleImage) {
        this.prompt = prompt;
        this.image = image;
        this.scribbleImage = scribbleImage;
    }

    @Override
    @JsonProperty(value="prompt")
    public Optional<String> prompt() {
        return this.prompt;
    }

    @Override
    @JsonProperty(value="image")
    public Optional<Image> image() {
        return this.image;
    }

    @Override
    @JsonProperty(value="scribbleImage")
    public Optional<ScribbleImage> scribbleImage() {
        return this.scribbleImage;
    }

    public String toString() {
        return "SegmentImageSource{prompt=" + this.prompt + ", image=" + this.image + ", scribbleImage=" + this.scribbleImage + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SegmentImageSource) {
            SegmentImageSource that = (SegmentImageSource)o;
            return this.prompt.equals(that.prompt()) && this.image.equals(that.image()) && this.scribbleImage.equals(that.scribbleImage());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.prompt.hashCode();
        h$ *= 1000003;
        h$ ^= this.image.hashCode();
        h$ *= 1000003;
        return h$ ^= this.scribbleImage.hashCode();
    }

    @Override
    public SegmentImageSource.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SegmentImageSource.Builder {
        private Optional<String> prompt = Optional.empty();
        private Optional<Image> image = Optional.empty();
        private Optional<ScribbleImage> scribbleImage = Optional.empty();

        Builder() {
        }

        Builder(SegmentImageSource source) {
            this.prompt = source.prompt();
            this.image = source.image();
            this.scribbleImage = source.scribbleImage();
        }

        @Override
        public SegmentImageSource.Builder prompt(String prompt) {
            this.prompt = Optional.of(prompt);
            return this;
        }

        @Override
        public SegmentImageSource.Builder image(Image image) {
            this.image = Optional.of(image);
            return this;
        }

        @Override
        public SegmentImageSource.Builder scribbleImage(ScribbleImage scribbleImage) {
            this.scribbleImage = Optional.of(scribbleImage);
            return this;
        }

        @Override
        public SegmentImageSource build() {
            return new AutoValue_SegmentImageSource(this.prompt, this.image, this.scribbleImage);
        }
    }
}

