/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_TuningDataset;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.TuningExample;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TuningDataset
extends JsonSerializable {
    @JsonProperty(value="gcsUri")
    public abstract Optional<String> gcsUri();

    @JsonProperty(value="vertexDatasetResource")
    public abstract Optional<String> vertexDatasetResource();

    @JsonProperty(value="examples")
    public abstract Optional<List<TuningExample>> examples();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_TuningDataset.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static TuningDataset fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, TuningDataset.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_TuningDataset.Builder();
        }

        @JsonProperty(value="gcsUri")
        public abstract Builder gcsUri(String var1);

        @JsonProperty(value="vertexDatasetResource")
        public abstract Builder vertexDatasetResource(String var1);

        @JsonProperty(value="examples")
        public abstract Builder examples(List<TuningExample> var1);

        public Builder examples(TuningExample ... examples) {
            return this.examples(Arrays.asList(examples));
        }

        public Builder examples(TuningExample.Builder ... examplesBuilders) {
            return this.examples((List)Arrays.asList(examplesBuilders).stream().map(TuningExample.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        public abstract TuningDataset build();
    }
}

