/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.WindowResizeListener;
import com.google.gwt.user.client.impl.WindowImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Window {
    private static boolean handlersAreInitialized;
    private static final WindowImpl impl;
    private static ArrayList<WindowCloseListener> closingListeners;
    private static ArrayList<WindowResizeListener> resizeListeners;

    public static void addWindowCloseListener(WindowCloseListener listener) {
        Window.maybeInitializeHandlers();
        if (closingListeners == null) {
            closingListeners = new ArrayList();
        }
        closingListeners.add(listener);
    }

    public static void addWindowResizeListener(WindowResizeListener listener) {
        Window.maybeInitializeHandlers();
        if (resizeListeners == null) {
            resizeListeners = new ArrayList();
        }
        resizeListeners.add(listener);
    }

    public static native void alert(String var0);

    public static native boolean confirm(String var0);

    public static void enableScrolling(boolean enable) {
        impl.enableScrolling(enable);
    }

    public static int getClientHeight() {
        return impl.getClientHeight();
    }

    public static int getClientWidth() {
        return impl.getClientWidth();
    }

    public static int getScrollLeft() {
        return impl.getScrollLeft();
    }

    public static int getScrollTop() {
        return impl.getScrollTop();
    }

    public static native String getTitle();

    public static native void open(String var0, String var1, String var2);

    public static native void print();

    public static native String prompt(String var0, String var1);

    public static void removeWindowCloseListener(WindowCloseListener listener) {
        if (closingListeners != null) {
            closingListeners.remove(listener);
        }
    }

    public static void removeWindowResizeListener(WindowResizeListener listener) {
        if (resizeListeners != null) {
            resizeListeners.remove(listener);
        }
    }

    public static native void setMargin(String var0);

    public static native void setStatus(String var0);

    public static native void setTitle(String var0);

    static void onClosed() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            Window.fireClosedAndCatch(handler);
        } else {
            Window.fireClosedImpl();
        }
    }

    static String onClosing() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            return Window.fireClosingAndCatch(handler);
        }
        return Window.fireClosingImpl();
    }

    static void onResize() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            Window.fireResizedAndCatch(handler);
        } else {
            Window.fireResizedImpl();
        }
    }

    private static void fireClosedAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            Window.fireClosedImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireClosedImpl() {
        if (closingListeners != null) {
            for (WindowCloseListener listener : closingListeners) {
                listener.onWindowClosed();
            }
        }
    }

    private static String fireClosingAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            return Window.fireClosingImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
            return null;
        }
    }

    private static String fireClosingImpl() {
        String ret = null;
        if (closingListeners != null) {
            for (WindowCloseListener listener : closingListeners) {
                String msg = listener.onWindowClosing();
                if (ret != null) continue;
                ret = msg;
            }
        }
        return ret;
    }

    private static void fireResizedAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            Window.fireResizedImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireResizedImpl() {
        if (resizeListeners != null) {
            for (WindowResizeListener listener : resizeListeners) {
                listener.onWindowResized(Window.getClientWidth(), Window.getClientHeight());
            }
        }
    }

    private static native void init();

    private static void maybeInitializeHandlers() {
        if (!handlersAreInitialized) {
            Window.init();
            handlersAreInitialized = true;
        }
    }

    private Window() {
    }

    static {
        impl = (WindowImpl)GWT.create(WindowImpl.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Location {
        private static Map<String, String> paramMap;

        public static native void assign(String var0);

        public static native String getHash();

        public static native String getHost();

        public static native String getHostName();

        public static native String getHref();

        public static String getParameter(String name) {
            return Location.ensureParameterMap().get(name);
        }

        public static native String getPath();

        public static native String getPort();

        public static native String getProtocol();

        public static native String getQueryString();

        public static native void reload();

        public static native void replace(String var0);

        private static Map<String, String> ensureParameterMap() {
            if (paramMap == null) {
                paramMap = new HashMap<String, String>();
                String queryString = Location.getQueryString();
                if (queryString != null && queryString.length() > 1) {
                    String qs = queryString.substring(1);
                    for (String kvPair : qs.split("&")) {
                        String[] kv = kvPair.split("=");
                        if (kv.length > 1) {
                            paramMap.put(kv[0], URL.decode(kv[1]));
                            continue;
                        }
                        paramMap.put(kv[0], "");
                    }
                }
            }
            return paramMap;
        }

        private Location() {
        }
    }
}

