/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.SourcesTabEvents;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.TabListener;
import com.google.gwt.user.client.ui.TabListenerCollection;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import java.util.Iterator;

public class TabPanel
extends Composite
implements TabListener,
SourcesTabEvents,
HasWidgets,
IndexedPanel {
    private WidgetCollection children = new WidgetCollection(this);
    private DeckPanel deck = new DeckPanel();
    private TabBar tabBar = new TabBar();
    private TabListenerCollection tabListeners;

    public TabPanel() {
        VerticalPanel panel = new VerticalPanel();
        panel.add(this.tabBar);
        panel.add(this.deck);
        panel.setCellHeight(this.deck, "100%");
        this.tabBar.setWidth("100%");
        this.tabBar.addTabListener(this);
        this.initWidget(panel);
        this.setStyleName("gwt-TabPanel");
        this.deck.setStyleName("gwt-TabPanelBottom");
    }

    public void add(Widget w) {
        throw new UnsupportedOperationException("A tabText parameter must be specified with add().");
    }

    public void add(Widget w, String tabText) {
        this.insert(w, tabText, this.getWidgetCount());
    }

    public void add(Widget w, String tabText, boolean asHTML) {
        this.insert(w, tabText, asHTML, this.getWidgetCount());
    }

    public void addTabListener(TabListener listener) {
        if (this.tabListeners == null) {
            this.tabListeners = new TabListenerCollection();
        }
        this.tabListeners.add(listener);
    }

    public void clear() {
        while (this.getWidgetCount() > 0) {
            this.remove(this.getWidget(0));
        }
    }

    public DeckPanel getDeckPanel() {
        return this.deck;
    }

    public TabBar getTabBar() {
        return this.tabBar;
    }

    public Widget getWidget(int index) {
        return this.children.get(index);
    }

    public int getWidgetCount() {
        return this.children.size();
    }

    public int getWidgetIndex(Widget widget) {
        return this.children.indexOf(widget);
    }

    public void insert(Widget widget, String tabText, boolean asHTML, int beforeIndex) {
        this.children.insert(widget, beforeIndex);
        this.tabBar.insertTab(tabText, asHTML, beforeIndex);
        this.deck.insert(widget, beforeIndex);
    }

    public void insert(Widget widget, String tabText, int beforeIndex) {
        this.insert(widget, tabText, false, beforeIndex);
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public boolean onBeforeTabSelected(SourcesTabEvents sender, int tabIndex) {
        if (this.tabListeners != null) {
            return this.tabListeners.fireBeforeTabSelected(this, tabIndex);
        }
        return true;
    }

    public void onTabSelected(SourcesTabEvents sender, int tabIndex) {
        this.deck.showWidget(tabIndex);
        if (this.tabListeners != null) {
            this.tabListeners.fireTabSelected(this, tabIndex);
        }
    }

    public boolean remove(int index) {
        return this.remove(this.getWidget(index));
    }

    public boolean remove(Widget widget) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return false;
        }
        this.children.remove(widget);
        this.tabBar.removeTab(index);
        this.deck.remove(widget);
        return true;
    }

    public void removeTabListener(TabListener listener) {
        if (this.tabListeners != null) {
            this.tabListeners.remove(listener);
        }
    }

    public void selectTab(int index) {
        this.tabBar.selectTab(index);
    }
}

