/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ChangeListenerCollection;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ClickListenerCollection;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.SourcesChangeEvents;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesKeyboardEvents;
import com.google.gwt.user.client.ui.impl.TextBoxImpl;

public class TextBoxBase
extends FocusWidget
implements SourcesKeyboardEvents,
SourcesChangeEvents,
SourcesClickEvents,
HasText,
HasName {
    public static final TextAlignConstant ALIGN_CENTER = new TextAlignConstant("center");
    public static final TextAlignConstant ALIGN_JUSTIFY = new TextAlignConstant("justify");
    public static final TextAlignConstant ALIGN_LEFT = new TextAlignConstant("left");
    public static final TextAlignConstant ALIGN_RIGHT = new TextAlignConstant("right");
    private static TextBoxImpl impl = (TextBoxImpl)GWT.create(TextBoxImpl.class);
    private ChangeListenerCollection changeListeners;
    private ClickListenerCollection clickListeners;
    private Event currentEvent;
    private KeyboardListenerCollection keyboardListeners;

    protected TextBoxBase(Element elem) {
        super(elem);
        this.sinkEvents(1024);
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ChangeListenerCollection();
        }
        this.changeListeners.add(listener);
    }

    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ClickListenerCollection();
        }
        this.clickListeners.add(listener);
    }

    public void addKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners == null) {
            this.keyboardListeners = new KeyboardListenerCollection();
        }
        this.keyboardListeners.add(listener);
    }

    public void cancelKey() {
        if (this.currentEvent != null) {
            DOM.eventPreventDefault(this.currentEvent);
        }
    }

    public int getCursorPos() {
        return impl.getCursorPos(this.getElement());
    }

    public String getName() {
        return DOM.getAttribute(this.getElement(), "name");
    }

    public String getSelectedText() {
        int start = this.getCursorPos();
        int length = this.getSelectionLength();
        return this.getText().substring(start, start + length);
    }

    public int getSelectionLength() {
        return impl.getSelectionLength(this.getElement());
    }

    public String getText() {
        return DOM.getAttribute(this.getElement(), "value");
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        int type = DOM.eventGetType(event);
        if (this.keyboardListeners != null && (type & 0x380) != 0) {
            this.currentEvent = event;
            this.keyboardListeners.fireKeyboardEvent(this, event);
            this.currentEvent = null;
        } else if (type == 1) {
            if (this.clickListeners != null) {
                this.clickListeners.fireClick(this);
            }
        } else if (type == 1024 && this.changeListeners != null) {
            this.changeListeners.fireChange(this);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public void removeKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners != null) {
            this.keyboardListeners.remove(listener);
        }
    }

    public void selectAll() {
        int length = this.getText().length();
        if (length > 0) {
            this.setSelectionRange(0, length);
        }
    }

    public void setCursorPos(int pos) {
        this.setSelectionRange(pos, 0);
    }

    public void setKey(char key) {
        if (this.currentEvent != null) {
            DOM.eventSetKeyCode(this.currentEvent, key);
        }
    }

    public void setName(String name) {
        DOM.setAttribute(this.getElement(), "name", name);
    }

    public void setSelectionRange(int pos, int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length must be a positive integer. Length: " + length);
        }
        if (pos < 0 || length + pos > this.getText().length()) {
            throw new IndexOutOfBoundsException("From Index: " + pos + "  To Index: " + (pos + length) + "  Text Length: " + this.getText().length());
        }
        impl.setSelectionRange(this.getElement(), pos, length);
    }

    public void setText(String text) {
        DOM.setAttribute(this.getElement(), "value", text);
    }

    public void setTextAlignment(TextAlignConstant align) {
        DOM.setStyleAttribute(this.getElement(), "textAlign", align.getTextAlignString());
    }

    protected TextBoxImpl getImpl() {
        return impl;
    }

    public static class TextAlignConstant {
        private String textAlignString;

        private TextAlignConstant(String textAlignString) {
            this.textAlignString = textAlignString;
        }

        private String getTextAlignString() {
            return this.textAlignString;
        }
    }
}

