/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.resources.css.CssGenerationVisitor;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerExtra;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ToolBase;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;

public class Minify
extends ToolBase {
    private final PrintWriterTreeLogger logger = new PrintWriterTreeLogger(new PrintWriter(System.err));
    private URL source;
    private boolean pretty;

    public static void main(String[] args) {
        Minify m = new Minify();
        if (m.exec(args)) {
            System.exit(0);
        } else {
            System.exit(-1);
        }
    }

    private Minify() {
        this.logger.setMaxDetail(TreeLogger.DEBUG);
    }

    protected String getDescription() {
        return "Minify a CSS file";
    }

    private boolean exec(String[] args) {
        this.registerHandler((ArgHandler)new ArgHandlerExtra(){

            public boolean addExtraArg(String arg) {
                if (Minify.this.source != null) {
                    return false;
                }
                try {
                    Minify.this.source = new File(arg).toURL();
                    return true;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public String getPurpose() {
                return "The css file to process";
            }

            public String[] getTagArgs() {
                return new String[]{"stylesheet.css"};
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerFlag(){

            public String getPurpose() {
                return "Enable human-parsable output";
            }

            public String getTag() {
                return "-pretty";
            }

            public boolean setFlag() {
                return Minify.this.pretty = true;
            }
        });
        if (!this.processArgs(args)) {
            return false;
        }
        if (this.source == null) {
            this.printHelp();
            return false;
        }
        try {
            CssStylesheet sheet = GenerateCssAst.exec((TreeLogger)this.logger, new URL[]{this.source});
            DefaultTextOutput out = new DefaultTextOutput(!this.pretty);
            new CssGenerationVisitor((TextOutput)out).accept(sheet);
            System.out.println(out.toString());
        }
        catch (UnableToCompleteException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to compile CSS");
        }
        return true;
    }
}

