/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.parsers.CellPanelParser;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.HashMap;

public class DockPanelParser
implements ElementParser {
    private static final String TAG_DOCK = "Dock";
    private static final HashMap<String, String> values = new HashMap();

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        for (XMLElement child : elem.consumeChildElements()) {
            XMLElement widget;
            String value;
            String translated;
            String ns = child.getNamespaceUri();
            String tagName = child.getLocalName();
            if (!ns.equals(elem.getNamespaceUri())) {
                writer.die("Invalid DockPanel child namespace: " + ns);
            }
            if (!tagName.equals(TAG_DOCK)) {
                writer.die("Invalid DockPanel child element: " + tagName);
            }
            if (!child.hasAttribute("direction")) {
                writer.die("Dock must specify the 'direction' attribute");
            }
            if ((translated = values.get(value = child.consumeAttribute("direction"))) == null) {
                writer.die("Invalid value: dockDirection='" + value + "'");
            }
            if ((widget = child.consumeSingleChildElement()) == null) {
                writer.die("Dock must contain a single child widget.");
            }
            String childFieldName = writer.parseElementToField(widget);
            writer.addStatement("%1$s.add(%2$s, %3$s);", new Object[]{fieldName, childFieldName, translated});
            if (child.hasAttribute("width")) {
                writer.addStatement("%1$s.setCellWidth(%2$s, \"%3$s\");", new Object[]{fieldName, childFieldName, child.consumeAttribute("width")});
            }
            if (child.hasAttribute("height")) {
                writer.addStatement("%1$s.setCellHeight(%2$s, \"%3$s\");", new Object[]{fieldName, childFieldName, child.consumeAttribute("height")});
            }
            CellPanelParser.parseCellAttributes(child, fieldName, childFieldName, writer);
        }
    }

    static {
        values.put("NORTH", "com.google.gwt.user.client.ui.DockPanel.NORTH");
        values.put("SOUTH", "com.google.gwt.user.client.ui.DockPanel.SOUTH");
        values.put("EAST", "com.google.gwt.user.client.ui.DockPanel.EAST");
        values.put("WEST", "com.google.gwt.user.client.ui.DockPanel.WEST");
        values.put("CENTER", "com.google.gwt.user.client.ui.DockPanel.CENTER");
    }
}

