/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.parsers.HtmlInterpreter;
import com.google.gwt.uibinder.parsers.InterpreterPipe;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.MenuItem;

public class MenuItemParser
implements ElementParser {
    private static final String TAG_MENUBAR = "MenuBar";
    private static final String TAG_MENUITEMHTML = "MenuItemHTML";

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        writer.setFieldInitializerAsConstructor(fieldName, writer.getOracle().findType(MenuItem.class.getName()), new String[]{"\"\"", "(com.google.gwt.user.client.Command) null"});
        InterpreterPipe<String> interpreter = new InterpreterPipe<String>();
        HtmlInterpreter htmlInterpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
        MenuItemGutsInterpreter guts = new MenuItemGutsInterpreter(writer, elem.getNamespaceUri(), elem.toString(), htmlInterpreter);
        interpreter.add(guts);
        interpreter.add(htmlInterpreter);
        String html = elem.consumeInnerHtml(interpreter);
        if (html.trim().length() > 0) {
            writer.genStringPropertySet(fieldName, "HTML", html);
        }
        if (guts.getMenuBarField() != null) {
            writer.genPropertySet(fieldName, "subMenu", guts.getMenuBarField());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MenuItemGutsInterpreter
    implements XMLElement.Interpreter<String> {
        private final String namespaceUri;
        private final HtmlInterpreter htmlInterpreter;
        private final UiBinderWriter writer;
        private final String errorContext;
        private String menuBarField;

        public MenuItemGutsInterpreter(UiBinderWriter writer, String namespaceUri, String errorContext, HtmlInterpreter htmlInterpreter) {
            this.writer = writer;
            this.errorContext = errorContext;
            this.namespaceUri = namespaceUri;
            this.htmlInterpreter = htmlInterpreter;
        }

        public String interpretElement(XMLElement elem) throws UnableToCompleteException {
            if (this.isMenuHtml(elem)) {
                this.writer.warn("In %s, the MenuItemHTML element is no longer required, and its contents have been inlined. This will become an error.", new Object[]{this.errorContext});
                return elem.consumeInnerHtml((XMLElement.Interpreter)this.htmlInterpreter);
            }
            if (this.isMenuBar(elem)) {
                if (this.menuBarField != null) {
                    this.writer.die("In %s, only one MenuBar may be contained in a MenuItem", new Object[]{this.errorContext});
                }
                this.menuBarField = this.writer.parseElementToField(elem);
                return "";
            }
            return null;
        }

        String getMenuBarField() {
            return this.menuBarField;
        }

        private boolean isMenuBar(XMLElement child) {
            return this.namespaceUri.equals(child.getNamespaceUri()) && child.getLocalName().equals(MenuItemParser.TAG_MENUBAR);
        }

        private boolean isMenuHtml(XMLElement child) {
            return this.namespaceUri.equals(child.getNamespaceUri()) && child.getLocalName().equals(MenuItemParser.TAG_MENUITEMHTML);
        }
    }
}

