/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresLayout;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;

public class LayoutPanel
extends ComplexPanel
implements RequiresLayout,
RequiresResize,
ProvidesResize {
    private final Layout layout;

    public LayoutPanel() {
        this.setElement(Document.get().createDivElement());
        this.layout = new Layout(this.getElement());
    }

    public void add(Widget widget) {
        widget.removeFromParent();
        this.getChildren().add(widget);
        Layout.Layer layer = this.layout.attachChild((Element)widget.getElement(), widget);
        widget.setLayoutData(layer);
        this.adopt(widget);
    }

    public Layout.Layer getLayer(Widget child) {
        assert (child.getParent() == this) : "The requested widget is not a child of this panel";
        return (Layout.Layer)child.getLayoutData();
    }

    public void layout() {
        this.layout.layout();
    }

    public void layout(int duration) {
        this.layout.layout(duration);
    }

    public void layout(int duration, final Layout.AnimationCallback callback) {
        this.layout.layout(duration, new Layout.AnimationCallback(){

            public void onAnimationComplete() {
                if (callback != null) {
                    callback.onAnimationComplete();
                }
            }

            public void onLayout(Layout.Layer layer, double progress) {
                Widget child = (Widget)layer.getUserObject();
                if (child instanceof RequiresResize) {
                    ((RequiresResize)((Object)child)).onResize();
                }
                if (callback != null) {
                    callback.onLayout(layer, progress);
                }
            }
        });
    }

    public void onResize() {
        for (Widget child : this.getChildren()) {
            if (!(child instanceof RequiresResize)) continue;
            ((RequiresResize)((Object)child)).onResize();
        }
    }

    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            this.layout.removeChild((Layout.Layer)w.getLayoutData());
        }
        return removed;
    }

    protected Layout getLayout() {
        return this.layout;
    }

    protected void onLoad() {
        this.layout.onAttach();
    }

    protected void onUnload() {
        this.layout.onDetach();
    }
}

