/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.event.dom.client.HasScrollHandlers;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.ScrollListener;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesScrollEvents;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class ScrollPanel
extends SimplePanel
implements SourcesScrollEvents,
HasScrollHandlers {
    public ScrollPanel() {
        this.setAlwaysShowScrollBars(false);
        DOM.setStyleAttribute(this.getElement(), "position", "relative");
    }

    public ScrollPanel(Widget child) {
        this();
        this.setWidget(child);
    }

    public HandlerRegistration addScrollHandler(ScrollHandler handler) {
        return this.addDomHandler(handler, ScrollEvent.getType());
    }

    @Deprecated
    public void addScrollListener(ScrollListener listener) {
        ListenerWrapper.WrappedScrollListener.add(this, listener);
    }

    public void ensureVisible(UIObject item) {
        Element scroll = this.getElement();
        Element element = item.getElement();
        this.ensureVisibleImpl(scroll, element);
    }

    public int getHorizontalScrollPosition() {
        return DOM.getElementPropertyInt(this.getElement(), "scrollLeft");
    }

    public int getScrollPosition() {
        return DOM.getElementPropertyInt(this.getElement(), "scrollTop");
    }

    @Deprecated
    public void removeScrollListener(ScrollListener listener) {
        ListenerWrapper.WrappedScrollListener.remove(this, listener);
    }

    public void scrollToBottom() {
        this.setScrollPosition(DOM.getElementPropertyInt(this.getElement(), "scrollHeight"));
    }

    public void scrollToLeft() {
        this.setHorizontalScrollPosition(0);
    }

    public void scrollToRight() {
        this.setHorizontalScrollPosition(DOM.getElementPropertyInt(this.getElement(), "scrollWidth"));
    }

    public void scrollToTop() {
        this.setScrollPosition(0);
    }

    public void setAlwaysShowScrollBars(boolean alwaysShow) {
        DOM.setStyleAttribute(this.getElement(), "overflow", alwaysShow ? "scroll" : "auto");
    }

    public void setHeight(String height) {
        super.setHeight(height);
    }

    public void setHorizontalScrollPosition(int position) {
        DOM.setElementPropertyInt(this.getElement(), "scrollLeft", position);
    }

    public void setScrollPosition(int position) {
        DOM.setElementPropertyInt(this.getElement(), "scrollTop", position);
    }

    public void setSize(String width, String height) {
        super.setSize(width, height);
    }

    public void setWidth(String width) {
        super.setWidth(width);
    }

    private native void ensureVisibleImpl(Element var1, Element var2);
}

