/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.i18n.client.DateTimeFormatInfo;
import com.google.gwt.i18n.client.DateTimeFormatInfoAdapter;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.client.TimeZone;
import com.google.gwt.i18n.client.constants.DateTimeConstants;
import com.google.gwt.i18n.client.impl.DateRecord;
import com.google.gwt.i18n.client.impl.cldr.DateTimeFormatInfoImpl_en;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateTimeFormat {
    private static final int NUMBER_BASE = 10;
    private static final int JS_START_YEAR = 1900;
    private static final Map<String, DateTimeFormat> cache = new HashMap<String, DateTimeFormat>();
    private static final int NUM_MILLISECONDS_IN_DAY = 86400000;
    private static final String PATTERN_CHARS = "GyMLdkHmsSEcDahKzZv";
    private static final String NUMERIC_FORMAT_CHARS = "MLydhHmsSDkK";
    private static final String WHITE_SPACE = " \t\r\n";
    private static final String GMT = "GMT";
    private static final String UTC = "UTC";
    private static final int MINUTES_PER_HOUR = 60;
    private static final String RFC2822_PATTERN = "EEE, d MMM yyyy HH:mm:ss Z";
    private static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZ";
    private final ArrayList<PatternPart> patternParts = new ArrayList();
    private final DateTimeFormatInfo dateTimeFormatInfo;
    private final String pattern;

    public static DateTimeFormat getFormat(PredefinedFormat predef) {
        String pattern;
        if (DateTimeFormat.usesFixedEnglishStrings(predef)) {
            String pattern2;
            switch (predef) {
                case RFC_2822: {
                    pattern2 = RFC2822_PATTERN;
                    break;
                }
                case ISO_8601: {
                    pattern2 = ISO8601_PATTERN;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected predef type " + (Object)((Object)predef));
                }
            }
            return DateTimeFormat.getFormat(pattern2, new DateTimeFormatInfoImpl_en());
        }
        DateTimeFormatInfo dtfi = DateTimeFormat.getDefaultDateTimeFormatInfo();
        switch (predef) {
            case DATE_FULL: {
                pattern = dtfi.dateFormatFull();
                break;
            }
            case DATE_LONG: {
                pattern = dtfi.dateFormatLong();
                break;
            }
            case DATE_MEDIUM: {
                pattern = dtfi.dateFormatMedium();
                break;
            }
            case DATE_SHORT: {
                pattern = dtfi.dateFormatShort();
                break;
            }
            case DATE_TIME_FULL: {
                pattern = dtfi.dateTimeFull(dtfi.timeFormatFull(), dtfi.dateFormatFull());
                break;
            }
            case DATE_TIME_LONG: {
                pattern = dtfi.dateTimeLong(dtfi.timeFormatLong(), dtfi.dateFormatLong());
                break;
            }
            case DATE_TIME_MEDIUM: {
                pattern = dtfi.dateTimeMedium(dtfi.timeFormatMedium(), dtfi.dateFormatMedium());
                break;
            }
            case DATE_TIME_SHORT: {
                pattern = dtfi.dateTimeShort(dtfi.timeFormatShort(), dtfi.dateFormatShort());
                break;
            }
            case DAY: {
                pattern = dtfi.formatDay();
                break;
            }
            case HOUR24_MINUTE: {
                pattern = dtfi.formatHour24Minute();
                break;
            }
            case HOUR24_MINUTE_SECOND: {
                pattern = dtfi.formatHour24MinuteSecond();
                break;
            }
            case HOUR_MINUTE: {
                pattern = dtfi.formatHour12Minute();
                break;
            }
            case HOUR_MINUTE_SECOND: {
                pattern = dtfi.formatHour12MinuteSecond();
                break;
            }
            case MINUTE_SECOND: {
                pattern = dtfi.formatMinuteSecond();
                break;
            }
            case MONTH: {
                pattern = dtfi.formatMonthFull();
                break;
            }
            case MONTH_ABBR: {
                pattern = dtfi.formatMonthAbbrev();
                break;
            }
            case MONTH_ABBR_DAY: {
                pattern = dtfi.formatMonthAbbrevDay();
                break;
            }
            case MONTH_DAY: {
                pattern = dtfi.formatMonthFullDay();
                break;
            }
            case MONTH_NUM_DAY: {
                pattern = dtfi.formatMonthNumDay();
                break;
            }
            case MONTH_WEEKDAY_DAY: {
                pattern = dtfi.formatMonthFullWeekdayDay();
                break;
            }
            case TIME_FULL: {
                pattern = dtfi.timeFormatFull();
                break;
            }
            case TIME_LONG: {
                pattern = dtfi.timeFormatLong();
                break;
            }
            case TIME_MEDIUM: {
                pattern = dtfi.timeFormatMedium();
                break;
            }
            case TIME_SHORT: {
                pattern = dtfi.timeFormatShort();
                break;
            }
            case YEAR: {
                pattern = dtfi.formatYear();
                break;
            }
            case YEAR_MONTH: {
                pattern = dtfi.formatYearMonthFull();
                break;
            }
            case YEAR_MONTH_ABBR: {
                pattern = dtfi.formatYearMonthAbbrev();
                break;
            }
            case YEAR_MONTH_ABBR_DAY: {
                pattern = dtfi.formatYearMonthAbbrevDay();
                break;
            }
            case YEAR_MONTH_DAY: {
                pattern = dtfi.formatYearMonthFullDay();
                break;
            }
            case YEAR_MONTH_NUM: {
                pattern = dtfi.formatYearMonthNum();
                break;
            }
            case YEAR_MONTH_NUM_DAY: {
                pattern = dtfi.formatYearMonthNumDay();
                break;
            }
            case YEAR_MONTH_WEEKDAY_DAY: {
                pattern = dtfi.formatYearMonthWeekdayDay();
                break;
            }
            case YEAR_QUARTER: {
                pattern = dtfi.formatYearQuarterFull();
                break;
            }
            case YEAR_QUARTER_ABBR: {
                pattern = dtfi.formatYearQuarterShort();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected predefined format " + (Object)((Object)predef));
            }
        }
        return DateTimeFormat.getFormat(pattern, dtfi);
    }

    public static DateTimeFormat getFormat(String pattern) {
        return DateTimeFormat.getFormat(pattern, DateTimeFormat.getDefaultDateTimeFormatInfo());
    }

    @Deprecated
    public static DateTimeFormat getFullDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_FULL);
    }

    @Deprecated
    public static DateTimeFormat getFullDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_FULL);
    }

    @Deprecated
    public static DateTimeFormat getFullTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_FULL);
    }

    @Deprecated
    public static DateTimeFormat getLongDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_LONG);
    }

    @Deprecated
    public static DateTimeFormat getLongDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_LONG);
    }

    @Deprecated
    public static DateTimeFormat getLongTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_LONG);
    }

    @Deprecated
    public static DateTimeFormat getMediumDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getMediumDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getMediumTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getShortDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_SHORT);
    }

    @Deprecated
    public static DateTimeFormat getShortDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_SHORT);
    }

    @Deprecated
    public static DateTimeFormat getShortTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_SHORT);
    }

    protected static DateTimeFormat getFormat(String pattern, DateTimeFormatInfo dtfi) {
        DateTimeFormatInfo defaultDtfi = DateTimeFormat.getDefaultDateTimeFormatInfo();
        DateTimeFormat dtf = null;
        if (dtfi == defaultDtfi) {
            dtf = cache.get(pattern);
        }
        if (dtf == null) {
            dtf = new DateTimeFormat(pattern, dtfi);
            if (dtfi == defaultDtfi) {
                cache.put(pattern, dtf);
            }
        }
        return dtf;
    }

    private static DateTimeFormatInfo getDefaultDateTimeFormatInfo() {
        return LocaleInfo.getCurrentLocale().getDateTimeFormatInfo();
    }

    private static boolean usesFixedEnglishStrings(PredefinedFormat predef) {
        switch (predef) {
            case RFC_2822: {
                return true;
            }
            case ISO_8601: {
                return true;
            }
        }
        return false;
    }

    protected DateTimeFormat(String pattern) {
        this(pattern, DateTimeFormat.getDefaultDateTimeFormatInfo());
    }

    @Deprecated
    protected DateTimeFormat(String pattern, DateTimeConstants dateTimeConstants) {
        this(pattern, new DateTimeFormatInfoAdapter(dateTimeConstants));
    }

    protected DateTimeFormat(String pattern, DateTimeFormatInfo dtfi) {
        this.pattern = pattern;
        this.dateTimeFormatInfo = dtfi;
        this.parsePattern(pattern);
    }

    public String format(Date date) {
        TimeZone timeZone = TimeZone.createTimeZone(date.getTimezoneOffset());
        return this.format(date, timeZone);
    }

    public String format(Date date, TimeZone timeZone) {
        Date keepDate;
        int diff = (date.getTimezoneOffset() - timeZone.getOffset(date)) * 60000;
        Date keepTime = keepDate = new Date(date.getTime() + (long)diff);
        if (keepDate.getTimezoneOffset() != date.getTimezoneOffset()) {
            diff = diff > 0 ? (diff -= 86400000) : (diff += 86400000);
            keepTime = new Date(date.getTime() + (long)diff);
        }
        StringBuffer toAppendTo = new StringBuffer(64);
        int n = this.pattern.length();
        int i = 0;
        while (i < n) {
            int j;
            char ch = this.pattern.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                for (j = i + 1; j < n && this.pattern.charAt(j) == ch; ++j) {
                }
                this.subFormat(toAppendTo, ch, j - i, date, keepDate, keepTime, timeZone);
                i = j;
                continue;
            }
            if (ch == '\'') {
                if (++i < n && this.pattern.charAt(i) == '\'') {
                    toAppendTo.append('\'');
                    ++i;
                    continue;
                }
                boolean trailQuote = false;
                while (!trailQuote) {
                    for (j = i; j < n && this.pattern.charAt(j) != '\''; ++j) {
                    }
                    if (j >= n) {
                        throw new IllegalArgumentException("Missing trailing '");
                    }
                    if (j + 1 < n && this.pattern.charAt(j + 1) == '\'') {
                        ++j;
                    } else {
                        trailQuote = true;
                    }
                    toAppendTo.append(this.pattern.substring(i, j));
                    i = j + 1;
                }
                continue;
            }
            toAppendTo.append(ch);
            ++i;
        }
        return toAppendTo.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    public Date parse(String text) throws IllegalArgumentException {
        return this.parse(text, false);
    }

    public int parse(String text, int start, Date date) {
        return this.parse(text, start, date, false);
    }

    public Date parseStrict(String text) throws IllegalArgumentException {
        return this.parse(text, true);
    }

    public int parseStrict(String text, int start, Date date) {
        return this.parse(text, start, date, true);
    }

    private void addPart(StringBuffer buf, int count) {
        if (buf.length() > 0) {
            this.patternParts.add(new PatternPart(buf.toString(), count));
            buf.setLength(0);
        }
    }

    private void format0To11Hours(StringBuffer buf, int count, Date date) {
        int value = date.getHours() % 12;
        this.zeroPaddingNumber(buf, value, count);
    }

    private void format0To23Hours(StringBuffer buf, int count, Date date) {
        int value = date.getHours();
        this.zeroPaddingNumber(buf, value, count);
    }

    private void format1To12Hours(StringBuffer buf, int count, Date date) {
        int value = date.getHours() % 12;
        if (value == 0) {
            this.zeroPaddingNumber(buf, 12, count);
        } else {
            this.zeroPaddingNumber(buf, value, count);
        }
    }

    private void format24Hours(StringBuffer buf, int count, Date date) {
        int value = date.getHours();
        if (value == 0) {
            this.zeroPaddingNumber(buf, 24, count);
        } else {
            this.zeroPaddingNumber(buf, value, count);
        }
    }

    private void formatAmPm(StringBuffer buf, Date date) {
        if (date.getHours() >= 12 && date.getHours() < 24) {
            buf.append(this.dateTimeFormatInfo.ampms()[1]);
        } else {
            buf.append(this.dateTimeFormatInfo.ampms()[0]);
        }
    }

    private void formatDate(StringBuffer buf, int count, Date date) {
        int value = date.getDate();
        this.zeroPaddingNumber(buf, value, count);
    }

    private void formatDayOfWeek(StringBuffer buf, int count, Date date) {
        int value = date.getDay();
        if (count == 5) {
            buf.append(this.dateTimeFormatInfo.weekdaysNarrow()[value]);
        } else if (count == 4) {
            buf.append(this.dateTimeFormatInfo.weekdaysFull()[value]);
        } else {
            buf.append(this.dateTimeFormatInfo.weekdaysShort()[value]);
        }
    }

    private void formatEra(StringBuffer buf, int count, Date date) {
        int value;
        int n = value = date.getYear() >= -1900 ? 1 : 0;
        if (count >= 4) {
            buf.append(this.dateTimeFormatInfo.erasFull()[value]);
        } else {
            buf.append(this.dateTimeFormatInfo.erasShort()[value]);
        }
    }

    private void formatFractionalSeconds(StringBuffer buf, int count, Date date) {
        int value;
        long time = date.getTime();
        if (time < 0L) {
            value = 1000 - (int)(-time % 1000L);
            if (value == 1000) {
                value = 0;
            }
        } else {
            value = (int)(time % 1000L);
        }
        if (count == 1) {
            value = Math.min((value + 50) / 100, 9);
            buf.append((char)(48 + value));
        } else if (count == 2) {
            value = Math.min((value + 5) / 10, 99);
            this.zeroPaddingNumber(buf, value, 2);
        } else {
            this.zeroPaddingNumber(buf, value, 3);
            if (count > 3) {
                this.zeroPaddingNumber(buf, 0, count - 3);
            }
        }
    }

    private void formatMinutes(StringBuffer buf, int count, Date date) {
        int value = date.getMinutes();
        this.zeroPaddingNumber(buf, value, count);
    }

    private void formatMonth(StringBuffer buf, int count, Date date) {
        int value = date.getMonth();
        switch (count) {
            case 5: {
                buf.append(this.dateTimeFormatInfo.monthsNarrow()[value]);
                break;
            }
            case 4: {
                buf.append(this.dateTimeFormatInfo.monthsFull()[value]);
                break;
            }
            case 3: {
                buf.append(this.dateTimeFormatInfo.monthsShort()[value]);
                break;
            }
            default: {
                this.zeroPaddingNumber(buf, value + 1, count);
            }
        }
    }

    private void formatQuarter(StringBuffer buf, int count, Date date) {
        int value = date.getMonth() / 3;
        if (count < 4) {
            buf.append(this.dateTimeFormatInfo.quartersShort()[value]);
        } else {
            buf.append(this.dateTimeFormatInfo.quartersFull()[value]);
        }
    }

    private void formatSeconds(StringBuffer buf, int count, Date date) {
        int value = date.getSeconds();
        this.zeroPaddingNumber(buf, value, count);
    }

    private void formatStandaloneDay(StringBuffer buf, int count, Date date) {
        int value = date.getDay();
        if (count == 5) {
            buf.append(this.dateTimeFormatInfo.weekdaysNarrowStandalone()[value]);
        } else if (count == 4) {
            buf.append(this.dateTimeFormatInfo.weekdaysFullStandalone()[value]);
        } else if (count == 3) {
            buf.append(this.dateTimeFormatInfo.weekdaysShortStandalone()[value]);
        } else {
            this.zeroPaddingNumber(buf, value, 1);
        }
    }

    private void formatStandaloneMonth(StringBuffer buf, int count, Date date) {
        int value = date.getMonth();
        if (count == 5) {
            buf.append(this.dateTimeFormatInfo.monthsNarrowStandalone()[value]);
        } else if (count == 4) {
            buf.append(this.dateTimeFormatInfo.monthsFullStandalone()[value]);
        } else if (count == 3) {
            buf.append(this.dateTimeFormatInfo.monthsShortStandalone()[value]);
        } else {
            this.zeroPaddingNumber(buf, value + 1, count);
        }
    }

    private void formatTimeZone(StringBuffer buf, int count, Date date, TimeZone timeZone) {
        if (count < 4) {
            buf.append(timeZone.getShortName(date));
        } else {
            buf.append(timeZone.getLongName(date));
        }
    }

    private void formatTimeZoneRFC(StringBuffer buf, int count, Date date, TimeZone timeZone) {
        if (count < 3) {
            buf.append(timeZone.getRFCTimeZoneString(date));
        } else if (count == 3) {
            buf.append(timeZone.getISOTimeZoneString(date));
        } else {
            buf.append(timeZone.getGMTString(date));
        }
    }

    private void formatYear(StringBuffer buf, int count, Date date) {
        int value = date.getYear() + 1900;
        if (value < 0) {
            value = -value;
        }
        switch (count) {
            case 1: {
                buf.append(value);
                break;
            }
            case 2: {
                this.zeroPaddingNumber(buf, value % 100, 2);
                break;
            }
            default: {
                this.zeroPaddingNumber(buf, value, count);
            }
        }
    }

    private int getNextCharCountInPattern(String pattern, int start) {
        int next;
        char ch = pattern.charAt(start);
        for (next = start + 1; next < pattern.length() && pattern.charAt(next) == ch; ++next) {
        }
        return next - start;
    }

    private void identifyAbutStart() {
        boolean abut = false;
        int len = this.patternParts.size();
        for (int i = 0; i < len; ++i) {
            if (this.isNumeric(this.patternParts.get(i))) {
                if (abut || i + 1 >= len || !this.isNumeric(this.patternParts.get(i + 1))) continue;
                abut = true;
                this.patternParts.get((int)i).abutStart = true;
                continue;
            }
            abut = false;
        }
    }

    private boolean isNumeric(PatternPart part) {
        if (part.count <= 0) {
            return false;
        }
        int i = NUMERIC_FORMAT_CHARS.indexOf(part.text.charAt(0));
        return i > 1 || i >= 0 && part.count < 3;
    }

    private int matchString(String text, int start, String[] data, int[] pos) {
        int count = data.length;
        int bestMatchLength = 0;
        int bestMatch = -1;
        String textInLowerCase = text.substring(start).toLowerCase();
        for (int i = 0; i < count; ++i) {
            int length = data[i].length();
            if (length <= bestMatchLength || !textInLowerCase.startsWith(data[i].toLowerCase())) continue;
            bestMatch = i;
            bestMatchLength = length;
        }
        if (bestMatch >= 0) {
            pos[0] = start + bestMatchLength;
        }
        return bestMatch;
    }

    private Date parse(String text, boolean strict) {
        Date curDate = new Date();
        Date date = new Date(curDate.getYear(), curDate.getMonth(), curDate.getDate());
        int charsConsumed = this.parse(text, 0, date, strict);
        if (charsConsumed == 0 || charsConsumed < text.length()) {
            throw new IllegalArgumentException(text);
        }
        return date;
    }

    private int parse(String text, int start, Date date, boolean strict) {
        DateRecord cal = new DateRecord();
        int[] parsePos = new int[]{start};
        int abutPat = -1;
        int abutStart = 0;
        int abutPass = 0;
        for (int i = 0; i < this.patternParts.size(); ++i) {
            PatternPart part = this.patternParts.get(i);
            if (part.count > 0) {
                if (abutPat < 0 && part.abutStart) {
                    abutPat = i;
                    abutStart = start;
                    abutPass = 0;
                }
                if (abutPat >= 0) {
                    int count = part.count;
                    if (i == abutPat && (count -= abutPass++) == 0) {
                        return 0;
                    }
                    if (this.subParse(text, parsePos, part, count, cal)) continue;
                    i = abutPat - 1;
                    parsePos[0] = abutStart;
                    continue;
                }
                abutPat = -1;
                if (this.subParse(text, parsePos, part, 0, cal)) continue;
                return 0;
            }
            abutPat = -1;
            if (part.text.charAt(0) == ' ') {
                int s = parsePos[0];
                this.skipSpace(text, parsePos);
                if (parsePos[0] > s) {
                    continue;
                }
            } else if (text.startsWith(part.text, parsePos[0])) {
                parsePos[0] = parsePos[0] + part.text.length();
                continue;
            }
            return 0;
        }
        if (!cal.calcDate(date, strict)) {
            return 0;
        }
        return parsePos[0] - start;
    }

    private int parseInt(String text, int[] pos) {
        int ret = 0;
        int ind = pos[0];
        if (ind >= text.length()) {
            return -1;
        }
        char ch = text.charAt(ind);
        while (ch >= '0' && ch <= '9') {
            ret = ret * 10 + (ch - 48);
            if (++ind >= text.length()) break;
            ch = text.charAt(ind);
        }
        if (ind > pos[0]) {
            pos[0] = ind;
        } else {
            ret = -1;
        }
        return ret;
    }

    private void parsePattern(String pattern) {
        StringBuffer buf = new StringBuffer(32);
        boolean inQuote = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == ' ') {
                this.addPart(buf, 0);
                buf.append(' ');
                this.addPart(buf, 0);
                while (i + 1 < pattern.length() && pattern.charAt(i + 1) == ' ') {
                    ++i;
                }
                continue;
            }
            if (inQuote) {
                if (ch == '\'') {
                    if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                        buf.append(ch);
                        ++i;
                        continue;
                    }
                    inQuote = false;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            if (PATTERN_CHARS.indexOf(ch) > 0) {
                this.addPart(buf, 0);
                buf.append(ch);
                int count = this.getNextCharCountInPattern(pattern, i);
                this.addPart(buf, count);
                i += count - 1;
                continue;
            }
            if (ch == '\'') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                    buf.append('\'');
                    ++i;
                    continue;
                }
                inQuote = true;
                continue;
            }
            buf.append(ch);
        }
        this.addPart(buf, 0);
        this.identifyAbutStart();
    }

    private boolean parseTimeZoneOffset(String text, int[] pos, DateRecord cal) {
        int offset;
        int sign;
        if (pos[0] >= text.length()) {
            cal.setTzOffset(0);
            return true;
        }
        switch (text.charAt(pos[0])) {
            case '+': {
                sign = 1;
                break;
            }
            case '-': {
                sign = -1;
                break;
            }
            default: {
                cal.setTzOffset(0);
                return true;
            }
        }
        pos[0] = pos[0] + 1;
        int st = pos[0];
        int value = this.parseInt(text, pos);
        if (value == 0 && pos[0] == st) {
            return false;
        }
        if (pos[0] < text.length() && text.charAt(pos[0]) == ':') {
            offset = value * 60;
            pos[0] = pos[0] + 1;
            st = pos[0];
            value = this.parseInt(text, pos);
            if (value == 0 && pos[0] == st) {
                return false;
            }
            offset += value;
        } else {
            offset = value;
            offset = offset < 24 && pos[0] - st <= 2 ? (offset *= 60) : offset % 100 + offset / 100 * 60;
        }
        cal.setTzOffset(-(offset *= sign));
        return true;
    }

    private void skipSpace(String text, int[] pos) {
        while (pos[0] < text.length() && WHITE_SPACE.indexOf(text.charAt(pos[0])) >= 0) {
            pos[0] = pos[0] + 1;
        }
    }

    private boolean subFormat(StringBuffer buf, char ch, int count, Date date, Date adjustedDate, Date adjustedTime, TimeZone timezone) {
        switch (ch) {
            case 'G': {
                this.formatEra(buf, count, adjustedDate);
                break;
            }
            case 'y': {
                this.formatYear(buf, count, adjustedDate);
                break;
            }
            case 'M': {
                this.formatMonth(buf, count, adjustedDate);
                break;
            }
            case 'k': {
                this.format24Hours(buf, count, adjustedTime);
                break;
            }
            case 'S': {
                this.formatFractionalSeconds(buf, count, adjustedTime);
                break;
            }
            case 'E': {
                this.formatDayOfWeek(buf, count, adjustedDate);
                break;
            }
            case 'a': {
                this.formatAmPm(buf, adjustedTime);
                break;
            }
            case 'h': {
                this.format1To12Hours(buf, count, adjustedTime);
                break;
            }
            case 'K': {
                this.format0To11Hours(buf, count, adjustedTime);
                break;
            }
            case 'H': {
                this.format0To23Hours(buf, count, adjustedTime);
                break;
            }
            case 'c': {
                this.formatStandaloneDay(buf, count, adjustedDate);
                break;
            }
            case 'L': {
                this.formatStandaloneMonth(buf, count, adjustedDate);
                break;
            }
            case 'Q': {
                this.formatQuarter(buf, count, adjustedDate);
                break;
            }
            case 'd': {
                this.formatDate(buf, count, adjustedDate);
                break;
            }
            case 'm': {
                this.formatMinutes(buf, count, adjustedTime);
                break;
            }
            case 's': {
                this.formatSeconds(buf, count, adjustedTime);
                break;
            }
            case 'z': {
                this.formatTimeZone(buf, count, date, timezone);
                break;
            }
            case 'v': {
                buf.append(timezone.getID());
                break;
            }
            case 'Z': {
                this.formatTimeZoneRFC(buf, count, date, timezone);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean subParse(String text, int[] pos, PatternPart part, int digitCount, DateRecord cal) {
        this.skipSpace(text, pos);
        int start = pos[0];
        char ch = part.text.charAt(0);
        int value = -1;
        if (this.isNumeric(part)) {
            if (digitCount > 0) {
                if (start + digitCount > text.length()) {
                    return false;
                }
                value = this.parseInt(text.substring(0, start + digitCount), pos);
            } else {
                value = this.parseInt(text, pos);
            }
        }
        switch (ch) {
            case 'G': {
                value = this.matchString(text, start, this.dateTimeFormatInfo.erasFull(), pos);
                cal.setEra(value);
                return true;
            }
            case 'M': {
                return this.subParseMonth(text, pos, cal, value, start);
            }
            case 'L': {
                return this.subParseStandaloneMonth(text, pos, cal, value, start);
            }
            case 'E': {
                return this.subParseDayOfWeek(text, pos, start, cal);
            }
            case 'c': {
                return this.subParseStandaloneDay(text, pos, start, cal);
            }
            case 'a': {
                value = this.matchString(text, start, this.dateTimeFormatInfo.ampms(), pos);
                cal.setAmpm(value);
                return true;
            }
            case 'y': {
                return this.subParseYear(text, pos, start, value, part, cal);
            }
            case 'd': {
                if (value <= 0) {
                    return false;
                }
                cal.setDayOfMonth(value);
                return true;
            }
            case 'S': {
                if (value < 0) {
                    return false;
                }
                return this.subParseFractionalSeconds(value, start, pos[0], cal);
            }
            case 'h': {
                if (value == 12) {
                    value = 0;
                }
            }
            case 'H': 
            case 'K': {
                if (value < 0) {
                    return false;
                }
                cal.setHours(value);
                return true;
            }
            case 'k': {
                if (value < 0) {
                    return false;
                }
                cal.setHours(value);
                return true;
            }
            case 'm': {
                if (value < 0) {
                    return false;
                }
                cal.setMinutes(value);
                return true;
            }
            case 's': {
                if (value < 0) {
                    return false;
                }
                cal.setSeconds(value);
                return true;
            }
            case 'Z': 
            case 'v': 
            case 'z': {
                return this.subParseTimeZoneInGMT(text, start, pos, cal);
            }
        }
        return false;
    }

    private boolean subParseDayOfWeek(String text, int[] pos, int start, DateRecord cal) {
        int value = this.matchString(text, start, this.dateTimeFormatInfo.weekdaysFull(), pos);
        if (value < 0) {
            value = this.matchString(text, start, this.dateTimeFormatInfo.weekdaysShort(), pos);
        }
        if (value < 0) {
            return false;
        }
        cal.setDayOfWeek(value);
        return true;
    }

    private boolean subParseFractionalSeconds(int value, int start, int end, DateRecord cal) {
        int i = end - start;
        if (i < 3) {
            while (i < 3) {
                value *= 10;
                ++i;
            }
        } else {
            int a = 1;
            while (i > 3) {
                a *= 10;
                --i;
            }
            value = (value + (a >> 1)) / a;
        }
        cal.setMilliseconds(value);
        return true;
    }

    private boolean subParseMonth(String text, int[] pos, DateRecord cal, int value, int start) {
        if (value < 0) {
            value = this.matchString(text, start, this.dateTimeFormatInfo.monthsFull(), pos);
            if (value < 0) {
                value = this.matchString(text, start, this.dateTimeFormatInfo.monthsShort(), pos);
            }
            if (value < 0) {
                return false;
            }
            cal.setMonth(value);
            return true;
        }
        if (value > 0) {
            cal.setMonth(value - 1);
            return true;
        }
        return false;
    }

    private boolean subParseStandaloneDay(String text, int[] pos, int start, DateRecord cal) {
        int value = this.matchString(text, start, this.dateTimeFormatInfo.weekdaysFullStandalone(), pos);
        if (value < 0) {
            value = this.matchString(text, start, this.dateTimeFormatInfo.weekdaysShortStandalone(), pos);
        }
        if (value < 0) {
            return false;
        }
        cal.setDayOfWeek(value);
        return true;
    }

    private boolean subParseStandaloneMonth(String text, int[] pos, DateRecord cal, int value, int start) {
        if (value < 0) {
            value = this.matchString(text, start, this.dateTimeFormatInfo.monthsFullStandalone(), pos);
            if (value < 0) {
                value = this.matchString(text, start, this.dateTimeFormatInfo.monthsShortStandalone(), pos);
            }
            if (value < 0) {
                return false;
            }
            cal.setMonth(value);
            return true;
        }
        if (value > 0) {
            cal.setMonth(value - 1);
            return true;
        }
        return false;
    }

    private boolean subParseTimeZoneInGMT(String text, int start, int[] pos, DateRecord cal) {
        if (text.startsWith(GMT, start)) {
            pos[0] = start + GMT.length();
            return this.parseTimeZoneOffset(text, pos, cal);
        }
        if (text.startsWith(UTC, start)) {
            pos[0] = start + UTC.length();
            return this.parseTimeZoneOffset(text, pos, cal);
        }
        return this.parseTimeZoneOffset(text, pos, cal);
    }

    private boolean subParseYear(String text, int[] pos, int start, int value, PatternPart part, DateRecord cal) {
        int ch = 32;
        if (value < 0) {
            if (pos[0] >= text.length()) {
                return false;
            }
            ch = text.charAt(pos[0]);
            if (ch != 43 && ch != 45) {
                return false;
            }
            pos[0] = pos[0] + 1;
            value = this.parseInt(text, pos);
            if (value < 0) {
                return false;
            }
            if (ch == 45) {
                value = -value;
            }
        }
        if (ch == 32 && pos[0] - start == 2 && part.count == 2) {
            Date date = new Date();
            int defaultCenturyStartYear = date.getYear() + 1900 - 80;
            int ambiguousTwoDigitYear = defaultCenturyStartYear % 100;
            cal.setAmbiguousYear(value == ambiguousTwoDigitYear);
            value += defaultCenturyStartYear / 100 * 100 + (value < ambiguousTwoDigitYear ? 100 : 0);
        }
        cal.setYear(value);
        return true;
    }

    private void zeroPaddingNumber(StringBuffer buf, int value, int minWidth) {
        int b = 10;
        for (int i = 0; i < minWidth - 1; ++i) {
            if (value < b) {
                buf.append('0');
            }
            b *= 10;
        }
        buf.append(value);
    }

    private static class PatternPart {
        public String text;
        public int count;
        public boolean abutStart;

        public PatternPart(String txt, int cnt) {
            this.text = txt;
            this.count = cnt;
            this.abutStart = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PredefinedFormat {
        ISO_8601,
        RFC_2822,
        DATE_FULL,
        DATE_LONG,
        DATE_MEDIUM,
        DATE_SHORT,
        TIME_FULL,
        TIME_LONG,
        TIME_MEDIUM,
        TIME_SHORT,
        DATE_TIME_FULL,
        DATE_TIME_LONG,
        DATE_TIME_MEDIUM,
        DATE_TIME_SHORT,
        DAY,
        HOUR_MINUTE,
        HOUR_MINUTE_SECOND,
        HOUR24_MINUTE,
        HOUR24_MINUTE_SECOND,
        MINUTE_SECOND,
        MONTH,
        MONTH_ABBR,
        MONTH_ABBR_DAY,
        MONTH_DAY,
        MONTH_NUM_DAY,
        MONTH_WEEKDAY_DAY,
        YEAR,
        YEAR_MONTH,
        YEAR_MONTH_ABBR,
        YEAR_MONTH_ABBR_DAY,
        YEAR_MONTH_DAY,
        YEAR_MONTH_NUM,
        YEAR_MONTH_NUM_DAY,
        YEAR_MONTH_WEEKDAY_DAY,
        YEAR_QUARTER,
        YEAR_QUARTER_ABBR;

    }
}

