/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.client.impl;

import java.io.Serializable;

final class ExceptionWrapper
implements Serializable {
    ExceptionWrapper causeWrapper;
    Throwable exception;
    StackTraceElement[] stackTrace;
    private transient boolean isExceptionInitialized;

    public ExceptionWrapper(Throwable exception) {
        this.exception = exception;
        this.stackTrace = exception.getStackTrace();
        Throwable cause = exception.getCause();
        if (cause != null) {
            this.causeWrapper = new ExceptionWrapper(cause);
        }
        this.isExceptionInitialized = true;
    }

    ExceptionWrapper() {
        this.isExceptionInitialized = false;
    }

    public Throwable getException() {
        if (!this.isExceptionInitialized) {
            this.exception.setStackTrace(this.stackTrace);
            if (this.causeWrapper != null) {
                this.exception.initCause(this.causeWrapper.getException());
            }
            this.isExceptionInitialized = true;
        }
        return this.exception;
    }
}

