/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.EditorContext;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.EditorVisitor;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;
import com.google.gwt.editor.client.impl.SimpleError;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

class ErrorCollector
extends EditorVisitor {
    private final Stack<List<EditorError>> errorStack = new Stack();
    private String lastAddedPath;
    private List<EditorError> lastAdded;

    public ErrorCollector(List<EditorError> errors) {
        assert (errors != null);
        this.errorStack.push(errors);
    }

    @Override
    public <T> void endVisit(EditorContext<T> ctx) {
        AbstractEditorDelegate delegate = (AbstractEditorDelegate)ctx.getEditorDelegate();
        if (delegate == null) {
            return;
        }
        List<EditorError> errors = delegate.getErrors();
        this.lastAdded = new ArrayList<EditorError>(errors);
        this.lastAddedPath = ctx.getAbsolutePath();
        this.errorStack.peek().addAll(errors);
        errors.clear();
        HasEditorErrors<T> asErrors = ctx.asHasEditorErrors();
        if (asErrors != null) {
            List<EditorError> tryConsume = this.errorStack.pop();
            int prefixLength = ctx.getAbsolutePath().length();
            for (EditorError error : tryConsume) {
                if (prefixLength > 0 && prefixLength < error.getAbsolutePath().length()) {
                    ((SimpleError)error).setPathPrefixLength(prefixLength + 1);
                    continue;
                }
                assert (prefixLength == 0 || error.getAbsolutePath().equals(ctx.getAbsolutePath()));
                ((SimpleError)error).setPathPrefixLength(prefixLength);
            }
            asErrors.showErrors(tryConsume);
            if (!tryConsume.isEmpty()) {
                List<EditorError> accumulator = this.errorStack.peek();
                for (EditorError e : tryConsume) {
                    if (e.isConsumed()) continue;
                    accumulator.add(e);
                }
            }
        }
    }

    public <Q> boolean visit(EditorContext<Q> ctx) {
        HasEditorErrors<Q> asErrors = ctx.asHasEditorErrors();
        if (asErrors != null) {
            if (ctx.getAbsolutePath().equals(this.lastAddedPath)) {
                this.errorStack.peek().removeAll(this.lastAdded);
                this.errorStack.push(this.lastAdded);
            } else {
                this.errorStack.push(new ArrayList());
            }
        }
        return true;
    }
}

