/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.builder.shared.TableCellBuilder;
import com.google.gwt.dom.builder.shared.TableRowBuilder;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.AbstractHeaderOrFooterBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.Header;

public class DefaultHeaderOrFooterBuilder<T>
extends AbstractHeaderOrFooterBuilder<T> {
    public DefaultHeaderOrFooterBuilder(AbstractCellTable<T> table, boolean isFooter) {
        super(table, isFooter);
    }

    @Override
    protected boolean buildHeaderOrFooterImpl() {
        int curColumn;
        AbstractCellTable table = this.getTable();
        boolean isFooter = this.isBuildingFooter();
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            return false;
        }
        boolean hasHeader = false;
        for (int i = 0; i < columnCount; ++i) {
            if (this.getHeader(i) == null) continue;
            hasHeader = true;
            break;
        }
        if (!hasHeader) {
            return false;
        }
        ColumnSortList sortList = table.getColumnSortList();
        ColumnSortList.ColumnSortInfo sortedInfo = sortList.size() == 0 ? null : sortList.get(0);
        Column<?, ?> sortedColumn = sortedInfo == null ? null : sortedInfo.getColumn();
        boolean isSortAscending = sortedInfo == null ? false : sortedInfo.isAscending();
        AbstractCellTable.Style style = this.getTable().getResources().style();
        String className = this.isBuildingFooter() ? style.footer() : style.header();
        String sortableStyle = " " + style.sortableHeader();
        String sortedStyle = " " + (isSortAscending ? style.sortedHeaderAscending() : style.sortedHeaderDescending());
        Header<?> prevHeader = this.getHeader(0);
        Column column = this.getTable().getColumn(0);
        int prevColspan = 1;
        boolean isSortable = false;
        boolean isSorted = false;
        StringBuilder classesBuilder = new StringBuilder(className);
        classesBuilder.append(" " + (isFooter ? style.firstColumnFooter() : style.firstColumnHeader()));
        if (!isFooter && column.isSortable()) {
            isSortable = true;
            isSorted = column == sortedColumn;
        }
        TableRowBuilder tr = this.startRow();
        for (curColumn = 1; curColumn < columnCount; ++curColumn) {
            Header<?> header = this.getHeader(curColumn);
            if (header != prevHeader) {
                if (isSortable) {
                    classesBuilder.append(sortableStyle);
                }
                if (isSorted) {
                    classesBuilder.append(sortedStyle);
                }
                this.appendExtraStyles(prevHeader, classesBuilder);
                TableCellBuilder th = (TableCellBuilder)tr.startTH().colSpan(prevColspan).className(classesBuilder.toString());
                this.enableColumnHandlers(th, column);
                if (prevHeader != null) {
                    Cell.Context context = new Cell.Context(0, curColumn - prevColspan, prevHeader.getKey());
                    if (isSortable) {
                        th.attribute("role", "button");
                        th.tabIndex(-1);
                    }
                    this.renderSortableHeader(th, context, prevHeader, isSorted, isSortAscending);
                }
                th.endTH();
                prevHeader = header;
                prevColspan = 1;
                classesBuilder = new StringBuilder(className);
                isSortable = false;
                isSorted = false;
            } else {
                ++prevColspan;
            }
            column = table.getColumn(curColumn);
            if (isFooter || !column.isSortable()) continue;
            isSortable = true;
            isSorted = column == sortedColumn;
        }
        if (isSortable) {
            classesBuilder.append(sortableStyle);
        }
        if (isSorted) {
            classesBuilder.append(sortedStyle);
        }
        classesBuilder.append(" ").append(isFooter ? style.lastColumnFooter() : style.lastColumnHeader());
        this.appendExtraStyles(prevHeader, classesBuilder);
        TableCellBuilder th = (TableCellBuilder)tr.startTH().colSpan(prevColspan).className(classesBuilder.toString());
        this.enableColumnHandlers(th, column);
        if (prevHeader != null) {
            Cell.Context context = new Cell.Context(0, curColumn - prevColspan, prevHeader.getKey());
            this.renderSortableHeader(th, context, prevHeader, isSorted, isSortAscending);
        }
        th.endTH();
        tr.endTR();
        return true;
    }

    private <H> void appendExtraStyles(Header<H> header, StringBuilder classesBuilder) {
        if (header == null) {
            return;
        }
        String headerStyleNames = header.getHeaderStyleNames();
        if (headerStyleNames != null) {
            classesBuilder.append(" ");
            classesBuilder.append(headerStyleNames);
        }
    }
}

